/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.awt.Point;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import workbench.db.ColumnIdentifier;
import workbench.db.ConnectionProfile;
import workbench.db.JdbcUtils;
import workbench.db.ResultBufferingController;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.exporter.BlobMode;
import workbench.db.exporter.ControlFileFormat;
import workbench.db.exporter.ExportDataModifier;
import workbench.db.exporter.ExportJobEntry;
import workbench.db.exporter.ExportType;
import workbench.db.exporter.ExportWriter;
import workbench.db.exporter.HtmlExportWriter;
import workbench.db.exporter.InfinityLiterals;
import workbench.db.exporter.JsonExportWriter;
import workbench.db.exporter.OdsExportWriter;
import workbench.db.exporter.SqlExportWriter;
import workbench.db.exporter.TextExportWriter;
import workbench.db.exporter.XlsExportWriter;
import workbench.db.exporter.XlsXMLExportWriter;
import workbench.db.exporter.XlsxExportWriter;
import workbench.db.exporter.XmlExportWriter;
import workbench.gui.dialogs.export.ExportOptions;
import workbench.gui.dialogs.export.HtmlOptions;
import workbench.gui.dialogs.export.SpreadSheetOptions;
import workbench.gui.dialogs.export.SqlOptions;
import workbench.gui.dialogs.export.TextOptions;
import workbench.gui.dialogs.export.XmlOptions;
import workbench.interfaces.Committer;
import workbench.interfaces.DbExecutionListener;
import workbench.interfaces.ErrorReporter;
import workbench.interfaces.InterruptableJob;
import workbench.interfaces.ProgressReporter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.storage.ResultInfo;
import workbench.storage.RowActionMonitor;
import workbench.util.CharacterEscapeType;
import workbench.util.CharacterRange;
import workbench.util.CollectionUtil;
import workbench.util.EncodingUtil;
import workbench.util.ExceptionUtil;
import workbench.util.MessageBuffer;
import workbench.util.QuoteEscapeType;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbDateFormatter;
import workbench.util.WbFile;
import workbench.util.WbNumberFormatter;
import workbench.util.WbThread;

public class DataExporter
implements InterruptableJob,
ErrorReporter,
ProgressReporter,
Committer,
ExportOptions,
TextOptions {
    private WbConnection dbConn;
    private String pageTitle;
    private WbFile realOutputfile;
    private WbFile outputfile;
    private String xsltFile;
    private Map<String, String> xsltParameters;
    private String transformOutputFile;
    private ExportType exportType = ExportType.TEXT;
    private String mergeType;
    private boolean exportHeaders;
    private String rowIndexColumnName;
    private boolean includeCreateTable;
    private boolean continueOnError;
    private boolean useCDATA;
    private String xmlVersion;
    private CharacterRange escapeRange;
    private String lineEnding = "\n";
    private String tableName;
    private String encoding;
    private List<ColumnIdentifier> columnsToExport;
    private boolean clobAsFile;
    private int clobSizeThreshold = -1;
    private String delimiter = "\t";
    private String quoteChar;
    private boolean quoteAlways;
    private String chrFunc;
    private String concatString = "||";
    private String concatFunction;
    private String filenameColumn;
    private int commitEvery = 0;
    private boolean useSchemaInSql;
    private boolean includeIdentityCols;
    private boolean includeReadOnlyCols;
    private InfinityLiterals infinityLiterals = InfinityLiterals.PG_LITERALS;
    private String dateFormat;
    private String timeFormat;
    private String dateTimeFormat;
    private SimpleDateFormat timeFormatter;
    private WbDateFormatter dateFormatter;
    private WbDateFormatter dateTimeFormatter;
    private WbNumberFormatter numberFormatter;
    private WbNumberFormatter integerFormatter;
    private boolean append;
    private int targetSheetIndex;
    private String targetSheetName;
    private boolean escapeHtml = true;
    private String htmlHeading;
    private String htmlTrailer;
    private boolean createFullHtmlPage = true;
    private boolean verboseFormat = true;
    private int progressInterval = 10;
    private boolean cancelJobs;
    private RowActionMonitor rowMonitor;
    private List<String> keyColumnsToUse;
    private String dateLiteralType;
    private Statement currentStatement;
    private List<String> blobIdCols;
    private MessageBuffer warnings = new MessageBuffer();
    private MessageBuffer errors = new MessageBuffer();
    private List<ExportJobEntry> jobQueue;
    private ExportWriter exportWriter;
    private int tablesExported;
    private long totalRows;
    private Set<ControlFileFormat> controlFiles = EnumSet.noneOf(ControlFileFormat.class);
    private boolean compressOutput;
    private List<DbExecutionListener> listener = new ArrayList<DbExecutionListener>();
    private ExportDataModifier modifier;
    private boolean includeColumnComments;
    private String nullString;
    private int maxBlobFilesPerDir = -1;
    private boolean trimCharData;
    private boolean quoteHeader;
    private boolean quoteNulls;
    private boolean useMultiRowInserts;
    private Point dataOffset;
    private Locale localeToUse;
    private final ResultBufferingController bufferController;
    private boolean appendInfoSheet;
    private boolean optimizeCols;
    private boolean enableAutoFilter;
    private boolean enableFixedHeader;
    private boolean writeEmptyResults = true;
    private ZipOutputStream zipArchive;
    private ZipEntry zipEntry;
    private BlobMode blobMode;
    private QuoteEscapeType quoteEscape = QuoteEscapeType.none;
    private CharacterEscapeType escapeType = CharacterEscapeType.unicode;

    public DataExporter(WbConnection wbConnection) {
        ConnectionProfile connectionProfile;
        this.dbConn = wbConnection;
        this.jobQueue = new ArrayList<ExportJobEntry>();
        this.useSchemaInSql = Settings.getInstance().getIncludeOwnerInSqlExport();
        this.numberFormatter = Settings.getInstance().createDefaultDecimalFormatter(0);
        this.setExportHeaders(Settings.getInstance().getBoolProperty("workbench.export.text.default.header", false));
        if (wbConnection != null && (connectionProfile = wbConnection.getProfile()) != null) {
            this.trimCharData = connectionProfile.getTrimCharData();
        }
        this.bufferController = new ResultBufferingController(wbConnection);
    }

    public void setLocale(Locale locale) {
        this.localeToUse = locale;
    }

    @Override
    public void setEscapeType(CharacterEscapeType characterEscapeType) {
        this.escapeType = characterEscapeType;
    }

    @Override
    public CharacterEscapeType getEscapeType() {
        return this.escapeType;
    }

    @Override
    public boolean getQuoteHeader() {
        return this.quoteHeader;
    }

    @Override
    public void setQuoteHeader(boolean bl) {
        this.quoteHeader = bl;
    }

    public boolean getQuoteNulls() {
        return this.quoteNulls;
    }

    public void setQuoteNulls(boolean bl) {
        this.quoteNulls = bl;
    }

    public boolean getUseMultiRowInserts() {
        return this.useMultiRowInserts;
    }

    public void setUseMultiRowInserts(boolean bl) {
        this.useMultiRowInserts = bl;
    }

    public boolean getIncludeIdentityCols() {
        return this.includeIdentityCols;
    }

    public void setIncludeIdentityCols(boolean bl) {
        this.includeIdentityCols = bl;
    }

    public boolean getIncludeReadOnlyCols() {
        return this.includeReadOnlyCols;
    }

    public void setIncludeReadOnlyCols(boolean bl) {
        this.includeReadOnlyCols = bl;
    }

    public boolean getTrimCharData() {
        return this.trimCharData;
    }

    public void setTrimCharData(boolean bl) {
        this.trimCharData = bl;
    }

    public String getMergeType() {
        return this.mergeType;
    }

    public void setMergeType(String string) {
        this.mergeType = string;
    }

    public boolean getEnableFixedHeader() {
        return this.enableFixedHeader;
    }

    public Point getSpreadSheetOffset() {
        return this.dataOffset;
    }

    public void setSpreadSheetOffset(Point point) {
        this.dataOffset = point;
    }

    @Override
    public String getNullString() {
        return this.nullString;
    }

    @Override
    public void setNullString(String string) {
        this.nullString = string;
    }

    public void setEnableFixedHeader(boolean bl) {
        this.enableFixedHeader = bl;
    }

    public boolean getEnableAutoFilter() {
        return this.enableAutoFilter;
    }

    public void setEnableAutoFilter(boolean bl) {
        this.enableAutoFilter = bl;
    }

    public boolean getAppendInfoSheet() {
        return this.appendInfoSheet;
    }

    public void setAppendInfoSheet(boolean bl) {
        this.appendInfoSheet = bl;
    }

    public boolean getOptimizeSpreadsheetColumns() {
        return this.optimizeCols;
    }

    public void setOptimizeSpreadsheetColumns(boolean bl) {
        this.optimizeCols = bl;
    }

    public void setIncludeColumnComments(boolean bl) {
        this.includeColumnComments = bl;
    }

    public boolean getIncludeColumnComments() {
        return this.includeColumnComments;
    }

    public String getRowIndexColumnName() {
        return this.rowIndexColumnName;
    }

    public ExportDataModifier getDataModifier() {
        return this.modifier;
    }

    public void setDataModifier(ExportDataModifier exportDataModifier) {
        this.modifier = exportDataModifier;
    }

    public void setRowIndexColumnName(String string) {
        this.rowIndexColumnName = string;
    }

    public void addExecutionListener(DbExecutionListener dbExecutionListener) {
        this.listener.add(dbExecutionListener);
    }

    public boolean getUseSchemaInSql() {
        return this.useSchemaInSql;
    }

    public void setUseSchemaInSql(boolean bl) {
        this.useSchemaInSql = bl;
    }

    public void setInfinityLiterals(InfinityLiterals infinityLiterals) {
        this.infinityLiterals = infinityLiterals;
    }

    public InfinityLiterals getInfinityLiterals() {
        return this.infinityLiterals;
    }

    public void setDateLiteralType(String string) {
        this.dateLiteralType = "dbms".equalsIgnoreCase(string) || string == null ? "dbms" : string.trim().toLowerCase();
    }

    public String getFilenameColumn() {
        return this.filenameColumn;
    }

    public void setFilenameColumn(String string) {
        this.filenameColumn = StringUtil.isBlank(string) ? null : string.trim();
    }

    public String getDateLiteralType() {
        return this.dateLiteralType;
    }

    public void setBlobMode(BlobMode blobMode) {
        this.blobMode = blobMode;
    }

    @Override
    public BlobMode getBlobMode() {
        return this.blobMode;
    }

    public void setWriteEmptyResults(boolean bl) {
        this.writeEmptyResults = bl;
    }

    public boolean writeEmptyResults() {
        return this.writeEmptyResults;
    }

    public int getClobSizeThreshold() {
        return this.clobSizeThreshold;
    }

    public void setWriteClobAsFile(boolean bl, int n) {
        this.clobAsFile = bl;
        this.clobSizeThreshold = n;
    }

    public boolean getWriteClobAsFile() {
        return this.clobAsFile;
    }

    public boolean getCompressOutput() {
        return this.compressOutput;
    }

    public void setCompressOutput(boolean bl) {
        this.compressOutput = bl;
    }

    public void addTableExportJob(File file, TableIdentifier tableIdentifier) throws SQLException {
        this.addTableExportJob(file, tableIdentifier, null);
    }

    public void addTableExportJob(File file, TableIdentifier tableIdentifier, String string) throws SQLException {
        ExportJobEntry exportJobEntry = new ExportJobEntry(file, tableIdentifier, string, this.dbConn);
        this.jobQueue.add(exportJobEntry);
    }

    public void setQuoteEscaping(QuoteEscapeType quoteEscapeType) {
        this.quoteEscape = quoteEscapeType;
    }

    @Override
    public QuoteEscapeType getQuoteEscaping() {
        return this.quoteEscape;
    }

    public WbConnection getConnection() {
        return this.dbConn;
    }

    @Override
    public boolean confirmCancel() {
        return true;
    }

    @Override
    public void cancelCurrent() {
        if (this.exportWriter != null) {
            this.exportWriter.cancel();
        }
    }

    @Override
    public void cancelExecution() {
        this.cancelJobs = true;
        SqlUtil.cancelStatement(new CallerInfo(){}, this.currentStatement);
        this.cancelCurrent();
        this.addWarning(ResourceMgr.getString("MsgExportCancelled"));
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableNameToUse() {
        TableIdentifier tableIdentifier;
        if (this.tableName != null) {
            return this.tableName;
        }
        ResultInfo resultInfo = this.exportWriter.getConverter().getResultInfo();
        if (resultInfo != null && (tableIdentifier = resultInfo.getUpdateTable()) != null) {
            return tableIdentifier.getTableName();
        }
        return "";
    }

    @Override
    public void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public void setRowMonitor(RowActionMonitor rowActionMonitor) {
        this.rowMonitor = rowActionMonitor;
    }

    public void setMaxLobFilesPerDirectory(int n) {
        this.maxBlobFilesPerDir = n;
    }

    public int getMaxLobFilesPerDirectory() {
        return this.maxBlobFilesPerDir;
    }

    public void setBlobIdColumns(List<String> list) {
        this.blobIdCols = list == null ? null : new ArrayList<String>(list);
    }

    List<String> getBlobIdColumns() {
        return this.blobIdCols;
    }

    public List<ColumnIdentifier> getColumnsToExport() {
        return this.columnsToExport;
    }

    public void setUseCDATA(boolean bl) {
        this.useCDATA = bl;
    }

    public boolean getUseCDATA() {
        return this.useCDATA;
    }

    public void setAppendToFile(boolean bl) {
        this.append = bl;
    }

    public boolean getAppendToFile() {
        return this.append;
    }

    public int getTargetSheetIndex() {
        return this.targetSheetIndex;
    }

    public void setTargetSheetIndex(int n) {
        this.targetSheetIndex = n;
    }

    public String getTargetSheetName() {
        return this.targetSheetName;
    }

    public void setTargetSheetName(String string) {
        this.targetSheetName = string;
    }

    public void setContinueOnError(boolean bl) {
        this.continueOnError = bl;
    }

    public boolean getContinueOnError() {
        return this.continueOnError;
    }

    @Override
    public void commitNothing() {
        this.commitEvery = Integer.MIN_VALUE;
    }

    @Override
    public void setCommitEvery(int n) {
        this.commitEvery = n;
    }

    public int getCommitEvery() {
        return this.commitEvery;
    }

    public ExportType getExportType() {
        return this.exportType;
    }

    public String getTypeDisplay() {
        if (this.exportType == null) {
            return "";
        }
        return this.exportType.toString();
    }

    @Override
    public void setReportInterval(int n) {
        this.progressInterval = n <= 0 ? 0 : n;
    }

    public void setXsltParameters(Map<String, String> hashMap) {
        this.xsltParameters = hashMap == null ? new HashMap(0) : hashMap;
    }

    public Map<String, String> getXsltParameters() {
        return this.xsltParameters;
    }

    public void setXsltTransformation(String string) {
        this.xsltFile = string;
    }

    public String getXsltTransformation() {
        return this.xsltFile;
    }

    public void setXsltTransformationOutput(String string) {
        this.transformOutputFile = string;
    }

    public String getXsltTransformationOutput() {
        return this.transformOutputFile;
    }

    @Override
    public final void setExportHeaders(boolean bl) {
        this.exportHeaders = bl;
    }

    @Override
    public boolean getExportHeaders() {
        return this.exportHeaders;
    }

    public void setHtmlHeading(String string) {
        this.htmlHeading = string;
    }

    public String getHtmlHeading() {
        return this.htmlHeading;
    }

    public void setHtmlTrailer(String string) {
        this.htmlTrailer = string;
    }

    public String getHtmlTrailer() {
        return this.htmlTrailer;
    }

    public void setCreateFullHtmlPage(boolean bl) {
        this.createFullHtmlPage = bl;
    }

    public boolean getCreateFullHtmlPage() {
        return this.createFullHtmlPage;
    }

    public void setEscapeHtml(boolean bl) {
        this.escapeHtml = bl;
    }

    public boolean getEscapeHtml() {
        return this.escapeHtml;
    }

    @Override
    public void setTextDelimiter(String string) {
        if (StringUtil.isNonBlank(string)) {
            this.delimiter = string;
        }
    }

    @Override
    public String getTextDelimiter() {
        return this.delimiter;
    }

    @Override
    public void setTextQuoteChar(String string) {
        this.quoteChar = string;
    }

    @Override
    public String getTextQuoteChar() {
        return this.quoteChar;
    }

    public void setTimeFormat(String string) {
        this.timeFormat = StringUtil.isBlank(string) ? null : string;
        try {
            Locale locale = this.localeToUse == null ? Locale.getDefault(Locale.Category.FORMAT) : this.localeToUse;
            this.timeFormatter = new SimpleDateFormat(this.timeFormat == null ? Settings.getInstance().getDefaultTimeFormat() : this.timeFormat, locale);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.addWarning(ResourceMgr.getFormattedString("MsgIllegalDateFormatIgnored", this.timeFormat));
            this.timeFormatter = null;
        }
    }

    public SimpleDateFormat getTimeFormatter() {
        return this.timeFormatter;
    }

    @Override
    public void setDateFormat(String string) {
        this.dateFormat = StringUtil.isBlank(string) ? null : string;
        try {
            this.dateFormatter = new WbDateFormatter(this.dateFormat == null ? Settings.getInstance().getDefaultDateFormat() : this.dateFormat, this.localeToUse);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.addWarning(ResourceMgr.getFormattedString("MsgIllegalDateFormatIgnored", this.dateFormat));
            this.dateFormatter = null;
        }
    }

    public WbDateFormatter getDateFormatter() {
        return this.dateFormatter;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void setTimestampFormat(String string) {
        this.dateTimeFormat = StringUtil.isBlank(string) ? null : string;
        try {
            this.dateTimeFormatter = new WbDateFormatter(this.dateTimeFormat == null ? Settings.getInstance().getDefaultTimestampFormat() : this.dateTimeFormat, this.localeToUse);
        }
        catch (Exception exception) {
            this.addWarning(ResourceMgr.getFormattedString("MsgIllegalDateFormatIgnored", this.dateTimeFormat));
            this.dateTimeFormatter = null;
        }
    }

    @Override
    public String getTimestampFormat() {
        return this.dateTimeFormat;
    }

    public WbDateFormatter getTimestampFormatter() {
        return this.dateTimeFormatter;
    }

    private void createExportWriter() {
        switch (this.exportType) {
            case HTML: {
                this.exportWriter = new HtmlExportWriter(this);
                break;
            }
            case SQL_INSERT: 
            case SQL_UPDATE: 
            case SQL_DELETE_INSERT: 
            case SQL_INSERT_IGNORE: 
            case SQL_DELETE: 
            case SQL_MERGE: {
                this.exportWriter = new SqlExportWriter(this);
                break;
            }
            case TEXT: {
                this.exportWriter = new TextExportWriter(this);
                break;
            }
            case XML: {
                this.exportWriter = new XmlExportWriter(this);
                break;
            }
            case XLS: {
                this.exportWriter = new XlsExportWriter(this);
                break;
            }
            case XLSX: {
                this.exportWriter = new XlsxExportWriter(this);
                break;
            }
            case XLSM: {
                this.exportWriter = new XlsXMLExportWriter(this);
                break;
            }
            case ODS: {
                this.exportWriter = new OdsExportWriter(this);
                break;
            }
            case JSON: {
                this.exportWriter = new JsonExportWriter(this);
            }
        }
    }

    public void setPageTitle(String string) {
        this.pageTitle = string;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public void setOutputType(ExportType exportType) {
        this.exportType = exportType;
        this.createExportWriter();
    }

    public WbFile getOutputFile() {
        return this.outputfile;
    }

    public String getFullOutputFilename() {
        if (this.realOutputfile == null) {
            return null;
        }
        return this.realOutputfile.getFullPath();
    }

    public void setConcatString(String string) {
        if (string == null) {
            return;
        }
        this.concatString = string;
        this.concatFunction = null;
    }

    public String getConcatString() {
        return this.concatString;
    }

    public void setChrFunction(String string) {
        this.chrFunc = string;
    }

    public String getChrFunction() {
        return this.chrFunc;
    }

    @Override
    public void setDecimalSymbol(String string) {
        if (StringUtil.isNonBlank(string)) {
            this.numberFormatter = new WbNumberFormatter(string.charAt(0));
        }
    }

    public void setIntegerFormatString(String string, String string2, String string3) {
        if (StringUtil.isNonBlank(string)) {
            this.integerFormatter = this.createFormatter(string, string2, string3);
        }
    }

    public void setDecimalFormatString(String string, String string2, String string3) {
        if (StringUtil.isNonBlank(string)) {
            this.numberFormatter = this.createFormatter(string, string2, string3);
        }
    }

    public WbNumberFormatter createFormatter(String string, String string2, String string3) {
        if (string2 == null) {
            string2 = Settings.getInstance().getDecimalSymbol();
        }
        if (string3 == null) {
            string3 = Settings.getInstance().getDecimalGroupCharacter();
        }
        return new WbNumberFormatter(string, string2.charAt(0), string3.charAt(0));
    }

    public void setDecimalDigits(int n, String string, boolean bl) {
        if (StringUtil.isNonBlank(string)) {
            this.numberFormatter = new WbNumberFormatter(n, string.charAt(0), bl);
        }
    }

    public WbNumberFormatter getIntegerFormatter() {
        return this.integerFormatter;
    }

    public WbNumberFormatter getDecimalFormatter() {
        return this.numberFormatter;
    }

    @Override
    public String getDecimalSymbol() {
        if (this.numberFormatter == null) {
            return null;
        }
        return Character.toString(this.numberFormatter.getDecimalSymbol());
    }

    public void addQueryJob(String string, WbFile wbFile, String string2) {
        ExportJobEntry exportJobEntry = new ExportJobEntry((File)wbFile, string, string2, this.getConnection());
        this.jobQueue.add(exportJobEntry);
    }

    public int getNumberExportedTables() {
        return this.tablesExported;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    protected void fireExecutionStart() {
        for (DbExecutionListener dbExecutionListener : this.listener) {
            dbExecutionListener.executionStart(this.dbConn, this);
        }
    }

    protected void fireExecutionEnd() {
        for (DbExecutionListener dbExecutionListener : this.listener) {
            dbExecutionListener.executionEnd(this.dbConn, this);
        }
    }

    public void startBackgroundExport() {
        WbThread wbThread = new WbThread("Export Jobs"){

            @Override
            public void run() {
                try {
                    DataExporter.this.runJobs();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        wbThread.setPriority(1);
        wbThread.start();
    }

    public long startExport() throws IOException, SQLException {
        this.runJobs();
        return this.totalRows;
    }

    public void finished() {
        this.bufferController.restoreDriverBuffering();
    }

    public void prepareExport() {
        this.bufferController.disableDriverBuffering();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJobs() {
        if (this.jobQueue == null) {
            return;
        }
        int n = this.jobQueue.size();
        this.cancelJobs = false;
        this.tablesExported = 0;
        this.totalRows = 0L;
        if (this.exportWriter == null) {
            this.createExportWriter();
        }
        this.fireExecutionStart();
        try {
            for (int i = 0; i < n; ++i) {
                ExportJobEntry exportJobEntry = this.jobQueue.get(i);
                if (this.rowMonitor != null && exportJobEntry.getTable() != null) {
                    this.rowMonitor.setCurrentObject(exportJobEntry.getTable().getTableName(), i + 1, n);
                }
                if (this.append && this.exportWriter.managesOutput() && (this.pageTitle == null || n > 1)) {
                    this.pageTitle = exportJobEntry.getTable().getTableExpression(this.dbConn);
                }
                try {
                    this.totalRows += this.runJob(exportJobEntry);
                    ++this.tablesExported;
                }
                catch (Throwable throwable) {
                    LogMgr.logError(new CallerInfo(){}, "Error exporting data for [" + exportJobEntry.getQuerySql() + "] to file: " + this.outputfile, throwable);
                    this.addError(throwable.getMessage());
                    if (!this.continueOnError) break;
                }
                if (this.cancelJobs) break;
            }
            if (this.rowMonitor != null) {
                this.rowMonitor.jobFinished();
            }
        }
        finally {
            this.bufferController.restoreDriverBuffering();
            this.fireExecutionEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long runJob(ExportJobEntry exportJobEntry) throws IOException, SQLException {
        if (this.currentStatement != null) {
            JdbcUtils.closeStatement(this.currentStatement);
        }
        this.currentStatement = this.dbConn.createStatementForQuery();
        ResultSet resultSet = null;
        long l = 0L;
        boolean bl = false;
        try {
            this.outputfile = exportJobEntry.getOutputFile();
            if (!this.dbConn.isBusy()) {
                this.dbConn.setBusy(true);
                bl = true;
            }
            this.bufferController.initializeStatement(this.currentStatement);
            this.currentStatement.execute(exportJobEntry.getQuerySql());
            resultSet = this.currentStatement.getResultSet();
            l = this.startExport(resultSet, exportJobEntry.getResultInfo(), exportJobEntry.getQuerySql());
        }
        catch (Exception exception) {
            block9: {
                try {
                    this.addError(ResourceMgr.getString("ErrExportExecute"));
                    this.addError(ExceptionUtil.getDisplay(exception));
                    LogMgr.logError(new CallerInfo(){}, "Could not execute SQL statement: " + exportJobEntry.getQuerySql() + ", Error: " + ExceptionUtil.getDisplay(exception), exception);
                    if (this.dbConn.getAutoCommit() || !this.dbConn.selectStartsTransaction()) break block9;
                    this.dbConn.rollbackSilently();
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, this.currentStatement);
                    if (bl) {
                        this.dbConn.setBusy(false);
                    }
                    this.currentStatement = null;
                    throw throwable;
                }
            }
            JdbcUtils.closeAll(resultSet, this.currentStatement);
            if (bl) {
                this.dbConn.setBusy(false);
            }
            this.currentStatement = null;
        }
        JdbcUtils.closeAll(resultSet, this.currentStatement);
        if (bl) {
            this.dbConn.setBusy(false);
        }
        this.currentStatement = null;
        return l;
    }

    public boolean isSuccess() {
        return this.errors.getLength() == 0;
    }

    public boolean hasWarning() {
        return this.warnings.getLength() > 0;
    }

    public CharSequence getErrors() {
        return this.errors.getBuffer();
    }

    public CharSequence getWarnings() {
        return this.warnings.getBuffer();
    }

    @Override
    public void addWarning(String string) {
        this.warnings.append(string);
        this.warnings.appendNewLine();
    }

    @Override
    public void addError(String string) {
        this.errors.append(string);
        this.errors.appendNewLine();
    }

    public long exportResultSet(WbFile wbFile, ResultSet resultSet, String string) throws IOException, SQLException, Exception {
        this.outputfile = wbFile;
        return this.startExport(resultSet, null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long startExport(ResultSet resultSet, ResultInfo resultInfo, String string) throws IOException, SQLException, Exception {
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            ResultInfo resultInfo2 = new ResultInfo(resultSetMetaData, this.dbConn);
            if (resultInfo != null) {
                for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
                    int n = resultInfo2.findColumn(resultInfo.getColumnName(i));
                    if (n <= -1) continue;
                    resultInfo.setColumnClassName(i, resultInfo2.getColumnClassName(i));
                }
            }
            this.configureExportWriter();
            this.exportWriter.exportStarting();
            this.exportWriter.writeExport(resultSet, resultInfo == null ? resultInfo2 : resultInfo, string);
        }
        finally {
            this.exportFinished();
            JdbcUtils.closeResult(resultSet);
        }
        long l = this.exportWriter.getNumberOfRecords();
        String string2 = "Exported " + l + " rows to " + this.outputfile;
        String string3 = this.exportWriter.getConverter().getTargetFileDetails();
        if (string3 != null) {
            string2 = string2 + " (" + string3 + ")";
        }
        LogMgr.logInfo(new CallerInfo(){}, string2);
        return l;
    }

    public long startExport(WbFile wbFile, DataStore dataStore, List<ColumnIdentifier> list) throws IOException, SQLException, Exception {
        try {
            this.outputfile = wbFile;
            this.configureExportWriter();
            this.exportWriter.exportStarting();
            this.exportWriter.writeExport(dataStore, list);
        }
        catch (Exception exception) {
            this.addError(ExceptionUtil.getDisplay(exception));
            LogMgr.logError(new CallerInfo(){}, "Could not export data", exception);
            throw exception;
        }
        finally {
            this.exportFinished();
        }
        long l = this.exportWriter.getNumberOfRecords();
        return l;
    }

    private void exportFinished() {
        long l = -1L;
        if (this.exportWriter != null) {
            l = this.exportWriter.exportFinished();
        }
        if (this.zipArchive != null) {
            try {
                this.zipArchive.close();
                this.zipArchive = null;
                this.zipEntry = null;
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error closing ZIP archive", exception);
            }
        }
        if (l <= 0L && !this.writeEmptyResults && !this.append) {
            WbFile wbFile = new WbFile(this.realOutputfile);
            LogMgr.logDebug(new CallerInfo(){}, "Empty result written. Deleting outputfile " + this.realOutputfile);
            wbFile.delete();
        }
    }

    private void configureExportWriter() throws IOException, SQLException, Exception {
        Object object;
        if (this.encoding == null) {
            this.encoding = Settings.getInstance().getDefaultDataEncoding();
        }
        if (this.tableName != null) {
            this.exportWriter.setTableToUse(this.tableName);
        }
        try {
            this.exportWriter.setOutputFile(this.outputfile);
            if (this.exportWriter.managesOutput()) {
                this.realOutputfile = this.outputfile;
            } else {
                Object object2;
                object = null;
                if (this.getCompressOutput()) {
                    object2 = this.outputfile.getFileName();
                    String string = this.outputfile.getParent();
                    this.realOutputfile = new WbFile(string, (String)object2 + ".zip");
                    if (this.realOutputfile.equals(this.outputfile)) {
                        throw new IOException(ResourceMgr.getString("ErrExportWrongZip"));
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(this.realOutputfile);
                    this.zipArchive = new ZipOutputStream(fileOutputStream);
                    this.zipArchive.setLevel(9);
                    this.zipEntry = new ZipEntry(this.outputfile.getName());
                    this.zipArchive.putNextEntry(this.zipEntry);
                    object = this.zipArchive;
                } else {
                    object = new FileOutputStream(this.outputfile, this.append);
                    this.realOutputfile = this.outputfile;
                }
                object2 = EncodingUtil.createWriter((OutputStream)object, this.encoding);
                this.exportWriter.setOutputWriter((Writer)object2);
            }
            this.exportWriter.configureConverter();
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Error writing data file", iOException);
            throw iOException;
        }
        if (this.progressInterval > 0) {
            this.exportWriter.setRowMonitor(this.rowMonitor);
            this.exportWriter.setProgressInterval(this.progressInterval);
        } else if (this.rowMonitor != null) {
            this.rowMonitor.setMonitorType(7);
            object = ResourceMgr.getString("MsgExportingData") + " " + this.realOutputfile;
            this.rowMonitor.setCurrentObject((String)object, -1L, -1L);
        }
    }

    public void setOptions(ExportOptions exportOptions) {
        this.setEncoding(exportOptions.getEncoding());
        this.setDateFormat(exportOptions.getDateFormat());
        this.setTimestampFormat(exportOptions.getTimestampFormat());
        this.setEncoding(exportOptions.getEncoding());
        this.setNullString(exportOptions.getNullString());
        if (this.exportWriter != null) {
            this.exportWriter.configureConverter();
        }
    }

    public void setSqlOptions(SqlOptions sqlOptions) {
        this.setOutputType(sqlOptions.getExportType());
        this.setMergeType(sqlOptions.getMergeType());
        this.setIncludeCreateTable(sqlOptions.getCreateTable());
        this.setCommitEvery(sqlOptions.getCommitEvery());
        this.setTableName(sqlOptions.getAlternateUpdateTable());
        this.setKeyColumnsToUse(sqlOptions.getKeyColumns());
        this.setDateLiteralType(sqlOptions.getDateLiteralType());
        this.setBlobMode(sqlOptions.getBlobMode());
        this.setIncludeIdentityCols(!sqlOptions.ignoreIdentityColumns());
        this.setUseMultiRowInserts(sqlOptions.getUseMultiRowInserts());
        this.exportWriter.configureConverter();
    }

    public void setXmlOptions(XmlOptions xmlOptions) {
        this.setOutputType(ExportType.XML);
        this.setUseCDATA(xmlOptions.getUseCDATA());
        this.setUseVerboseFormat(xmlOptions.getUseVerboseXml());
        this.exportWriter.configureConverter();
    }

    public void setHtmlOptions(HtmlOptions htmlOptions) {
        this.setOutputType(ExportType.HTML);
        this.setCreateFullHtmlPage(htmlOptions.getCreateFullPage());
        this.setPageTitle(htmlOptions.getPageTitle());
        this.setEscapeHtml(htmlOptions.getEscapeHtml());
        this.exportWriter.configureConverter();
    }

    public void setTextOptions(TextOptions textOptions) {
        this.setOutputType(ExportType.TEXT);
        this.setExportHeaders(textOptions.getExportHeaders());
        this.setTextDelimiter(textOptions.getTextDelimiter());
        this.setTextQuoteChar(textOptions.getTextQuoteChar());
        this.setQuoteAlways(textOptions.getQuoteAlways());
        this.setQuoteHeader(textOptions.getQuoteHeader());
        this.setEscapeRange(textOptions.getEscapeRange());
        this.setDecimalSymbol(textOptions.getDecimalSymbol());
        this.setLineEnding(textOptions.getLineEnding());
        this.exportWriter.configureConverter();
        this.setQuoteEscaping(textOptions.getQuoteEscaping());
        this.controlFiles.clear();
        this.addControlFileFormats(textOptions.getControlFiles());
    }

    public void setXlsXOptions(SpreadSheetOptions spreadSheetOptions) {
        if (spreadSheetOptions != null) {
            this.setOutputType(ExportType.XLSX);
            this.setSpreadsheetOptions(spreadSheetOptions);
        }
    }

    public void setXlsMOptions(SpreadSheetOptions spreadSheetOptions) {
        if (spreadSheetOptions != null) {
            this.setOutputType(ExportType.XLSM);
            this.setSpreadsheetOptions(spreadSheetOptions);
        }
    }

    public void setXlsOptions(SpreadSheetOptions spreadSheetOptions) {
        if (spreadSheetOptions != null) {
            this.setOutputType(ExportType.XLS);
            this.setSpreadsheetOptions(spreadSheetOptions);
        }
    }

    public void setOdsOptions(SpreadSheetOptions spreadSheetOptions) {
        this.setOutputType(ExportType.ODS);
        this.setSpreadsheetOptions(spreadSheetOptions);
    }

    public void setSpreadsheetOptions(SpreadSheetOptions spreadSheetOptions) {
        this.setPageTitle(spreadSheetOptions.getPageTitle());
        this.setExportHeaders(spreadSheetOptions.getExportHeaders());
        this.setEnableAutoFilter(spreadSheetOptions.getCreateAutoFilter());
        this.setEnableFixedHeader(spreadSheetOptions.getCreateFixedHeaders());
        this.setAppendInfoSheet(spreadSheetOptions.getCreateInfoSheet());
        this.setOptimizeSpreadsheetColumns(spreadSheetOptions.getOptimizeColumns());
        this.exportWriter.configureConverter();
    }

    public boolean isIncludeCreateTable() {
        return this.includeCreateTable;
    }

    public void setIncludeCreateTable(boolean bl) {
        this.includeCreateTable = bl;
    }

    public List<String> getKeyColumnsToUse() {
        if (this.keyColumnsToUse == null) {
            return null;
        }
        return Collections.unmodifiableList(this.keyColumnsToUse);
    }

    public void setKeyColumnsToUse(List<String> list) {
        this.keyColumnsToUse = list == null ? null : new ArrayList<String>(list);
    }

    public String getConcatFunction() {
        return this.concatFunction;
    }

    public void setConcatFunction(String string) {
        this.concatFunction = string;
        this.concatString = null;
    }

    @Override
    public boolean getQuoteAlways() {
        return this.quoteAlways;
    }

    @Override
    public void setQuoteAlways(boolean bl) {
        this.quoteAlways = bl;
    }

    @Override
    public void setEscapeRange(CharacterRange characterRange) {
        this.escapeRange = characterRange;
    }

    @Override
    public CharacterRange getEscapeRange() {
        return this.escapeRange;
    }

    @Override
    public void setLineEnding(String string) {
        if (string != null) {
            this.lineEnding = string;
        }
    }

    @Override
    public String getLineEnding() {
        return this.lineEnding;
    }

    @Override
    public Set<ControlFileFormat> getControlFiles() {
        return Collections.unmodifiableSet(this.controlFiles);
    }

    public void setXMLVersion(String string) {
        this.xmlVersion = string;
    }

    public String getXMLVersion() {
        return this.xmlVersion;
    }

    public boolean getUseVerboseFormat() {
        return this.verboseFormat;
    }

    public void setUseVerboseFormat(boolean bl) {
        this.verboseFormat = bl;
    }

    public Set<ControlFileFormat> getControlFileFormats() {
        return Collections.unmodifiableSet(this.controlFiles);
    }

    public void addControlFileFormat(ControlFileFormat controlFileFormat) {
        this.controlFiles.add(controlFileFormat);
    }

    public void addControlFileFormats(Set<ControlFileFormat> set) {
        if (set == null) {
            return;
        }
        this.controlFiles.addAll(set);
    }

    public boolean isContainerExport() {
        return this.exportType == ExportType.XLS || this.exportType == ExportType.XLSX;
    }

    public static boolean isContainerType(String string) {
        return CollectionUtil.caseInsensitiveSet("xls", "xlsx").contains(string);
    }
}

