/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.io.File;
import java.text.SimpleDateFormat;
import workbench.db.TableIdentifier;
import workbench.db.exporter.RowDataConverter;
import workbench.storage.RowData;
import workbench.util.CharacterRange;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbDateFormatter;
import workbench.util.WbFile;
import workbench.util.WbNumberFormatter;

public class JsonRowDataConverter
extends RowDataConverter {
    public JsonRowDataConverter() {
        this.defaultDateFormatter = new WbDateFormatter("yyyy-MM-dd");
        this.defaultTimestampFormatter = new WbDateFormatter("yyyy-MM-dd HH:mm:ss.SSS");
        this.defaultNumberFormatter = new WbNumberFormatter(-1, '.');
        this.defaultTimeFormatter = new SimpleDateFormat("HH:mm:ss");
    }

    @Override
    public StringBuilder getStart() {
        Comparable<File> comparable;
        String string;
        TableIdentifier tableIdentifier = this.metaData.getUpdateTable();
        if (tableIdentifier != null) {
            string = tableIdentifier.getRawTableName();
        } else {
            comparable = new WbFile(this.getOutputFile());
            string = ((WbFile)comparable).getFileName();
        }
        comparable = new StringBuilder(20);
        ((StringBuilder)comparable).append("{\n  \"");
        ((StringBuilder)comparable).append(string.toLowerCase());
        ((StringBuilder)comparable).append("\":\n  [\n");
        return comparable;
    }

    @Override
    public StringBuilder getEnd(long l) {
        return new StringBuilder("\n  ]\n}");
    }

    @Override
    public StringBuilder convertRowData(RowData rowData, long l) {
        int n = this.metaData.getColumnCount();
        StringBuilder stringBuilder = new StringBuilder(n * 30);
        int n2 = 0;
        if (l > 0L) {
            stringBuilder.append(",\n");
        }
        stringBuilder.append("    {");
        for (int i = 0; i < n; ++i) {
            boolean bl;
            if (!this.includeColumnInExport(i)) continue;
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            int n3 = this.metaData.getColumnType(i);
            String string = this.getValueAsFormattedString(rowData, i);
            boolean bl2 = bl = string == null;
            if (bl) {
                string = "null";
            }
            if (SqlUtil.isCharacterType(n3) && !bl && (string = StringUtil.escapeText(string, CharacterRange.RANGE_CONTROL, "")).indexOf(34) > -1) {
                string = string.replace("\"", "\\\"");
            }
            stringBuilder.append("\"");
            stringBuilder.append(this.metaData.getColumnName(i));
            stringBuilder.append("\": ");
            if (!bl) {
                stringBuilder.append('\"');
            }
            stringBuilder.append(string);
            if (!bl) {
                stringBuilder.append('\"');
            }
            ++n2;
        }
        stringBuilder.append("}");
        return stringBuilder;
    }
}

