/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.awt.Point;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;
import workbench.util.VersionNumber;

public class PoiHelper {
    private static boolean tested;
    private static boolean available;
    private static boolean xlsxTested;
    private static boolean xlsxAvailable;

    public static boolean isPoiAvailable() {
        if (tested) {
            return available;
        }
        try {
            tested = true;
            Class<?> clazz = Class.forName("org.apache.poi.ss.usermodel.Workbook");
            clazz.getPackage();
            Package package_ = clazz.getPackage();
            String string = package_.getImplementationVersion();
            int n = string.indexOf(45);
            if (n > -1) {
                string = string.substring(0, n);
            }
            VersionNumber versionNumber = new VersionNumber(string);
            VersionNumber versionNumber2 = new VersionNumber(4, 1);
            LogMgr.logInfo(new CallerInfo(){}, "POI version: " + string + " available");
            available = versionNumber.isNewerOrEqual(versionNumber2);
            if (!available) {
                LogMgr.logError(new CallerInfo(){}, "POI on classpath has version: " + versionNumber.toString() + ". But version " + versionNumber2.toString() + " or later is required", null);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogMgr.logInfo(new CallerInfo(){}, "Apache POI not available");
            available = false;
        }
        catch (Throwable throwable) {
            LogMgr.logDebug(new CallerInfo(){}, "Error loading Apache POI classes", throwable);
            available = false;
        }
        return available;
    }

    public static boolean isXLSXAvailable() {
        if (!PoiHelper.isPoiAvailable()) {
            return false;
        }
        if (xlsxTested) {
            return xlsxAvailable;
        }
        try {
            xlsxTested = true;
            Class<?> clazz = Class.forName("org.apache.poi.xssf.usermodel.XSSFWorkbook");
            xlsxAvailable = clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogMgr.logWarning(new CallerInfo(){}, "XLSX from Apache POI not available. Maybe incomplete POI libraries?");
            available = false;
        }
        catch (Throwable throwable) {
            LogMgr.logDebug(new CallerInfo(){}, "Error loading Apache POI classes for XLSX", throwable);
            xlsxAvailable = false;
        }
        return xlsxAvailable;
    }

    public static Point excelToNumbers(String string) {
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        String string2 = string.toLowerCase().replaceAll("[^a-z]", "");
        String string3 = string.toLowerCase().replaceAll("[^0-9]", "");
        if (StringUtil.isEmptyString(string2)) {
            return null;
        }
        if (StringUtil.isEmptyString(string3)) {
            return null;
        }
        int n = StringUtil.getIntValue(string3, -1);
        if (n == -1) {
            return null;
        }
        int n2 = 0;
        for (int i = 0; i < string2.length(); ++i) {
            n2 *= 26;
            n2 += string2.charAt(i) - 96;
        }
        return new Point(n2 - 1, n - 1);
    }
}

