/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.util.regex.Pattern;
import workbench.db.ColumnIdentifier;
import workbench.db.exporter.ExportDataModifier;
import workbench.db.exporter.RowDataConverter;
import workbench.storage.RowData;
import workbench.util.SqlUtil;

public class RegexReplacingModifier
implements ExportDataModifier {
    private Pattern searchPattern;
    private String replacement;

    public RegexReplacingModifier(String string, String string2) {
        this.searchPattern = Pattern.compile(string);
        this.replacement = string2;
    }

    public String getRegex() {
        return this.searchPattern.pattern();
    }

    public String getReplacement() {
        return this.replacement;
    }

    @Override
    public void modifyData(RowDataConverter rowDataConverter, RowData rowData, long l) {
        int n = rowData.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String string;
            ColumnIdentifier columnIdentifier = rowDataConverter.getResultInfo().getColumn(i);
            if (!rowDataConverter.includeColumnInExport(i) || !SqlUtil.isCharacterType(columnIdentifier.getDataType()) || (string = (String)rowData.getValue(i)) == null) continue;
            rowData.setValue(i, this.replacePattern(string));
        }
    }

    public String replacePattern(String string) {
        if (string == null) {
            return null;
        }
        if (this.searchPattern == null) {
            return string;
        }
        if (this.replacement == null) {
            return string;
        }
        return this.searchPattern.matcher(string).replaceAll(this.replacement);
    }
}

