/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import workbench.db.DbMetadata;
import workbench.db.WbConnection;
import workbench.db.exporter.BlobMode;
import workbench.db.exporter.DataExporter;
import workbench.db.exporter.ExportWriter;
import workbench.db.exporter.RowDataConverter;
import workbench.db.exporter.TextRowDataConverter;
import workbench.storage.BlobFormatterFactory;
import workbench.storage.BlobLiteralType;
import workbench.storage.PostgresBlobFormatter;

public class TextExportWriter
extends ExportWriter {
    public TextExportWriter(DataExporter dataExporter) {
        super(dataExporter);
    }

    @Override
    public RowDataConverter createConverter() {
        return new TextRowDataConverter();
    }

    @Override
    public void configureConverter() {
        super.configureConverter();
        TextRowDataConverter textRowDataConverter = (TextRowDataConverter)this.converter;
        textRowDataConverter.setDelimiter(this.exporter.getTextDelimiter());
        textRowDataConverter.setQuoteCharacter(this.exporter.getTextQuoteChar());
        textRowDataConverter.setQuoteAlways(this.exporter.getQuoteAlways());
        textRowDataConverter.setEscapeRange(this.exporter.getEscapeRange());
        textRowDataConverter.setNullString(this.exporter.getNullString());
        textRowDataConverter.setLineEnding(this.exporter.getLineEnding());
        textRowDataConverter.setWriteClobToFile(this.exporter.getWriteClobAsFile());
        textRowDataConverter.setQuoteEscaping(this.exporter.getQuoteEscaping());
        textRowDataConverter.setRowIndexColName(this.exporter.getRowIndexColumnName());
        textRowDataConverter.setEscapeType(this.exporter.getEscapeType());
        BlobMode blobMode = this.exporter.getBlobMode();
        if (blobMode == BlobMode.AnsiLiteral) {
            textRowDataConverter.setBlobFormatter(BlobFormatterFactory.createAnsiFormatter());
            textRowDataConverter.setWriteBlobToFile(false);
        } else if (blobMode == BlobMode.Base64) {
            textRowDataConverter.setBlobFormatter(BlobFormatterFactory.createInstance(BlobLiteralType.base64));
            textRowDataConverter.setWriteBlobToFile(false);
        } else if (blobMode == BlobMode.DbmsLiteral) {
            DbMetadata dbMetadata = null;
            WbConnection wbConnection = this.exporter.getConnection();
            if (wbConnection != null) {
                dbMetadata = wbConnection.getMetadata();
            }
            textRowDataConverter.setBlobFormatter(BlobFormatterFactory.createInstance(dbMetadata));
            textRowDataConverter.setWriteBlobToFile(false);
        } else if (blobMode == BlobMode.pgHex || blobMode == BlobMode.pgEscape) {
            PostgresBlobFormatter postgresBlobFormatter = new PostgresBlobFormatter(blobMode);
            textRowDataConverter.setBlobFormatter(postgresBlobFormatter);
            textRowDataConverter.setWriteBlobToFile(false);
        } else if (blobMode == BlobMode.SaveToFile) {
            textRowDataConverter.setBlobFormatter(null);
            textRowDataConverter.setWriteBlobToFile(true);
        }
    }
}

