/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.firebird;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DomainIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class FirebirdDomainReader
implements ObjectListExtender {
    final String baseSql = "SELECT trim(rdb$field_name) AS domain_name, \n       rdb$validation_source as constraint_definition, \n       case rdb$field_type  \n         when 261 then 'BLOB' \n         when 14 then 'CHAR' \n         when 40 then 'CSTRING' \n         when 11 then 'D_FLOAT' \n         when 27 then 'DOUBLE' \n         when 10 then 'FLOAT' \n         when 16 then 'BIGINT' \n         when 8 then 'INTEGER' \n         when 9 then 'QUAD' \n         when 7 then 'SMALLINT' \n         when 12 then 'DATE' \n         when 35 then 'TIMESTAMP' \n         when 3 then 'DATE' \n         when 37 then 'VARCHAR' \n         else 'UNKNOWN' \n       end as data_type, \n       rdb$default_source as default_value, \n       case rdb$null_flag \n         when 1 then 1 \n         else 0 \n       end as nullable \nFROM rdb$fields \nWHERE rdb$field_name NOT LIKE 'RDB$%' \n  AND rdb$field_name NOT LIKE 'SEC$%' ";

    @Override
    public boolean isDerivedType() {
        return false;
    }

    private String getSql(WbConnection wbConnection, String string) {
        StringBuilder stringBuilder = new StringBuilder("SELECT trim(rdb$field_name) AS domain_name, \n       rdb$validation_source as constraint_definition, \n       case rdb$field_type  \n         when 261 then 'BLOB' \n         when 14 then 'CHAR' \n         when 40 then 'CSTRING' \n         when 11 then 'D_FLOAT' \n         when 27 then 'DOUBLE' \n         when 10 then 'FLOAT' \n         when 16 then 'BIGINT' \n         when 8 then 'INTEGER' \n         when 9 then 'QUAD' \n         when 7 then 'SMALLINT' \n         when 12 then 'DATE' \n         when 35 then 'TIMESTAMP' \n         when 3 then 'DATE' \n         when 37 then 'VARCHAR' \n         else 'UNKNOWN' \n       end as data_type, \n       rdb$default_source as default_value, \n       case rdb$null_flag \n         when 1 then 1 \n         else 0 \n       end as nullable \nFROM rdb$fields \nWHERE rdb$field_name NOT LIKE 'RDB$%' \n  AND rdb$field_name NOT LIKE 'SEC$%' ".length() + 40);
        stringBuilder.append("SELECT trim(rdb$field_name) AS domain_name, \n       rdb$validation_source as constraint_definition, \n       case rdb$field_type  \n         when 261 then 'BLOB' \n         when 14 then 'CHAR' \n         when 40 then 'CSTRING' \n         when 11 then 'D_FLOAT' \n         when 27 then 'DOUBLE' \n         when 10 then 'FLOAT' \n         when 16 then 'BIGINT' \n         when 8 then 'INTEGER' \n         when 9 then 'QUAD' \n         when 7 then 'SMALLINT' \n         when 12 then 'DATE' \n         when 35 then 'TIMESTAMP' \n         when 3 then 'DATE' \n         when 37 then 'VARCHAR' \n         else 'UNKNOWN' \n       end as data_type, \n       rdb$default_source as default_value, \n       case rdb$null_flag \n         when 1 then 1 \n         else 0 \n       end as nullable \nFROM rdb$fields \nWHERE rdb$field_name NOT LIKE 'RDB$%' \n  AND rdb$field_name NOT LIKE 'SEC$%' ");
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append(" AND trim(rdb$field_name) ");
            if (string.indexOf(37) == -1) {
                stringBuilder.append('=');
            } else {
                stringBuilder.append("LIKE");
            }
            stringBuilder.append(" '");
            stringBuilder.append(wbConnection.getMetadata().quoteObjectname(string));
            stringBuilder.append("' ");
        }
        stringBuilder.append(" ORDER BY 1 ");
        if (Settings.getInstance().getDebugMetadataSql()) {
            LogMgr.logDebug(new CallerInfo(){}, "Query to retrieve domains:\n" + stringBuilder);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DomainIdentifier> getDomainList(WbConnection wbConnection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        ArrayList<DomainIdentifier> arrayList = new ArrayList<DomainIdentifier>();
        String string3 = null;
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            string3 = this.getSql(wbConnection, string2);
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("domain_name");
                DomainIdentifier domainIdentifier = new DomainIdentifier(null, null, string4);
                String string5 = resultSet.getString("constraint_definition");
                if (string5 != null) {
                    string5 = string5.trim();
                }
                domainIdentifier.setCheckConstraint(string5);
                String string6 = resultSet.getString("data_type");
                if (string6 != null) {
                    string6 = string6.trim();
                }
                domainIdentifier.setDataType(string6);
                int n = resultSet.getInt("nullable");
                domainIdentifier.setNullable(n == 0);
                domainIdentifier.setDefaultValue(resultSet.getString("default_value"));
                arrayList.add(domainIdentifier);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logError(new CallerInfo(){}, "Could not read domains using query:\n" + string3, sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    @Override
    public DomainIdentifier getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        List<DomainIdentifier> list = this.getDomainList(wbConnection, dbObject.getSchema(), dbObject.getObjectName());
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public String getDomainSource(DomainIdentifier domainIdentifier) {
        if (domainIdentifier == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("CREATE DOMAIN ");
        stringBuilder.append(domainIdentifier.getObjectName());
        stringBuilder.append(" AS ");
        stringBuilder.append(domainIdentifier.getDataType());
        if (domainIdentifier.getDefaultValue() != null) {
            stringBuilder.append("\n  ");
            stringBuilder.append(domainIdentifier.getDefaultValue());
        }
        if (StringUtil.isNonBlank(domainIdentifier.getCheckConstraint()) || !domainIdentifier.isNullable()) {
            stringBuilder.append("\n  ");
            if (!domainIdentifier.isNullable()) {
                stringBuilder.append("NOT NULL");
            }
            if (StringUtil.isNonBlank(domainIdentifier.getCheckConstraint())) {
                if (!domainIdentifier.isNullable()) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(domainIdentifier.getCheckConstraint());
            }
        }
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("DOMAIN", stringArray)) {
            return false;
        }
        List<DomainIdentifier> list = this.getDomainList(wbConnection, string2, string3);
        if (list.isEmpty()) {
            return false;
        }
        for (DomainIdentifier domainIdentifier : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, (Object)domainIdentifier.getSchema());
            dataStore.setValue(n, "NAME", (Object)domainIdentifier.getObjectName());
            dataStore.setValue(n, "REMARKS", (Object)domainIdentifier.getComment());
            dataStore.setValue(n, "TYPE", (Object)domainIdentifier.getObjectType());
            dataStore.getRow(n).setUserObject(domainIdentifier);
        }
        return true;
    }

    @Override
    public boolean handlesType(String string) {
        return StringUtil.equalStringIgnoreCase("DOMAIN", string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        if (!this.handlesType(dbObject.getObjectType())) {
            return null;
        }
        DomainIdentifier domainIdentifier = this.getObjectDefinition(wbConnection, dbObject);
        if (domainIdentifier == null) {
            return null;
        }
        String[] stringArray = new String[]{"DOMAIN", "DATA_TYPE", "NULLABLE", "CONSTRAINT", "REMARKS"};
        int[] nArray = new int[]{12, 12, 16, 12, 12};
        int[] nArray2 = new int[]{20, 10, 5, 30, 30};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        dataStore.addRow();
        dataStore.setValue(0, 0, (Object)domainIdentifier.getObjectName());
        dataStore.setValue(0, 1, (Object)domainIdentifier.getDataType().trim());
        dataStore.setValue(0, 2, (Object)domainIdentifier.isNullable());
        dataStore.setValue(0, 3, (Object)domainIdentifier.getCheckConstraint());
        dataStore.setValue(0, 4, (Object)domainIdentifier.getComment());
        return dataStore;
    }

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("DOMAIN");
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        return this.getDomainSource(this.getObjectDefinition(wbConnection, dbObject));
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

