/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.firebird;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import workbench.db.DbMetadata;
import workbench.db.IndexColumn;
import workbench.db.IndexDefinition;
import workbench.db.JdbcIndexReader;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class FirebirdIndexReader
extends JdbcIndexReader {
    private PreparedStatement indexStatement;
    private static final String GET_INDEX_INFO = "SELECT NULL as TABLE_CAT, \n       NULL as TABLE_SCHEM, \n       trim(ind.RDB$RELATION_NAME) AS TABLE_NAME, \n       case  \n           when ind.RDB$UNIQUE_FLAG is null then 1  \n           when ind.RDB$UNIQUE_FLAG = 1 then 0 \n           else 1 \n        end AS NON_UNIQUE, \n       NULL as INDEX_QUALIFIER, \n       trim(ind.RDB$INDEX_NAME) as INDEX_NAME, \n       NULL as \"TYPE\", \n       coalesce(ise.rdb$field_position,0) +1 as ORDINAL_POSITION, \n       trim(coalesce(ise.rdb$field_name, 'COMPUTED BY '|| ind.rdb$expression_source)) as COLUMN_NAME, \n       case \n           when ind.RDB$INDEX_TYPE = 1 then 'D'  \n           else 'A' \n        end as ASC_OR_DESC,        0 as CARDINALITY,        0 as \"PAGES\", \n       null as FILTER_CONDITION, \n       ind.RDB$FOREIGN_KEY \nFROM rdb$indices ind  LEFT JOIN rdb$index_segments ise ON ind.rdb$index_name = ise.rdb$index_name WHERE ind.rdb$relation_name = ? ORDER BY 4, 6, 8";

    public FirebirdIndexReader(DbMetadata dbMetadata) {
        super(dbMetadata);
    }

    @Override
    public ResultSet getIndexInfo(TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        if (this.indexStatement != null) {
            LogMgr.logWarning(new CallerInfo(){}, "getIndexInfo() called with pending results!");
            this.indexInfoProcessed();
        }
        WbConnection wbConnection = this.metaData.getWbConnection();
        LogMgr.logMetadataSql(new CallerInfo(){}, "index info", GET_INDEX_INFO, tableIdentifier.getTableName());
        this.indexStatement = wbConnection.getSqlConnection().prepareStatement(GET_INDEX_INFO);
        this.indexStatement.setString(1, tableIdentifier.getRawTableName());
        ResultSet resultSet = this.indexStatement.executeQuery();
        return resultSet;
    }

    @Override
    public void processIndexList(Collection<IndexDefinition> collection) {
        for (IndexDefinition indexDefinition : collection) {
            List<IndexColumn> list = indexDefinition.getColumns();
            String string = null;
            String string2 = null;
            for (IndexColumn indexColumn : list) {
                if (string == null) {
                    string = indexColumn.getDirection();
                }
                indexColumn.setDirection(null);
                if (!indexColumn.getColumn().startsWith("COMPUTED") || string2 != null) continue;
                string2 = indexColumn.getColumn();
            }
            indexDefinition.setDirection(string);
            indexDefinition.setIndexExpression(string2);
        }
        for (IndexDefinition indexDefinition : collection) {
            if (!indexDefinition.isUnique() || !indexDefinition.getName().startsWith("RDB$PRIM")) continue;
            indexDefinition.setPrimaryKeyIndex(true);
        }
    }

    @Override
    protected String quoteIndexColumn(String string) {
        if (string.startsWith("COMPUTED")) {
            return string;
        }
        return super.quoteIndexColumn(string);
    }

    @Override
    protected void processIndexResultRow(ResultSet resultSet, IndexDefinition indexDefinition, TableIdentifier tableIdentifier) throws SQLException {
        String string = resultSet.getString("RDB$FOREIGN_KEY");
        if (string != null) {
            indexDefinition.setAutoGenerated(true);
        }
    }

    @Override
    public void indexInfoProcessed() {
        JdbcUtils.closeStatement(this.indexStatement);
        this.indexStatement = null;
    }
}

