/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.h2database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.db.h2database.H2Constant;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class H2ConstantReader
implements ObjectListExtender {
    final String baseSql = "SELECT constant_catalog,  \n       constant_schema, \n       constant_name, \n       data_type, \n       sql as constant_value, \n       remarks \n FROM information_schema.constants ";

    private String getSql(WbConnection wbConnection, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("SELECT constant_catalog,  \n       constant_schema, \n       constant_name, \n       data_type, \n       sql as constant_value, \n       remarks \n FROM information_schema.constants ".length() + 40);
        stringBuilder.append("SELECT constant_catalog,  \n       constant_schema, \n       constant_name, \n       data_type, \n       sql as constant_value, \n       remarks \n FROM information_schema.constants ");
        boolean bl = false;
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append(" WHERE constant_name like '");
            stringBuilder.append(wbConnection.getMetadata().quoteObjectname(string2));
            stringBuilder.append("%' ");
            bl = true;
        }
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append(bl ? " AND " : " WHERE ");
            stringBuilder.append(" constant_schema = '");
            stringBuilder.append(wbConnection.getMetadata().quoteObjectname(string));
            stringBuilder.append("'");
        }
        stringBuilder.append(" ORDER BY 1, 2 ");
        LogMgr.logMetadataSql(new CallerInfo(){}, "constants", stringBuilder, new Object[0]);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<H2Constant> getConstantsList(WbConnection wbConnection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        ArrayList<H2Constant> arrayList = new ArrayList<H2Constant>();
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            String string3 = this.getSql(wbConnection, string, string2);
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("constant_catalog");
                String string5 = resultSet.getString("constant_schema");
                String string6 = resultSet.getString("constant_name");
                H2Constant h2Constant = new H2Constant(string4, string5, string6);
                int n = resultSet.getInt("data_type");
                String string7 = SqlUtil.getTypeName(n);
                h2Constant.setDataType(string7);
                h2Constant.setValue(resultSet.getString("constant_value"));
                h2Constant.setComment(resultSet.getString("remarks"));
                arrayList.add(h2Constant);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logError(new CallerInfo(){}, "Could not read constants", sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public H2Constant getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        List<H2Constant> list = this.getConstantsList(wbConnection, dbObject.getSchema(), dbObject.getObjectName());
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public String getConstantSource(H2Constant h2Constant) {
        if (h2Constant == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("CREATE CONSTANT ");
        stringBuilder.append(h2Constant.getObjectName());
        stringBuilder.append(" VALUE ");
        stringBuilder.append(h2Constant.getValue());
        stringBuilder.append(";\n");
        if (StringUtil.isNonBlank(h2Constant.getComment())) {
            stringBuilder.append("\nCOMMENT ON CONSTANT " + h2Constant.getObjectName() + " IS '");
            stringBuilder.append(SqlUtil.escapeQuotes(h2Constant.getComment()));
            stringBuilder.append("';\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("CONSTANT", stringArray)) {
            return false;
        }
        List<H2Constant> list = this.getConstantsList(wbConnection, string2, string3);
        if (list.isEmpty()) {
            return false;
        }
        for (H2Constant h2Constant : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, (Object)h2Constant.getSchema());
            dataStore.setValue(n, 0, (Object)h2Constant.getObjectName());
            dataStore.setValue(n, 4, (Object)h2Constant.getComment());
            dataStore.setValue(n, 1, (Object)h2Constant.getObjectType());
            dataStore.getRow(n).setUserObject(h2Constant);
        }
        return true;
    }

    @Override
    public boolean handlesType(String string) {
        return StringUtil.equalStringIgnoreCase("CONSTANT", string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        if (!this.handlesType(dbObject.getObjectType())) {
            return null;
        }
        H2Constant h2Constant = this.getObjectDefinition(wbConnection, dbObject);
        if (h2Constant == null) {
            return null;
        }
        String[] stringArray = new String[]{"CONSTANT", "DATA_TYPE", "VALUE", "REMARKS"};
        int[] nArray = new int[]{12, 12, 16, 12};
        int[] nArray2 = new int[]{20, 10, 5, 30, 30};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        dataStore.addRow();
        dataStore.setValue(0, 0, (Object)h2Constant.getObjectName());
        dataStore.setValue(0, 1, (Object)h2Constant.getDataType());
        dataStore.setValue(0, 2, (Object)h2Constant.getValue());
        dataStore.setValue(0, 3, (Object)h2Constant.getComment());
        return dataStore;
    }

    @Override
    public List<String> supportedTypes() {
        return Collections.singletonList("CONSTANT");
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        return this.getConstantSource(this.getObjectDefinition(wbConnection, dbObject));
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

