/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.h2database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import workbench.db.ConstraintDefinition;
import workbench.db.IndexDefinition;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.UniqueConstraintReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;

public class H2UniqueConstraintReader
implements UniqueConstraintReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readUniqueConstraints(TableIdentifier tableIdentifier, List<IndexDefinition> list, WbConnection wbConnection) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        if (wbConnection == null) {
            return;
        }
        String string = "select unique_index_name, constraint_name\nfrom information_schema.constraints \nwhere (table_catalog, table_schema, table_name) = (?,?,?)";
        LogMgr.logMetadataSql(new CallerInfo(){}, "unique constraints", string, tableIdentifier.getCatalog(), tableIdentifier.getSchema(), tableIdentifier.getTableName());
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getCatalog());
            preparedStatement.setString(2, tableIdentifier.getSchema());
            preparedStatement.setString(3, tableIdentifier.getTableName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                IndexDefinition indexDefinition = IndexDefinition.findIndex(list, string2, null);
                if (indexDefinition == null) continue;
                ConstraintDefinition constraintDefinition = ConstraintDefinition.createUniqueConstraint(string3);
                indexDefinition.setUniqueConstraint(constraintDefinition);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "unique constraints", string, tableIdentifier.getCatalog(), tableIdentifier.getSchema(), tableIdentifier.getTableName());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }
}

