/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hsqldb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.dependency.DependencyReader;
import workbench.gui.dbobjects.objecttree.DbObjectSorter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;

public class HsqlDependencyReader
implements DependencyReader {
    private final Set<String> supportedTypes = CollectionUtil.caseInsensitiveSet("table", "view");
    private final String searchUsedBy = "select vtu.table_catalog, vtu.table_schema, vtu.table_name, \n       case when v.table_name is not null then 'VIEW'             when t.table_name is not null then 'TABLE' \n       end as type\n from information_schema.view_table_usage vtu \n  left join information_schema.views v on (v.table_catalog, v.table_schema, v.table_name) = (vtu.table_catalog, vtu.table_schema, vtu.table_name) \n  left join information_schema.tables t on (t.table_catalog, t.table_schema, t.table_name) = (vtu.table_catalog, vtu.table_schema, vtu.table_name) \nwhere vtu.view_schema = ? \n  and vtu.view_name = ? ";
    private final String searchUsedSql = "select vtu.view_catalog, vtu.view_schema, vtu.view_name, \n       case when v.table_name is not null then 'VIEW'             when t.table_name is not null then 'TABLE' \n       end as type\n from information_schema.view_table_usage vtu \n  left join information_schema.views v on (v.table_catalog, v.table_schema, v.table_name) = (vtu.table_catalog, vtu.table_schema, vtu.table_name) \n  left join information_schema.tables t on (t.table_catalog, t.table_schema, t.table_name) = (vtu.table_catalog, vtu.table_schema, vtu.table_name) \nwhere table_schema = ? \n  and table_name = ?";

    @Override
    public List<DbObject> getUsedObjects(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null || wbConnection == null) {
            return Collections.emptyList();
        }
        return this.retrieveObjects(wbConnection, dbObject, "select vtu.table_catalog, vtu.table_schema, vtu.table_name, \n       case when v.table_name is not null then 'VIEW'             when t.table_name is not null then 'TABLE' \n       end as type\n from information_schema.view_table_usage vtu \n  left join information_schema.views v on (v.table_catalog, v.table_schema, v.table_name) = (vtu.table_catalog, vtu.table_schema, vtu.table_name) \n  left join information_schema.tables t on (t.table_catalog, t.table_schema, t.table_name) = (vtu.table_catalog, vtu.table_schema, vtu.table_name) \nwhere vtu.view_schema = ? \n  and vtu.view_name = ? ");
    }

    @Override
    public List<DbObject> getUsedBy(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null || wbConnection == null) {
            return Collections.emptyList();
        }
        return this.retrieveObjects(wbConnection, dbObject, "select vtu.view_catalog, vtu.view_schema, vtu.view_name, \n       case when v.table_name is not null then 'VIEW'             when t.table_name is not null then 'TABLE' \n       end as type\n from information_schema.view_table_usage vtu \n  left join information_schema.views v on (v.table_catalog, v.table_schema, v.table_name) = (vtu.table_catalog, vtu.table_schema, vtu.table_name) \n  left join information_schema.tables t on (t.table_catalog, t.table_schema, t.table_name) = (vtu.table_catalog, vtu.table_schema, vtu.table_name) \nwhere table_schema = ? \n  and table_name = ?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DbObject> retrieveObjects(WbConnection wbConnection, DbObject dbObject, String string) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>();
        String string2 = SqlUtil.replaceParameters(string, dbObject.getCatalog(), dbObject.getSchema(), dbObject.getObjectName(), dbObject.getObjectType());
        LogMgr.logMetadataSql(new CallerInfo(){}, "dependent objects", string2, new Object[0]);
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, dbObject.getSchema());
            preparedStatement.setString(2, dbObject.getObjectName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4);
                TableIdentifier tableIdentifier = new TableIdentifier(string3, string4, string5);
                tableIdentifier.setNeverAdjustCase(true);
                tableIdentifier.setType(string6);
                arrayList.add(tableIdentifier);
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        catch (Exception exception) {
            LogMgr.logMetadataError(new CallerInfo(){}, exception, "dependent objects", string2, new Object[0]);
        }
        finally {
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        DbObjectSorter.sort(arrayList, true);
        return arrayList;
    }

    @Override
    public boolean supportsUsedByDependency(String string) {
        return this.supportedTypes.contains(string);
    }

    @Override
    public boolean supportsIsUsingDependency(String string) {
        return this.supportedTypes.contains(string);
    }
}

