/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hsqldb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;

public class HsqlTableSourceBuilder
extends TableSourceBuilder {
    public HsqlTableSourceBuilder(WbConnection wbConnection) {
        super(wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTableOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block8: {
            if (tableIdentifier == null) {
                return;
            }
            if (tableIdentifier.getSourceOptions().isInitialized()) {
                return;
            }
            boolean bl = Settings.getInstance().getBoolProperty("workbench.db.hsql_database_engine.table_type.show_always", false);
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = this.dbConnection.getSqlConnection().prepareStatement("select hsqldb_type, \n       (select upper(property_value) from information_schema.system_properties where property_name = 'hsqldb.default_table_type') as default_type \nfrom information_schema.system_tables \nwhere table_name = ? \n  and table_schem = ?");
                preparedStatement.setString(1, tableIdentifier.getTableName());
                preparedStatement.setString(2, tableIdentifier.getSchema());
                LogMgr.logMetadataSql(new CallerInfo(){}, "table options", "select hsqldb_type, \n       (select upper(property_value) from information_schema.system_properties where property_name = 'hsqldb.default_table_type') as default_type \nfrom information_schema.system_tables \nwhere table_name = ? \n  and table_schem = ?", tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block8;
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                if (string2 == null) {
                    string2 = "CACHED";
                }
                if (!bl && string2.equals(string)) break block8;
                tableIdentifier.getSourceOptions().setTypeModifier(string);
            }
            catch (SQLException sQLException) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "table options", "select hsqldb_type, \n       (select upper(property_value) from information_schema.system_properties where property_name = 'hsqldb.default_table_type') as default_type \nfrom information_schema.system_tables \nwhere table_name = ? \n  and table_schem = ?", tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        if (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "2.5")) {
            this.readSystemVersioning(tableIdentifier);
        }
        tableIdentifier.getSourceOptions().setInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSystemVersioning(TableIdentifier tableIdentifier) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block4: {
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = this.dbConnection.getSqlConnection().prepareStatement("SELECT period_name, start_column_name, end_column_name \nFROM information_schema.periods \nwhere table_name = ? \n  and table_schema = ?");
                preparedStatement.setString(1, tableIdentifier.getTableName());
                preparedStatement.setString(2, tableIdentifier.getSchema());
                LogMgr.logMetadataSql(new CallerInfo(){}, "table period", "SELECT period_name, start_column_name, end_column_name \nFROM information_schema.periods \nwhere table_name = ? \n  and table_schema = ?", tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
                DbMetadata dbMetadata = this.dbConnection.getMetadata();
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = "PERIOD FOR " + dbMetadata.quoteObjectname(string) + " (" + dbMetadata.quoteObjectname(string2) + ", " + dbMetadata.quoteObjectname(string3) + ")";
                tableIdentifier.getSourceOptions().setInlineOption(string4);
            }
            catch (SQLException sQLException) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "table period", "SELECT period_name, start_column_name, end_column_name \nFROM information_schema.periods \nwhere table_name = ? \n  and table_schema = ?", tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }
}

