/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hsqldb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import workbench.db.ConstraintDefinition;
import workbench.db.IndexDefinition;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.UniqueConstraintReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;

public class HsqlUniqueConstraintReader
implements UniqueConstraintReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readUniqueConstraints(TableIdentifier tableIdentifier, List<IndexDefinition> list, WbConnection wbConnection) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        if (wbConnection == null) {
            return;
        }
        String string = "select index_name, constraint_name \nfrom (\n  select idx.index_name, tc.constraint_name, tc.table_catalog, tc.table_schema, tc.table_name \n  from information_schema.table_constraints tc \n    join information_schema.system_indexinfo idx \n      on tc.table_name = idx.table_name \n     and tc.table_schema = idx.table_schem \n     and tc.table_catalog = idx.table_cat \n  where tc.constraint_type = 'UNIQUE' \n) t \nwhere table_schema = ? \n  and table_name = ?";
        LogMgr.logMetadataSql(new CallerInfo(){}, "unique constraints", string, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getRawSchema());
            preparedStatement.setString(2, tableIdentifier.getRawTableName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                IndexDefinition indexDefinition = IndexDefinition.findIndex(list, string2, null);
                if (indexDefinition == null) continue;
                ConstraintDefinition constraintDefinition = ConstraintDefinition.createUniqueConstraint(string3);
                indexDefinition.setUniqueConstraint(constraintDefinition);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "unique constraints", string, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }
}

