/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import workbench.db.ColumnDefinitionEnhancer;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.WbConnection;
import workbench.db.ibm.Db2SequenceReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class Db2ColumnEnhancer
implements ColumnDefinitionEnhancer {
    @Override
    public void updateColumnDefinition(TableDefinition tableDefinition, WbConnection wbConnection) {
        this.updateComputedColumns(tableDefinition, wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComputedColumns(TableDefinition tableDefinition, WbConnection wbConnection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = tableDefinition.getTable().getTableName();
        String string2 = tableDefinition.getTable().getSchema();
        String string3 = "SELECT c.colname, \n       c.hidden, \n       c.generated, \n       c.text, \n       a.start, \n       a.increment, \n       a.minvalue, \n       a.maxvalue, \n       a.cycle, \n       a.cache, \n       a.order";
        String string4 = "\nFROM syscat.columns c  \n     LEFT JOIN syscat.colidentattributes a ON c.tabname = a.tabname AND c.tabschema = a.tabschema AND c.colname = a.colname \nWHERE (c.generated <> ' ' or c.hidden <> ' ') \nAND   c.tabname = ? \nAND   c.tabschema = ? ";
        boolean bl = false;
        if (JdbcUtils.hasMinimumServerVersion(wbConnection, "10.1")) {
            string3 = string3 + ", \n       c.rowbegin, \n       c.rowend, \n       c.transactionstartid";
            bl = true;
        }
        String string5 = string3 + string4;
        LogMgr.logMetadataSql(new CallerInfo(){}, "column details", string5, string, string2);
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string5);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string6 = resultSet.getString(1);
                String string7 = resultSet.getString(2);
                String string8 = resultSet.getString(3);
                String string9 = resultSet.getString(4);
                BigDecimal bigDecimal = resultSet.getBigDecimal(5);
                BigDecimal bigDecimal2 = resultSet.getBigDecimal(6);
                BigDecimal bigDecimal3 = resultSet.getBigDecimal(7);
                BigDecimal bigDecimal4 = resultSet.getBigDecimal(8);
                boolean bl2 = StringUtil.stringToBool(resultSet.getString(9));
                Integer n = resultSet.getInt(10);
                boolean bl3 = StringUtil.stringToBool(resultSet.getString(11));
                String string10 = "N";
                String string11 = "N";
                String string12 = "N";
                if (bl) {
                    string10 = resultSet.getString(12);
                    string11 = resultSet.getString(13);
                    string12 = resultSet.getString(14);
                }
                ColumnIdentifier columnIdentifier = ColumnIdentifier.findColumnInList(tableDefinition.getColumns(), string6);
                if (!string8.equals(" ")) {
                    boolean bl4 = "Y".equals(string10) || "Y".equals(string11) || "Y".equals(string12);
                    String string13 = "GENERATED";
                    if ("A".equals(string8)) {
                        string13 = string13 + " ALWAYS";
                        columnIdentifier.setIsIdentity(true);
                        columnIdentifier.setIsAutoincrement(true);
                    } else {
                        string13 = string13 + " BY DEFAULT";
                        columnIdentifier.setIsAutoincrement(true);
                    }
                    if (string9 == null && !bl4) {
                        string13 = string13 + " AS IDENTITY (" + Db2SequenceReader.buildSequenceDetails(false, bigDecimal, bigDecimal3, bigDecimal4, bigDecimal2, bl2, bl3, n) + ")";
                        columnIdentifier.setGeneratorExpression(string13);
                    } else if (bl4) {
                        if ("Y".equals(string10)) {
                            string13 = string13 + " AS ROW BEGIN";
                        } else if ("Y".equals(string11)) {
                            string13 = string13 + " AS ROW END";
                        } else if ("Y".equals(string12)) {
                            string13 = string13 + " AS TRANSACTION START ID";
                        }
                        columnIdentifier.setGeneratorExpression(string13);
                        columnIdentifier.setIsIdentity(false);
                        columnIdentifier.setIsAutoincrement(false);
                        columnIdentifier.setIsGenerated(true);
                    } else {
                        string13 = string13 + " " + string9;
                        columnIdentifier.setIsGenerated(true);
                        columnIdentifier.setComputedColumnExpression(string13);
                        columnIdentifier.setIsIdentity(false);
                        columnIdentifier.setIsAutoincrement(false);
                    }
                }
                if (!"I".equals(string7)) continue;
                columnIdentifier.setSQLOption("IMPLICITLY HIDDEN");
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "column details", string5, string, string2);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }
}

