/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.DBID;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class Db2SequenceReader
implements SequenceReader {
    private WbConnection connection;
    private final DBID dbid;
    private boolean quoteKeyword;
    private char catalogSeparator;

    public Db2SequenceReader(WbConnection wbConnection, String string) {
        this.connection = wbConnection;
        this.dbid = DBID.fromID(string);
        this.catalogSeparator = wbConnection.getMetadata().getCatalogSeparator();
    }

    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null) {
            return Collections.emptyList();
        }
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>(dataStore.getRowCount());
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            arrayList.add(this.createSequenceDefinition(dataStore, i));
        }
        return arrayList;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null || dataStore.getRowCount() != 1) {
            return null;
        }
        return this.createSequenceDefinition(dataStore, 0);
    }

    private String getDSValueString(DataStore dataStore, int n, String ... stringArray) {
        Object object = this.getDSValue(dataStore, n, stringArray);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    private Object getDSValue(DataStore dataStore, int n, String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        for (String string : stringArray) {
            if (dataStore.getColumnIndex(string) <= -1) continue;
            return dataStore.getValue(n, string);
        }
        return null;
    }

    private SequenceDefinition createSequenceDefinition(DataStore dataStore, int n) {
        String string = this.getDSValueString(dataStore, n, "SEQNAME", "NAME", "SEQUENCE_NAME");
        String string2 = this.getDSValueString(dataStore, n, "SEQUENCE_SCHEMA", "SEQSCHEMA", "SCHEMA");
        SequenceDefinition sequenceDefinition = new SequenceDefinition(string2 != null ? string2.trim() : null, string.trim());
        sequenceDefinition.setSequenceProperty("start_value", dataStore.getValue(n, "START"));
        sequenceDefinition.setSequenceProperty("min_value", this.getDSValue(dataStore, n, "MINVALUE", "MINIMUM_VALUE"));
        sequenceDefinition.setSequenceProperty("max_value", this.getDSValue(dataStore, n, "MAXVALUE", "MAXIMUM_VALUE"));
        sequenceDefinition.setSequenceProperty("increment", dataStore.getValue(n, "INCREMENT"));
        sequenceDefinition.setSequenceProperty("cycle", Boolean.toString(StringUtil.stringToBool(dataStore.getValueAsString(n, "CYCLE"))));
        sequenceDefinition.setSequenceProperty("ordered", Boolean.toString(StringUtil.stringToBool(dataStore.getValueAsString(n, "ORDER"))));
        sequenceDefinition.setSequenceProperty("cache", dataStore.getValue(n, "CACHE"));
        if (dataStore.getColumnIndex("DATATYPEID") > -1) {
            sequenceDefinition.setSequenceProperty("DATATYPEID", dataStore.getValue(n, "DATATYPEID"));
        }
        if (dataStore.getColumnIndex("data_type") > -1) {
            sequenceDefinition.setSequenceProperty("DATA_TYPE", dataStore.getValue(n, "DATA_TYPE"));
        }
        sequenceDefinition.setComment(this.getDSValueString(dataStore, n, "REMARKS", "LONG_COMMENT"));
        this.readSequenceSource(sequenceDefinition);
        return sequenceDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        String string4;
        String string5;
        String string6;
        int n = -1;
        int n2 = -1;
        switch (this.dbid) {
            case DB2_ISERIES: {
                string6 = "SELECT SEQUENCE_NAME, \n       SEQUENCE_SCHEMA \n,        0 as START, \n       minimum_value as MINVALUE, \n       maximum_value as MAXVALUE, \n       INCREMENT, \n       case cycle when 'YES' then 'Y' else 'N' end as CYCLE, \n       case ORDER when 'YES' then 'Y' else 'N' end as ORDER, \n       CACHE, \n       data_type, \n       long_comment as remarks \nFROM   qsys2" + this.catalogSeparator + "syssequences \n";
                string5 = "sequence_name";
                string4 = "sequence_schema";
                break;
            }
            case DB2_ZOS: {
                string6 = "SELECT NAME AS SEQNAME, \n       SCHEMA AS SEQUENCE_SCHEMA, \n       START, \n       MINVALUE, \n       MAXVALUE, \n       INCREMENT, \n       CYCLE, \n       ORDER, \n       CACHE, \n       DATATYPEID, \n       REMARKS \nFROM   SYSIBM.SYSSEQUENCES \n";
                string5 = "name";
                string4 = "schema";
                break;
            }
            default: {
                string6 = "SELECT SEQNAME AS SEQUENCE_NAME, \n       SEQSCHEMA as SEQUENCE_SCHEMA, \n       START, \n       MINVALUE, \n       MAXVALUE, \n       INCREMENT, \n       CYCLE, \n       ORDER, \n       CACHE, \n       DATATYPEID, \n       REMARKS  \nFROM   syscat.sequences \n";
                string5 = "seqname";
                string4 = "seqschema";
            }
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(string6.length() + 50);
        stringBuilder.append(string6);
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append(" WHERE " + string4 + " = ?");
            n = 1;
            bl = true;
        }
        if (StringUtil.isNonBlank(string3)) {
            if (bl) {
                stringBuilder.append(" AND ");
                n2 = 2;
            } else {
                stringBuilder.append(" WHERE ");
                n2 = 1;
            }
            if (string3.indexOf(37) > 0) {
                stringBuilder.append(string5).append(" LIKE ? ");
                SqlUtil.appendEscapeClause(stringBuilder, this.connection, string3);
                string3 = SqlUtil.escapeUnderscore(string3, this.connection);
            } else {
                stringBuilder.append(string5).append(" = ? ");
            }
        }
        String string7 = stringBuilder.toString();
        if (this.quoteKeyword) {
            string7 = string7.replace(" ORDER,", " \"ORDER\",");
            string7 = string7.replace(" ORDER ", " \"ORDER\" ");
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequence", string7, string2, string3);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DataStore dataStore = null;
        try {
            preparedStatement = this.connection.getSqlConnection().prepareStatement(string7);
            if (n > -1) {
                preparedStatement.setString(n, string2);
            }
            if (n2 > -1) {
                preparedStatement.setString(n2, string3);
            }
            resultSet = preparedStatement.executeQuery();
            dataStore = new DataStore(resultSet, this.connection, true);
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "sequence", string7, string2, string3);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return dataStore;
    }

    @Override
    public CharSequence getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        if (sequenceDefinition == null) {
            return null;
        }
        return sequenceDefinition.getSource();
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        StringBuilder stringBuilder = new StringBuilder(100);
        String string = Settings.getInstance().getInternalEditorLineEnding();
        stringBuilder.append("CREATE SEQUENCE ");
        stringBuilder.append(sequenceDefinition.getObjectExpression(this.connection));
        Number number = (Number)sequenceDefinition.getSequenceProperty("start_value");
        Number number2 = (Number)sequenceDefinition.getSequenceProperty("min_value");
        Number number3 = (Number)sequenceDefinition.getSequenceProperty("max_value");
        Number number4 = (Number)sequenceDefinition.getSequenceProperty("increment");
        boolean bl = Boolean.parseBoolean((String)sequenceDefinition.getSequenceProperty("cycle"));
        boolean bl2 = Boolean.parseBoolean((String)sequenceDefinition.getSequenceProperty("ordered"));
        Number number5 = (Number)sequenceDefinition.getSequenceProperty("cache");
        Number number6 = (Number)sequenceDefinition.getSequenceProperty("TYPEID");
        if (number6 != null) {
            stringBuilder.append(" AS " + this.typeIdToName(number6.intValue()));
        } else {
            String string2;
            Object object = sequenceDefinition.getSequenceProperty("DATA_TYPE");
            String string3 = string2 = object != null ? object.toString() : null;
            if (string2 != null) {
                stringBuilder.append(" AS ");
                stringBuilder.append(string2);
            }
        }
        stringBuilder.append(Db2SequenceReader.buildSequenceDetails(true, number, number2, number3, number4, bl, bl2, number5));
        stringBuilder.append(';');
        stringBuilder.append(string);
        if (StringUtil.isNonBlank(sequenceDefinition.getComment())) {
            stringBuilder.append("COMMENT ON SEQUENCE " + sequenceDefinition.getSequenceName() + " IS '" + sequenceDefinition.getComment().replace("'", "''") + "';");
            stringBuilder.append(string);
        }
        sequenceDefinition.setSource(stringBuilder);
    }

    public static CharSequence buildSequenceDetails(boolean bl, Number number, Number number2, Number number3, Number number4, boolean bl2, boolean bl3, Number number5) {
        StringBuilder stringBuilder = new StringBuilder(30);
        String string = Settings.getInstance().getInternalEditorLineEnding();
        if (number != null && number.longValue() > 0L) {
            if (bl) {
                stringBuilder.append(string + "       ");
            }
            stringBuilder.append("START WITH ");
            stringBuilder.append(number);
        }
        if (bl) {
            stringBuilder.append(string + "      ");
        }
        stringBuilder.append(" INCREMENT BY ");
        stringBuilder.append(number4);
        if (bl) {
            stringBuilder.append(string + "      ");
        }
        if (number2 == null || number2.longValue() == 0L) {
            if (bl) {
                stringBuilder.append(" NO MINVALUE");
            }
        } else {
            stringBuilder.append(" MINVALUE ");
            stringBuilder.append(number2);
        }
        if (bl) {
            stringBuilder.append(string + "      ");
        }
        if (number3 != null && number3.longValue() == -1L) {
            if (number3.longValue() != Long.MAX_VALUE) {
                stringBuilder.append(" MAXVALUE ");
                stringBuilder.append(number3);
            }
        } else if (bl) {
            stringBuilder.append(" NO MAXVALUE");
        }
        if (bl) {
            stringBuilder.append(string + "      ");
        }
        if (number5 != null && number5.longValue() > 0L) {
            if (number5.longValue() != 20L || bl) {
                stringBuilder.append(" CACHE ");
                stringBuilder.append(number5);
            }
        } else if (bl) {
            stringBuilder.append(" NO CACHE");
        }
        if (bl) {
            stringBuilder.append(string + "      ");
        }
        if (bl2) {
            stringBuilder.append(" CYCLE");
        } else if (bl) {
            stringBuilder.append(" NO CYCLE");
        }
        if (bl) {
            stringBuilder.append(string + "      ");
        }
        if (bl3) {
            stringBuilder.append(" ORDER");
        } else if (bl) {
            stringBuilder.append(" NO ORDER");
        }
        return stringBuilder;
    }

    private String typeIdToName(int n) {
        switch (n) {
            case 20: {
                return "BIGINT";
            }
            case 28: {
                return "SMALLINT";
            }
            case 16: {
                return "DECIMAL";
            }
        }
        return "INTEGER";
    }

    void setQuoteKeyword(boolean bl) {
        this.quoteKeyword = bl;
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }
}

