/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.File;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.importer.DataImporter;
import workbench.db.importer.ImportOptions;
import workbench.db.importer.RowDataProducer;
import workbench.db.importer.TextFileParser;
import workbench.db.importer.TextImportOptions;
import workbench.db.importer.WbXmlDataFileParser;
import workbench.interfaces.ImportFileParser;
import workbench.sql.wbcommands.CommonArgs;
import workbench.util.StringUtil;
import workbench.util.ValueConverter;

public class ProducerFactory {
    private ImportType importType = null;
    private TextImportOptions textOptions;
    private ImportOptions generalOptions;
    private File inputFile;
    private List<ColumnIdentifier> inputColumns;
    private TableIdentifier table;
    private RowDataProducer producer;
    private ImportFileParser fileParser;
    private WbConnection connection;

    public ProducerFactory(File file) {
        this.setInputFile(file);
    }

    public void setConnection(WbConnection wbConnection) {
        if (this.connection != wbConnection) {
            this.producer = null;
        }
        this.connection = wbConnection;
    }

    public ImportOptions getGeneralOptions() {
        return this.generalOptions;
    }

    public void setGeneralOptions(ImportOptions importOptions) {
        this.generalOptions = importOptions;
    }

    public void setTextOptions(TextImportOptions textImportOptions) {
        this.textOptions = textImportOptions;
    }

    public TextImportOptions getTextOptions() {
        return this.textOptions;
    }

    public void setImporterOptions(DataImporter dataImporter) {
        dataImporter.setMode(this.generalOptions.getMode());
    }

    public void setType(ImportType importType) {
        if (importType == ImportType.Text) {
            this.setImportTypeText();
        } else if (importType == ImportType.XML) {
            this.setImportTypeXml();
        }
    }

    public boolean isTextImport() {
        return this.importType == ImportType.Text;
    }

    public boolean isXmlImport() {
        return this.importType == ImportType.XML;
    }

    public boolean isSpreadsheetImport() {
        return this.importType == ImportType.Spreadsheet;
    }

    public void setImportTypeSpreadsheet() {
        this.importType = ImportType.Spreadsheet;
        this.producer = null;
    }

    public void setImportTypeText() {
        this.importType = ImportType.Text;
        this.producer = null;
    }

    public void setImportTypeXml() {
        this.importType = ImportType.XML;
        this.producer = null;
    }

    private void setInputFile(File file) {
        this.inputFile = file;
        this.inputColumns = null;
        this.producer = null;
        this.fileParser = null;
    }

    public void setTargetTable(TableIdentifier tableIdentifier) {
        this.table = tableIdentifier;
        if (this.table == null) {
            return;
        }
        if (this.producer == null) {
            this.getProducer();
        }
        this.fileParser.setTableName(tableIdentifier.getTableExpression());
    }

    public RowDataProducer getProducer() {
        if (this.producer == null) {
            switch (this.importType) {
                case Text: {
                    this.createTextFileParser();
                    break;
                }
                case XML: {
                    this.createXmlFileParser();
                    break;
                }
                case Spreadsheet: {
                    this.createSpreadsheetParser();
                }
            }
        }
        return this.producer;
    }

    public List<ColumnIdentifier> getFileColumns() {
        if (this.inputColumns == null) {
            this.getProducer();
            this.inputColumns = this.fileParser.getColumnsFromFile();
        }
        return this.inputColumns;
    }

    public void setColumnMap(List<ColumnIdentifier> list, List<ColumnIdentifier> list2) throws Exception {
        if (this.importType == ImportType.Text && this.textOptions.getContainsHeader()) {
            ((TextFileParser)this.producer).setColumnMap(list, list2);
        } else {
            this.setImportColumns(list2);
        }
    }

    public void setImportColumns(List<ColumnIdentifier> list) throws Exception {
        if (this.producer == null) {
            this.getProducer();
        }
        this.fileParser.setColumns(list);
    }

    private void createTextFileParser() {
        TextFileParser textFileParser = new TextFileParser(this.inputFile);
        textFileParser.setEncoding(this.generalOptions.getEncoding());
        textFileParser.setContainsHeader(this.textOptions.getContainsHeader());
        textFileParser.setTextQuoteChar(this.textOptions.getTextQuoteChar());
        textFileParser.setDecode(this.textOptions.getDecode());
        textFileParser.setTextDelimiter(this.textOptions.getTextDelimiter());
        textFileParser.setConnection(this.connection);
        textFileParser.setQuoteEscaping(this.textOptions.getQuoteEscaping());
        textFileParser.setAlwaysQuoted(this.textOptions.getQuoteAlways());
        ValueConverter valueConverter = new ValueConverter(this.connection);
        valueConverter.setDefaultDateFormat(this.generalOptions.getDateFormat());
        valueConverter.setDefaultTimestampFormat(this.generalOptions.getTimestampFormat());
        String string = this.textOptions.getDecimalChar();
        if (string != null) {
            valueConverter.setDecimalCharacter(string.charAt(0));
        }
        textFileParser.setValueConverter(valueConverter);
        if (this.table != null) {
            textFileParser.setTableName(this.table.getTableExpression());
        }
        this.inputColumns = null;
        this.producer = textFileParser;
        this.fileParser = textFileParser;
    }

    public File getSourceFile() {
        return this.inputFile;
    }

    private void createSpreadsheetParser() {
        this.inputColumns = null;
        this.producer = null;
        this.fileParser = null;
    }

    private void createXmlFileParser() {
        WbXmlDataFileParser wbXmlDataFileParser = new WbXmlDataFileParser(this.inputFile);
        wbXmlDataFileParser.setEncoding(this.generalOptions.getEncoding());
        if (this.table != null) {
            wbXmlDataFileParser.setTableName(this.table.getTableName());
        }
        this.inputColumns = null;
        this.producer = wbXmlDataFileParser;
        this.fileParser = wbXmlDataFileParser;
    }

    private void appendTextOptions(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        if (this.textOptions == null) {
            return;
        }
        this.appendArgument(stringBuilder, "header", this.textOptions.getContainsHeader(), stringBuilder2);
        this.appendArgument(stringBuilder, "decode", this.textOptions.getDecode(), stringBuilder2);
        String string = this.textOptions.getTextDelimiter();
        if ("\t".equals(string)) {
            string = "\\t";
        }
        CommonArgs.appendArgument(stringBuilder, "dateFormat", this.generalOptions.getDateFormat(), stringBuilder2);
        CommonArgs.appendArgument(stringBuilder, "timestampFormat", this.generalOptions.getTimestampFormat(), stringBuilder2);
        CommonArgs.appendArgument(stringBuilder, "delimiter", "'" + string + "'", stringBuilder2);
        CommonArgs.appendArgument(stringBuilder, "quotechar", this.textOptions.getTextQuoteChar(), stringBuilder2);
        CommonArgs.appendArgument(stringBuilder, "decimal", this.textOptions.getDecimalChar(), stringBuilder2);
        CommonArgs.appendArgument(stringBuilder, "fileColumns", this.fileParser.getColumns(), stringBuilder2);
        CommonArgs.appendArgument(stringBuilder, "quoteCharEscaping", this.textOptions.getQuoteEscaping().toString(), stringBuilder2);
    }

    private void appendArgument(StringBuilder stringBuilder, String string, boolean bl, StringBuilder stringBuilder2) {
        CommonArgs.appendArgument(stringBuilder, string, Boolean.toString(bl), stringBuilder2);
    }

    public StringBuilder getWbCommand() {
        StringBuilder stringBuilder = new StringBuilder(150);
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append('\n');
        for (int i = 0; i < "WbImport".length(); ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder2.append(' ');
        stringBuilder.append("WbImport -file=");
        String string = this.inputFile.getAbsolutePath();
        if (string.indexOf(45) > -1) {
            stringBuilder.append('\"');
        }
        stringBuilder.append(StringUtil.replace(string, "\\", "/"));
        if (string.indexOf(45) > -1) {
            stringBuilder.append('\"');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append('-');
        stringBuilder.append("type");
        stringBuilder.append('=');
        if (this.isXmlImport()) {
            stringBuilder.append("xml");
        } else {
            stringBuilder.append("text");
        }
        CommonArgs.appendArgument(stringBuilder, "table", this.table.getTableName(), stringBuilder2);
        CommonArgs.appendArgument(stringBuilder, "encoding", this.generalOptions.getEncoding(), stringBuilder2);
        this.appendTextOptions(stringBuilder, stringBuilder2);
        return stringBuilder;
    }

    public static enum ImportType {
        Text,
        XML,
        Spreadsheet;


        public static ImportType valueOf(int n) {
            if (n == 0) {
                return Text;
            }
            if (n == 1) {
                return XML;
            }
            if (n == 2) {
                return Spreadsheet;
            }
            return null;
        }

        public int toInteger() {
            if (this == Text) {
                return 0;
            }
            if (this == XML) {
                return 1;
            }
            if (this == Spreadsheet) {
                return 2;
            }
            return -1;
        }
    }
}

