/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import workbench.db.importer.ExcelReader;
import workbench.db.importer.OdsReader;
import workbench.util.MessageBuffer;
import workbench.util.WbFile;

public interface SpreadsheetReader {
    public MessageBuffer getMessages();

    public List<String> getHeaderColumns();

    public void setActiveWorksheet(int var1);

    public void setActiveWorksheet(String var1);

    public List<Object> getRowValues(int var1);

    public void setNullString(String var1);

    public void setEmptyStringIsNull(boolean var1);

    public void setReturnDatesAsString(boolean var1);

    public void enableRecalcOnLoad(boolean var1);

    public int getRowCount();

    public void done();

    public void load() throws IOException;

    public List<String> getSheets();

    public static class Factory {
        public static SpreadsheetReader createReader(File file, int n, String string) {
            WbFile wbFile = new WbFile(file);
            String string2 = wbFile.getExtension();
            if (string2 == null) {
                return null;
            }
            string2 = string2.toLowerCase();
            SpreadsheetReader spreadsheetReader = null;
            if (string2.startsWith("xls")) {
                spreadsheetReader = new ExcelReader(file, n, string);
            } else if (string2.equals("ods")) {
                spreadsheetReader = new OdsReader(file, n, string);
            }
            return spreadsheetReader;
        }
    }
}

