/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.util.StringUtil;

public class ValueStatement {
    private Map<Integer, Integer> columnIndexMap;
    private PreparedStatement select;
    private String selectSql;
    private Pattern columnReference = Pattern.compile("\\$[0-9]+");

    public ValueStatement(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(string);
        SQLToken sQLToken = sQLLexer.getNextToken(false, true);
        int n = 1;
        this.columnIndexMap = new HashMap<Integer, Integer>();
        while (sQLToken != null) {
            String string2 = sQLToken.getText();
            Matcher matcher = this.columnReference.matcher(string2);
            if (matcher.matches()) {
                stringBuilder.append('?');
                this.columnIndexMap.put(Integer.valueOf(string2.substring(1)), n);
                ++n;
            } else {
                stringBuilder.append(sQLToken.getText());
            }
            sQLToken = sQLLexer.getNextToken(false, true);
        }
        this.selectSql = stringBuilder.toString();
    }

    public void done() {
        if (this.select != null) {
            JdbcUtils.closeStatement(this.select);
            this.select = null;
        }
    }

    protected String getSelectSQL() {
        return this.selectSql;
    }

    protected int getIndexInStatement(int n) {
        Integer n2 = this.columnIndexMap.get(n);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    public void prepareSelect(WbConnection wbConnection) throws SQLException {
        this.select = wbConnection.getSqlConnection().prepareStatement(this.selectSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDatabaseValue(WbConnection wbConnection, Map<Integer, Object> map) throws SQLException {
        if (this.select == null) {
            this.prepareSelect(wbConnection);
        }
        int n = 0;
        Object object = null;
        for (Map.Entry<Integer, Object> entry : map.entrySet()) {
            Object object2;
            int n2 = this.getIndexInStatement(entry.getKey());
            if (n2 <= 0 || (object2 = entry.getValue()) == null || object2 instanceof String && StringUtil.isEmptyString((String)object2)) continue;
            try {
                if (object2 instanceof String) {
                    this.select.setString(n2, (String)object2);
                } else if (object2 instanceof Long) {
                    this.select.setLong(n2, (Long)object2);
                } else if (object2 instanceof Integer) {
                    this.select.setInt(n2, (Integer)object2);
                } else if (object2 instanceof BigDecimal) {
                    this.select.setBigDecimal(n2, (BigDecimal)object2);
                } else {
                    this.select.setObject(n2, object2);
                }
                ++n;
            }
            catch (SQLException sQLException) {
                LogMgr.logError(new CallerInfo(){}, "Could not set statement parameter at index " + n2 + " to: " + object2, sQLException);
                throw sQLException;
            }
        }
        if (n != this.columnIndexMap.size()) {
            LogMgr.logWarning(new CallerInfo(){}, "Not all values needed, where found in the column values. Expected: " + this.columnIndexMap.size() + ", found: " + n);
            if (LogMgr.isDebugEnabled()) {
                LogMgr.logDebug(new CallerInfo(){}, "Values from input row: " + map);
            }
            return null;
        }
        try {
            Object object3;
            block18: {
                object3 = null;
                try {
                    object3 = this.select.executeQuery();
                    if (!object3.next()) break block18;
                    object = object3.getObject(1);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResult(object3);
                    throw throwable;
                }
            }
            JdbcUtils.closeResult((ResultSet)object3);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve lookup value with input values: " + map.values(), sQLException);
            throw sQLException;
        }
        return object;
    }

    public Set<Integer> getInputColumnIndexes() {
        return Collections.unmodifiableSet(this.columnIndexMap.keySet());
    }
}

