/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer.detector;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.importer.detector.ColumnStatistics;
import workbench.db.importer.detector.TableDetector;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CsvLineParser;
import workbench.util.CsvLineReader;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.QuoteEscapeType;
import workbench.util.StringUtil;
import workbench.util.ValueConverter;
import workbench.util.WbFile;

public class TextFileTableDetector
extends TableDetector {
    private final String encoding;
    private boolean enableMultiline;
    private final CsvLineParser parser;

    public TextFileTableDetector(File file, String string, String string2, String string3, String string4, boolean bl, String string5) {
        this.inputFile = new WbFile(file);
        this.withHeader = bl;
        this.encoding = string5;
        this.converter = new ValueConverter(string3, string4);
        this.converter.setLogWarnings(false);
        char c = '\u0000';
        if (StringUtil.isNonEmpty(string2)) {
            c = string2.charAt(0);
        }
        this.parser = new CsvLineParser(string, c);
        this.parser.setReturnEmptyStrings(true);
        this.parser.setTrimValues(true);
    }

    public void setDecimalChar(char c) {
        this.converter.setDecimalCharacter(c);
    }

    public void setEnableMultiline(boolean bl) {
        this.enableMultiline = bl;
    }

    public void setQuoteEscape(QuoteEscapeType quoteEscapeType) {
        this.parser.setQuoteEscaping(quoteEscapeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFile() {
        String string;
        CsvLineReader csvLineReader;
        BufferedReader bufferedReader;
        int n;
        block7: {
            n = 0;
            bufferedReader = null;
            String string2 = StringUtil.LINE_TERMINATOR;
            if (this.enableMultiline) {
                string2 = FileUtil.getLineEnding(this.inputFile, this.encoding);
            }
            bufferedReader = EncodingUtil.createBufferedReader(this.inputFile, this.encoding);
            csvLineReader = new CsvLineReader(bufferedReader, this.parser.getQuoteChar(), this.parser.getEscapeType(), this.enableMultiline, string2);
            string = csvLineReader.readLine();
            if (string != null) break block7;
            FileUtil.closeQuietely(bufferedReader);
            return;
        }
        try {
            ++n;
            this.initColumns(string);
            String string3 = csvLineReader.readLine();
            while (string3 != null && n < this.sampleSize) {
                List<String> list = this.parseLine(string3);
                this.analyzeValues(list, this.columns);
                string3 = csvLineReader.readLine();
                ++n;
            }
        }
        catch (IOException iOException) {
            try {
                this.messages.append(iOException.getLocalizedMessage());
                LogMgr.logError(new CallerInfo(){}, "Could not read file " + this.inputFile.getAbsolutePath(), iOException);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(bufferedReader);
                throw throwable;
            }
            FileUtil.closeQuietely(bufferedReader);
        }
        FileUtil.closeQuietely(bufferedReader);
    }

    private void initColumns(String string) {
        List<String> list = this.parseLine(string);
        this.columns = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            String string2 = this.withHeader ? list.get(i) : "column_" + Integer.valueOf(i + 1);
            this.columns.add(new ColumnStatistics(string2));
        }
    }

    private List<String> parseLine(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StringUtil.isEmptyString(string)) {
            return arrayList;
        }
        this.parser.setLine(string);
        while (this.parser.hasNext()) {
            arrayList.add(this.parser.getNext());
        }
        return arrayList;
    }
}

