/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.monetdb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import workbench.db.JdbcProcedureReader;
import workbench.db.JdbcUtils;
import workbench.db.NoConfigException;
import workbench.db.ProcedureDefinition;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.ExceptionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class MonetDbProcedureReader
extends JdbcProcedureReader {
    public MonetDbProcedureReader(WbConnection wbConnection) {
        super(wbConnection);
    }

    @Override
    public DataStore getProcedures(String string, String string2, String string3) throws SQLException {
        DataStore dataStore;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select null as procedure_cat,  \n       sch.name as procedure_schem,  \n       fct.name as procedure_name,  \n       null as reserved_1,  \n       null as reserved_2,  \n       null as reserved_3,  \n       null as remarks,  \n       case type  \n           when 2 then 1  \n           else 2 \n       end as procedure_type, \n       fct.name || ':' || fct.id as specific_name \nfrom sys.functions fct \n  left join sys.schemas sch on sch.id = fct.schema_id \n");
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append("where ");
            SqlUtil.appendExpression(stringBuilder, "sch.name", string2, this.connection);
        }
        stringBuilder.append("\norder by 2,3");
        LogMgr.logMetadataSql(new CallerInfo(){}, "procedures", stringBuilder, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        try {
            savepoint = this.connection.setSavepoint();
            statement = this.connection.createStatementForQuery();
            resultSet = statement.executeQuery(stringBuilder.toString());
            DataStore dataStore2 = this.fillProcedureListDataStore(resultSet);
            dataStore2.resetStatus();
            this.connection.releaseSavepoint(savepoint);
            dataStore = dataStore2;
        }
        catch (SQLException sQLException) {
            try {
                this.connection.rollback(savepoint);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        return dataStore;
    }

    @Override
    public DataStore getProcedureColumns(ProcedureDefinition procedureDefinition) throws SQLException {
        String string = procedureDefinition.getSpecificName();
        if (StringUtil.isEmptyString(string)) {
            string = procedureDefinition.getProcedureName();
        }
        return this.getProcedureColumns(procedureDefinition.getCatalog(), procedureDefinition.getSchema(), string, null);
    }

    @Override
    public DataStore getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        DataStore dataStore = this.createProcColsDataStore();
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select null as procedure_cat,  \n       sch.name as procedure_name,  \n       arg.name as column_name,  \n       1 as column_type,  \n       case arg.type  \n         when 'double' then 8 \n         when 'int' then 4 \n         when 'varchar' then 12 \n         when 'decimal' then 3 \n         when 'date' then 91 \n         when 'timestamp' then 93 \n         when 'time' then 92 \n         when 'clob' then 2005 \n         when 'blob' then 2004 \n         when 'boolean' then 16 \n         when 'real' then 7 \n         when 'tinyint' then -6 \n         when 'smallint' then 5 \n         else 1111\n        end as data_type, \n       arg.type as type_name, \n       arg.type_digits as precision, \n       arg.type_digits as length, \n       arg.type_scale as scale, \n       null as radix, \n       null as remarks, \n       null as column_def, \n       null as SQL_DATA_TYPE, \n       null as SQL_DATETIME_SUB, \n       case when arg.type = 'varchar' then arg.type_digits else null end as CHAR_OCTET_LENGTH, \n       arg.number + 1 as ORDINAL_POSITION, \n       'YES' as IS_NULLABLE \nfrom sys.args arg \n  join sys.functions fct on fct.id = arg.func_id \n  left join sys.schemas sch on sch.id = fct.schema_id \n");
        this.appendProcNameCondition(stringBuilder, string3);
        if (StringUtil.isNonBlank(string2)) {
            SqlUtil.appendAndCondition(stringBuilder, "sch.name", string2, this.connection);
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "procedure columns", stringBuilder, new Object[0]);
        Statement statement = this.connection.createStatementForQuery();
        try {
            savepoint = this.connection.setSavepoint();
            resultSet = statement.executeQuery(stringBuilder.toString());
            while (resultSet.next()) {
                this.processProcedureColumnResultRow(dataStore, resultSet);
            }
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                this.connection.rollback(savepoint);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        return dataStore;
    }

    private void appendProcNameCondition(StringBuilder stringBuilder, ProcedureDefinition procedureDefinition) {
        String string = procedureDefinition.getSpecificName();
        if (string == null) {
            string = procedureDefinition.getProcedureName();
        }
        this.appendProcNameCondition(stringBuilder, string);
    }

    private void appendProcNameCondition(StringBuilder stringBuilder, String string) {
        int n = string.indexOf(58);
        String string2 = null;
        if (n > -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        stringBuilder.append(" where fct.name = '" + string + "'\n");
        if (string2 != null) {
            stringBuilder.append("  AND fct.id=");
            stringBuilder.append(string2);
            stringBuilder.append("\n ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CharSequence retrieveProcedureSource(ProcedureDefinition procedureDefinition) throws NoConfigException {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("select fct.func \nfrom sys.functions fct\n  left join sys.schemas sch on sch.id = fct.schema_id");
        StringBuilder stringBuilder2 = new StringBuilder(500);
        this.appendProcNameCondition(stringBuilder, procedureDefinition);
        LogMgr.logMetadataSql(new CallerInfo(){}, "procedure source", stringBuilder, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        try {
            if (this.useSavepoint) {
                savepoint = this.connection.setSavepoint();
            }
            statement = this.connection.createStatementForQuery();
            resultSet = statement.executeQuery(stringBuilder.toString());
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                if (string == null) continue;
                stringBuilder2.append(string);
            }
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                if (savepoint != null) {
                    this.connection.rollback(savepoint);
                }
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "procedure source", stringBuilder, new Object[0]);
                stringBuilder2 = new StringBuilder(ExceptionUtil.getDisplay(sQLException));
                this.connection.rollback(savepoint);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return stringBuilder2;
    }
}

