/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class SqlServerSequenceReader
implements SequenceReader {
    private WbConnection connection;
    private Set<String> noPrecisionTypes = CollectionUtil.caseInsensitiveSet("tinyint", "smallint", "int", "bigint");

    public SqlServerSequenceReader(WbConnection wbConnection) {
        this.connection = wbConnection;
    }

    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>();
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            arrayList.add(this.createDefinition(dataStore, i));
        }
        return arrayList;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return null;
        }
        SequenceDefinition sequenceDefinition = this.createDefinition(dataStore, 0);
        return sequenceDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("SELECT db_name() as sequence_catalog,   \n       sc.name as sequence_schema,  \n       sq.name as sequence_name,         \n       cast(sq.minimum_value as bigint) as minimum_value,         \n       cast(sq.maximum_value as bigint) as maximum_value,         \n       cast(sq.start_value as bigint) as start_value,         \n       cast(sq.increment as bigint) as increment,         \n       case when is_cycling = 1 then 'CYCLE' else 'NO CYCLE' end as cycle_flag,  \n       sq.is_cached,  \n       sq.cache_size,  \n       type_name(sq.system_type_id) as data_type,  \n       type_name(sq.user_type_id) as user_type,  \n       sq.precision,  \n       cast(sq.current_value  as bigint) as current_value \nFROM sys.sequences sq with (nolock)  \n   join sys.schemas sc with (nolock) on sq.schema_id = sc.schema_id WHERE sc.name = '");
        stringBuilder.append(SqlUtil.removeObjectQuotes(string2));
        stringBuilder.append("' ");
        if (StringUtil.isNonEmpty(string3)) {
            SqlUtil.appendAndCondition(stringBuilder, "sq.name", string3, this.connection);
        }
        stringBuilder.append("\n ORDER BY 1,2");
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequence definition", stringBuilder, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        DataStore dataStore = null;
        try {
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery(stringBuilder.toString());
            dataStore = new DataStore(resultSet, this.connection, true);
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "sequence definition", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return dataStore;
    }

    @Override
    public CharSequence getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        if (sequenceDefinition == null) {
            return null;
        }
        if (sequenceDefinition.getSource() == null) {
            this.readSequenceSource(sequenceDefinition);
        }
        return sequenceDefinition.getSource();
    }

    private SequenceDefinition createDefinition(DataStore dataStore, int n) {
        if (dataStore == null || n >= dataStore.getRowCount()) {
            return null;
        }
        String string = dataStore.getValueAsString(n, "SEQUENCE_NAME");
        String string2 = dataStore.getValueAsString(n, "SEQUENCE_SCHEMA");
        String string3 = dataStore.getValueAsString(n, "SEQUENCE_CATALOG");
        SequenceDefinition sequenceDefinition = new SequenceDefinition(string2, string);
        sequenceDefinition.setCatalog(string3);
        sequenceDefinition.setSequenceProperty("min_value", dataStore.getValue(n, "minimum_value"));
        sequenceDefinition.setSequenceProperty("max_value", dataStore.getValue(n, "maximum_value"));
        sequenceDefinition.setSequenceProperty("start_value", dataStore.getValue(n, "start_value"));
        sequenceDefinition.setSequenceProperty("increment", dataStore.getValue(n, "increment"));
        sequenceDefinition.setSequenceProperty("cycle", "CYCLE".equals(dataStore.getValueAsString(n, "cycle_flag")));
        sequenceDefinition.setSequenceProperty("is_cached", StringUtil.stringToBool(dataStore.getValueAsString(n, "is_cached")));
        sequenceDefinition.setSequenceProperty("cache", dataStore.getValue(n, "cache_size"));
        sequenceDefinition.setSequenceProperty("current_value", dataStore.getValue(n, "current_value"));
        sequenceDefinition.setSequenceProperty("data_type", dataStore.getValue(n, "data_type"));
        sequenceDefinition.setSequenceProperty("user_data_type", dataStore.getValue(n, "user_type"));
        sequenceDefinition.setSequenceProperty("precision", dataStore.getValue(n, "precision"));
        return sequenceDefinition;
    }

    private BigDecimal getNumberValue(SequenceDefinition sequenceDefinition, String string) {
        Object object = sequenceDefinition.getSequenceProperty(string);
        if (object == null) {
            return null;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(object.toString());
            return bigDecimal;
        }
        catch (NumberFormatException numberFormatException) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not convert " + object + " to a number", numberFormatException);
            return null;
        }
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition == null) {
            return;
        }
        if (sequenceDefinition.getSource() != null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        String string = Settings.getInstance().getInternalEditorLineEnding();
        stringBuilder.append("CREATE SEQUENCE ");
        stringBuilder.append(sequenceDefinition.getSequenceName());
        BigDecimal bigDecimal = this.getNumberValue(sequenceDefinition, "min_value");
        BigDecimal bigDecimal2 = this.getNumberValue(sequenceDefinition, "max_value");
        BigDecimal bigDecimal3 = this.getNumberValue(sequenceDefinition, "start_value");
        BigDecimal bigDecimal4 = this.getNumberValue(sequenceDefinition, "increment");
        Boolean bl = (Boolean)sequenceDefinition.getSequenceProperty("cycle");
        Boolean bl2 = (Boolean)sequenceDefinition.getSequenceProperty("is_cached");
        Number number = (Number)sequenceDefinition.getSequenceProperty("cache");
        Number number2 = (Number)sequenceDefinition.getSequenceProperty("precision");
        String string2 = (String)sequenceDefinition.getSequenceProperty("data_type");
        String string3 = (String)sequenceDefinition.getSequenceProperty("user_data_type");
        String string4 = string2;
        if (!string2.equals(string3)) {
            string4 = string3;
        }
        stringBuilder.append(string).append("       AS ");
        stringBuilder.append(string4);
        if (this.needsPrecision(string4) && number2 != null) {
            stringBuilder.append('(');
            stringBuilder.append(number2.toString());
            stringBuilder.append(')');
        }
        stringBuilder.append(string).append("       INCREMENT BY ");
        stringBuilder.append(bigDecimal4);
        if (bigDecimal != null && !this.isMinValue(string4, bigDecimal)) {
            stringBuilder.append(string).append("       MINVALUE ");
            stringBuilder.append(bigDecimal);
        } else {
            stringBuilder.append(string).append("       NO MINVALUE");
        }
        if (bigDecimal2 != null && !this.isMaxValue(string4, bigDecimal2)) {
            stringBuilder.append(string).append("       MAXVALUE ");
            stringBuilder.append(bigDecimal2);
        } else {
            stringBuilder.append(string).append("       NO MAXVALUE");
        }
        if (bigDecimal3 != null && (bigDecimal != null && !((Object)bigDecimal3).equals(bigDecimal) || bigDecimal == null)) {
            stringBuilder.append(string).append("       START WITH ");
            stringBuilder.append(bigDecimal3);
        }
        if (Boolean.TRUE.equals(bl2)) {
            stringBuilder.append(string).append("       CACHE ");
            if (number != null && number.longValue() > 0L) {
                stringBuilder.append(number);
            }
        } else {
            stringBuilder.append(string).append("       NOCACHE");
        }
        stringBuilder.append(string).append("       ");
        stringBuilder.append(bl != false ? "CYCLE" : "NOCYCLE");
        stringBuilder.append(';');
        stringBuilder.append(string);
        sequenceDefinition.setSource(stringBuilder);
    }

    private boolean isMaxValue(String string, Number number) {
        if (number == null) {
            return true;
        }
        if ("bigint".equals(string)) {
            return number.toString().equals("9223372036854775807");
        }
        if ("tinyint".equals(string)) {
            return number.intValue() == 255;
        }
        if ("smallint".equals(string)) {
            return number.longValue() == 32767L;
        }
        if ("int".equals(string)) {
            return number.longValue() == Integer.MAX_VALUE;
        }
        return false;
    }

    private boolean isMinValue(String string, Number number) {
        if (number == null) {
            return true;
        }
        if ("bigint".equals(string)) {
            return number.toString().equals("-9223372036854775808");
        }
        if ("tinyint".equals(string)) {
            return number.intValue() == 0;
        }
        if ("smallint".equals(string)) {
            return number.longValue() == -32768L;
        }
        if ("int".equals(string)) {
            return number.longValue() == Integer.MIN_VALUE;
        }
        return false;
    }

    private boolean needsPrecision(String string) {
        return !this.noPrecisionTypes.contains(string);
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }
}

