/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.util.List;
import java.util.Set;
import workbench.db.WbConnection;
import workbench.resource.Settings;
import workbench.sql.StatementHook;
import workbench.sql.StatementRunner;
import workbench.sql.StatementRunnerResult;
import workbench.util.CollectionUtil;

public class SqlServerStatementHook
implements StatementHook {
    private final Set<String> verbsWithSemicolon;

    public SqlServerStatementHook() {
        List<String> list = Settings.getInstance().getListProperty("workbench.db.microsoft_sql_server.semicolon.bug", false);
        if (list.isEmpty()) {
            this.verbsWithSemicolon = null;
        } else {
            this.verbsWithSemicolon = CollectionUtil.caseInsensitiveSet();
            this.verbsWithSemicolon.addAll(list);
        }
    }

    @Override
    public String preExec(StatementRunner statementRunner, String string) {
        if (this.verbsWithSemicolon == null) {
            return string + ";";
        }
        String string2 = statementRunner.getConnection().getParsingUtil().getSqlVerb(string);
        if (this.verbsWithSemicolon.contains(string2)) {
            return string + ";";
        }
        return string;
    }

    @Override
    public void postExec(StatementRunner statementRunner, String string, StatementRunnerResult statementRunnerResult) {
    }

    @Override
    public boolean isPending() {
        return false;
    }

    @Override
    public boolean displayResults() {
        return true;
    }

    @Override
    public boolean fetchResults() {
        return true;
    }

    @Override
    public void close(WbConnection wbConnection) {
    }
}

