/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DependencyNode;
import workbench.db.IndexDefinition;
import workbench.db.JdbcUtils;
import workbench.db.ObjectSourceOptions;
import workbench.db.PkDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.WbConnection;
import workbench.db.mssql.PartitionFunction;
import workbench.db.mssql.PartitionScheme;
import workbench.db.mssql.SqlServerPartitionReader;
import workbench.db.mssql.SqlServerUtil;
import workbench.db.sqltemplates.TemplateHandler;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class SqlServerTableSourceBuilder
extends TableSourceBuilder {
    public static final String CLUSTERED_PLACEHOLDER = "%clustered_attribute%";
    private static final String OPTION_KEY_SCHEME = "partition_scheme";
    private static final String OPTION_KEY_COLUMNS = "partition_columns";

    public SqlServerTableSourceBuilder(WbConnection wbConnection) {
        super(wbConnection);
    }

    @Override
    public CharSequence getPkSource(TableIdentifier tableIdentifier, PkDefinition pkDefinition, boolean bl, boolean bl2) {
        CharSequence charSequence = super.getPkSource(tableIdentifier, pkDefinition, bl, bl2);
        if (StringUtil.isEmptyString(charSequence)) {
            return charSequence;
        }
        String string = charSequence.toString();
        String string2 = null;
        if (pkDefinition.getPkIndexDefinition() != null) {
            String string3 = pkDefinition.getPkIndexDefinition().getIndexType();
            string2 = "NORMAL".equals(string3) ? "NONCLUSTERED" : "CLUSTERED";
        }
        string = string2 == null ? TemplateHandler.removePlaceholder(string, CLUSTERED_PLACEHOLDER, true) : TemplateHandler.replacePlaceholder(string, CLUSTERED_PLACEHOLDER, string2, true);
        return string;
    }

    @Override
    protected String getAdditionalFkSql(TableIdentifier tableIdentifier, DependencyNode dependencyNode, String string) {
        string = !dependencyNode.isValidated() ? string.replace("%nocheck%", "WITH NOCHECK ") : string.replace("%nocheck%", "");
        if (!dependencyNode.isEnabled()) {
            string = string + "\nALTER TABLE " + tableIdentifier.getObjectExpression(this.dbConnection) + " NOCHECK CONSTRAINT " + this.dbConnection.getMetadata().quoteObjectname(dependencyNode.getFkName());
        }
        return string;
    }

    @Override
    public String getAdditionalTableInfo(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, List<IndexDefinition> list2) {
        if (SqlServerUtil.isSqlServer2012(this.dbConnection) && !tableIdentifier.getSourceOptions().isInitialized()) {
            return this.readExtendeStats(tableIdentifier);
        }
        return null;
    }

    @Override
    public void readTableOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        if (SqlServerUtil.supportsPartitioning(this.dbConnection)) {
            this.readPartitionDefinition(tableIdentifier);
        }
    }

    private void readPartitionDefinition(TableIdentifier tableIdentifier) {
        String string = "SELECT ps.name as partition_scheme,\n       c.name AS column_name\nFROM sys.tables AS t   \n  JOIN sys.indexes AS i ON t.object_id = i.object_id AND i.type <= 1 \n  JOIN sys.partition_schemes AS ps ON ps.data_space_id = i.data_space_id \n  JOIN sys.index_columns AS ic \n    ON ic.object_id = i.object_id   \n   AND ic.index_id = i.index_id   \n   AND ic.partition_ordinal >= 1\n  JOIN sys.columns AS c \n    ON t.object_id = c.object_id   \n   AND ic.column_id = c.column_id   \nWHERE t.object_id = object_id(?)\nORDER BY ic.partition_ordinal";
        CallerInfo callerInfo = new CallerInfo(){};
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = tableIdentifier.getTableExpression(this.dbConnection);
        LogMgr.logMetadataSql(callerInfo, "partition info", string, string2);
        String string3 = null;
        try {
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, string2);
            resultSet = preparedStatement.executeQuery();
            int n = 0;
            String string4 = "";
            while (resultSet.next()) {
                if (n == 0) {
                    string3 = resultSet.getString(1);
                } else {
                    string4 = string4 + ",";
                }
                string4 = string4 + resultSet.getString(2);
                ++n;
            }
            if (string3 != null && string4 != null) {
                tableIdentifier.getSourceOptions().setTableOption("ON " + string3 + " (" + string4 + ")");
                tableIdentifier.getSourceOptions().addConfigSetting(OPTION_KEY_SCHEME, string3);
                tableIdentifier.getSourceOptions().addConfigSetting(OPTION_KEY_COLUMNS, string4);
                this.readPartitionSchemeAndFunction(tableIdentifier);
                tableIdentifier.getSourceOptions().setInitialized();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logMetadataError(callerInfo, throwable, "partition info", string, string2);
        }
    }

    private void readPartitionSchemeAndFunction(TableIdentifier tableIdentifier) {
        PartitionScheme partitionScheme;
        SqlServerPartitionReader sqlServerPartitionReader = new SqlServerPartitionReader(this.dbConnection);
        PartitionFunction partitionFunction = sqlServerPartitionReader.getFunctionForTable(tableIdentifier);
        if (partitionFunction != null) {
            tableIdentifier.getSourceOptions().appendAdditionalSql("-- partitioning details");
            tableIdentifier.getSourceOptions().appendAdditionalSql(partitionFunction.getSource());
        }
        if ((partitionScheme = sqlServerPartitionReader.getSchemeForTable(tableIdentifier)) != null) {
            tableIdentifier.getSourceOptions().appendAdditionalSql("\n" + partitionScheme.getSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readExtendeStats(TableIdentifier tableIdentifier) {
        ObjectSourceOptions objectSourceOptions;
        StringBuilder stringBuilder;
        PreparedStatement preparedStatement;
        ResultSet resultSet;
        block12: {
            if (tableIdentifier == null) {
                return null;
            }
            String string = "select st.name as stats_name, c.name as column_name, st.has_filter, st.filter_definition\nfrom sys.stats st\n  join sys.stats_columns sc on sc.stats_id = st.stats_id and sc.object_id = st.object_id\n  join sys.columns c on c.column_id = sc.column_id and c.object_id = st.object_id\nwhere st.user_created = 1 \n  and st.object_id = object_id(?) \norder by st.stats_id, sc.stats_column_id";
            resultSet = null;
            preparedStatement = null;
            stringBuilder = new StringBuilder();
            String string2 = tableIdentifier.getTableExpression(this.dbConnection);
            CallerInfo callerInfo = new CallerInfo(){};
            LogMgr.logMetadataSql(callerInfo, "column statistics", string, string2);
            objectSourceOptions = tableIdentifier.getSourceOptions();
            String string3 = null;
            String string4 = null;
            try {
                preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
                preparedStatement.setString(1, tableIdentifier.getFullyQualifiedName(this.dbConnection));
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string5 = resultSet.getString(1);
                    String string6 = resultSet.getString(2);
                    String string7 = resultSet.getString(4);
                    if (string3 == null || !string3.equals(string5)) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(")");
                            if (string4 != null) {
                                stringBuilder.append("\nWHERE ");
                                stringBuilder.append(string4);
                            }
                            stringBuilder.append(";\n\n");
                        }
                        stringBuilder.append("CREATE STATISTICS ");
                        stringBuilder.append(this.dbConnection.getMetadata().quoteObjectname(string5));
                        stringBuilder.append("\n  ON ");
                        stringBuilder.append(string2);
                        stringBuilder.append("(");
                        stringBuilder.append(string6);
                        string4 = string7;
                        string3 = string5;
                        continue;
                    }
                    stringBuilder.append(",");
                    stringBuilder.append(string6);
                }
                if (stringBuilder.length() <= 0) break block12;
                stringBuilder.append(")");
                if (string4 != null) {
                    stringBuilder.append("\nWHERE ");
                    stringBuilder.append(string4);
                }
                stringBuilder.append(";");
            }
            catch (Exception exception) {
                try {
                    LogMgr.logMetadataError(callerInfo, exception, "column statistics", string, string2);
                    stringBuilder = null;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        if (stringBuilder.length() > 0) {
            objectSourceOptions.addConfigSetting("column_statistics", stringBuilder.toString());
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return "\n" + stringBuilder.toString();
    }
}

