/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mysql;

import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.storage.ColumnData;
import workbench.storage.MergeGenerator;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.RowDataContainer;
import workbench.storage.SqlLiteralFormatter;

public class MySQLMergeGenerator
implements MergeGenerator {
    private SqlLiteralFormatter formatter = new SqlLiteralFormatter("mysql");

    @Override
    public String generateMerge(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(100);
        this.generateInsert(stringBuilder, rowDataContainer, true);
        this.generateUpdate(stringBuilder, rowDataContainer);
        return stringBuilder.toString();
    }

    @Override
    public String generateMergeStart(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(100);
        this.generateInsert(stringBuilder, rowDataContainer, false);
        return stringBuilder.toString();
    }

    @Override
    public String addRow(ResultInfo resultInfo, RowData rowData, long l) {
        StringBuilder stringBuilder = new StringBuilder(100);
        this.appendValues(stringBuilder, rowData, resultInfo, l);
        return stringBuilder.toString();
    }

    @Override
    public String generateMergeEnd(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(100);
        this.generateUpdate(stringBuilder, rowDataContainer);
        return stringBuilder.toString();
    }

    private void generateUpdate(StringBuilder stringBuilder, RowDataContainer rowDataContainer) {
        ResultInfo resultInfo = rowDataContainer.getResultInfo();
        stringBuilder.append("\nON DUPLICATE KEY UPDATE\n");
        int n = 0;
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            ColumnIdentifier columnIdentifier = resultInfo.getColumn(i);
            if (columnIdentifier.isPkColumn()) continue;
            if (n > 0) {
                stringBuilder.append(",\n");
            }
            stringBuilder.append("  ");
            stringBuilder.append(resultInfo.getColumnName(i));
            stringBuilder.append(" = values(");
            stringBuilder.append(resultInfo.getColumnName(i));
            stringBuilder.append(')');
            ++n;
        }
        stringBuilder.append(';');
    }

    private void generateInsert(StringBuilder stringBuilder, RowDataContainer rowDataContainer, boolean bl) {
        int n;
        TableIdentifier tableIdentifier = rowDataContainer.getUpdateTable();
        stringBuilder.append("INSERT INTO ");
        stringBuilder.append(tableIdentifier.getTableExpression(rowDataContainer.getOriginalConnection()));
        stringBuilder.append("\n  (");
        ResultInfo resultInfo = rowDataContainer.getResultInfo();
        for (n = 0; n < resultInfo.getColumnCount(); ++n) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(resultInfo.getColumnName(n));
        }
        stringBuilder.append(")\nVALUES\n");
        if (bl) {
            for (n = 0; n < rowDataContainer.getRowCount(); ++n) {
                this.appendValues(stringBuilder, rowDataContainer.getRow(n), resultInfo, n);
            }
        }
    }

    private void appendValues(StringBuilder stringBuilder, RowData rowData, ResultInfo resultInfo, long l) {
        if (l > 0L) {
            stringBuilder.append(",\n");
        }
        stringBuilder.append("  (");
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            ColumnData columnData = new ColumnData(rowData.getValue(i), resultInfo.getColumn(i));
            stringBuilder.append(this.formatter.getDefaultLiteral(columnData));
        }
        stringBuilder.append(')');
    }
}

