/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mysql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import workbench.db.JdbcProcedureReader;
import workbench.db.JdbcUtils;
import workbench.db.ProcedureDefinition;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.storage.DataStore;
import workbench.util.StringUtil;

public class MySqlProcedureReader
extends JdbcProcedureReader {
    public MySqlProcedureReader(WbConnection wbConnection) {
        super(wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuilder getProcedureHeader(ProcedureDefinition procedureDefinition) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        StringBuilder stringBuilder;
        block9: {
            stringBuilder = new StringBuilder(150);
            String string = "SELECT routine_type, dtd_identifier \nFROM information_schema.routines \n WHERE routine_schema = ? \n  and  routine_name = ? \n";
            LogMgr.logMetadataSql(new CallerInfo(){}, "procedure header", string, procedureDefinition.getCatalog(), procedureDefinition.getProcedureName());
            String string2 = Settings.getInstance().getInternalEditorLineEnding();
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = this.connection.getSqlConnection().prepareStatement(string);
                preparedStatement.setString(1, procedureDefinition.getCatalog());
                preparedStatement.setString(2, procedureDefinition.getProcedureName());
                resultSet = preparedStatement.executeQuery();
                String string3 = "PROCEDURE";
                String string4 = "";
                if (resultSet.next()) {
                    string3 = resultSet.getString(1);
                    string4 = resultSet.getString(2);
                }
                stringBuilder.append("DROP ");
                stringBuilder.append(string3);
                stringBuilder.append(' ');
                stringBuilder.append(procedureDefinition.getProcedureName());
                DelimiterDefinition delimiterDefinition = Settings.getInstance().getAlternateDelimiter(this.connection, DelimiterDefinition.STANDARD_DELIMITER);
                if (delimiterDefinition != null) {
                    if (delimiterDefinition.isSingleLine()) {
                        stringBuilder.append(string2);
                    }
                    stringBuilder.append(delimiterDefinition.toString());
                }
                stringBuilder.append(string2);
                stringBuilder.append(string2);
                stringBuilder.append("CREATE ");
                stringBuilder.append(string3);
                stringBuilder.append(' ');
                stringBuilder.append(procedureDefinition.getProcedureName());
                stringBuilder.append(" (");
                DataStore dataStore = this.getProcedureColumns(procedureDefinition);
                int n = dataStore.getRowCount();
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    String string5 = dataStore.getValueAsString(i, 1);
                    if (string5.equals("RETURN") || string5.equals("RESULTSET")) continue;
                    String string6 = dataStore.getValueAsString(i, 2);
                    String string7 = dataStore.getValueAsString(i, 0);
                    if (n2 > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(string5);
                    stringBuilder.append(' ');
                    stringBuilder.append(string7);
                    stringBuilder.append(' ');
                    stringBuilder.append(string6);
                    ++n2;
                }
                stringBuilder.append(')');
                stringBuilder.append(string2);
                if (!"FUNCTION".equals(string3)) break block9;
                stringBuilder.append("RETURNS ");
                stringBuilder.append(string4);
                stringBuilder.append(string2);
            }
            catch (Exception exception) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, exception, "procedure header", string, procedureDefinition.getCatalog(), procedureDefinition.getProcedureName());
                    stringBuilder = StringUtil.emptyBuilder();
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return stringBuilder;
    }
}

