/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.nuodb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import workbench.db.ColumnDefinitionEnhancer;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class NuoDbColumnEnhancer
implements ColumnDefinitionEnhancer {
    @Override
    public void updateColumnDefinition(TableDefinition tableDefinition, WbConnection wbConnection) {
        this.readIdentityColumns(tableDefinition, wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIdentityColumns(TableDefinition tableDefinition, WbConnection wbConnection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        TableIdentifier tableIdentifier = tableDefinition.getTable();
        String string = "select field \nfrom system.fields \n where tablename = ? \nand schema = ? \nand generator_sequence is not null ";
        LogMgr.logMetadataSql(new CallerInfo(){}, "identity columns", string, new Object[0]);
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getRawTableName());
            preparedStatement.setString(2, tableIdentifier.getRawSchema());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                ColumnIdentifier columnIdentifier = tableDefinition.findColumn(string2);
                if (columnIdentifier == null) continue;
                columnIdentifier.setIsAutoincrement(true);
                columnIdentifier.setComputedColumnExpression("GENERATED ALWAYS AS IDENTITY");
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        catch (Exception exception) {
            LogMgr.logMetadataError(new CallerInfo(){}, exception, "identity columns", string, new Object[0]);
        }
        finally {
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
    }
}

