/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.objectcache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbStringTokenizer;

public class Namespace
implements Serializable {
    public static final Namespace NULL_NSP = new Namespace(null, null);
    private String schema;
    private String catalog;
    private String expression;

    public Namespace(String string, String string2) {
        this.schema = StringUtil.trimToNull(string);
        this.catalog = StringUtil.trimToNull(string2);
        this.expression = this.buildExpression();
    }

    public Namespace(String string) {
        this.init(string, '.', true, true);
    }

    public Namespace(String string, char c, boolean bl, boolean bl2) {
        this.init(string, c, bl, bl2);
    }

    private void init(String string, char c, boolean bl, boolean bl2) {
        if ((string = StringUtil.trimToNull(StringUtil.removeTrailing(string, c))) == null) {
            this.schema = null;
            this.catalog = null;
            this.expression = "";
        } else {
            WbStringTokenizer wbStringTokenizer = new WbStringTokenizer(c, "\"", true);
            wbStringTokenizer.setSourceString(string);
            List<String> list = wbStringTokenizer.getAllTokens();
            if (list.size() >= 2) {
                if (bl && bl2) {
                    this.catalog = list.get(0).trim();
                    this.schema = list.get(1).trim();
                } else if (bl && !bl2) {
                    this.schema = list.get(0).trim();
                    this.catalog = null;
                } else if (!bl && bl2) {
                    this.catalog = list.get(0).trim();
                    this.schema = null;
                }
            } else if (bl) {
                this.catalog = null;
                this.schema = string;
            } else {
                this.catalog = string;
                this.schema = null;
            }
            this.expression = this.buildExpression();
        }
    }

    public void adjustCase(WbConnection wbConnection) {
        if (wbConnection == null) {
            return;
        }
        this.schema = wbConnection.getMetadata().adjustSchemaNameCase(this.schema);
        this.catalog = wbConnection.getMetadata().adjustSchemaNameCase(this.catalog);
        this.expression = this.buildExpression();
    }

    public void setNamespace(TableIdentifier tableIdentifier) {
        if (tableIdentifier.getSchema() == null) {
            tableIdentifier.setSchema(this.schema);
        }
        if (tableIdentifier.getCatalog() == null) {
            tableIdentifier.setCatalog(this.catalog);
        }
    }

    public void removeNamespaceIfEqual(TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return;
        }
        if (StringUtil.equalStringIgnoreCase(this.schema, tableIdentifier.getRawSchema())) {
            tableIdentifier.setSchema(null);
        }
        if (StringUtil.equalStringIgnoreCase(this.catalog, tableIdentifier.getRawCatalog())) {
            tableIdentifier.setCatalog(null);
        }
    }

    public boolean isValid() {
        return this.catalog != null || this.schema != null;
    }

    public boolean hasCatalogAndSchema() {
        return this.schema != null && this.catalog != null;
    }

    public static Namespace fromExpression(WbConnection wbConnection, String string) {
        if (wbConnection == null) {
            return new Namespace(string, '.', true, true);
        }
        boolean bl = wbConnection.getDbSettings().supportsSchemas();
        boolean bl2 = wbConnection.getDbSettings().supportsCatalogs();
        char c = SqlUtil.getCatalogSeparator(wbConnection);
        return new Namespace(string, c, bl, bl2);
    }

    public static Namespace fromTable(TableIdentifier tableIdentifier, WbConnection wbConnection) {
        if (tableIdentifier == null) {
            return null;
        }
        if (wbConnection == null) {
            return new Namespace(tableIdentifier.getSchema(), tableIdentifier.getCatalog());
        }
        boolean bl = wbConnection.getDbSettings().supportsSchemas();
        boolean bl2 = wbConnection.getDbSettings().supportsCatalogs();
        if (bl && !bl2) {
            return new Namespace(tableIdentifier.getSchema(), null);
        }
        if (!bl && bl2) {
            return new Namespace(null, tableIdentifier.getCatalog());
        }
        return new Namespace(tableIdentifier.getSchema(), tableIdentifier.getCatalog());
    }

    public String getSchema() {
        return this.schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String toString() {
        return this.expression;
    }

    public String buildExpression() {
        if (this.catalog == null && this.schema == null) {
            return "";
        }
        if (this.catalog == null && this.schema != null) {
            return this.schema;
        }
        if (this.catalog != null && this.schema == null) {
            return this.catalog;
        }
        return this.catalog + "." + this.schema;
    }

    public int hashCode() {
        int n = 5;
        n = 19 * n + Objects.hashCode(this.schema);
        n = 19 * n + Objects.hashCode(this.catalog);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Namespace namespace = (Namespace)object;
        if (!SqlUtil.objectNamesAreEqual(this.schema, namespace.schema)) {
            return false;
        }
        return SqlUtil.objectNamesAreEqual(this.catalog, namespace.catalog);
    }

    public static List<Namespace> convertCatalogList(Collection<String> collection) {
        return Namespace.convertCatalogList(collection, null);
    }

    public static List<Namespace> convertCatalogList(Collection<String> collection, WbConnection wbConnection) {
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
        if (collection == null) {
            return arrayList;
        }
        for (String string : collection) {
            if (wbConnection != null) {
                string = wbConnection.getMetadata().adjustSchemaNameCase(string);
            }
            arrayList.add(new Namespace(null, string));
        }
        return arrayList;
    }

    public static List<Namespace> convertSchemaList(Collection<String> collection) {
        return Namespace.convertSchemaList(collection, null);
    }

    public static List<Namespace> convertSchemaList(Collection<String> collection, WbConnection wbConnection) {
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
        if (collection == null) {
            return arrayList;
        }
        for (String string : collection) {
            if (wbConnection != null) {
                string = wbConnection.getMetadata().adjustSchemaNameCase(string);
            }
            arrayList.add(new Namespace(string, null));
        }
        return arrayList;
    }
}

