/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.objectcache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DbObjectFinder;
import workbench.db.DbSearchPath;
import workbench.db.DbSwitcher;
import workbench.db.DependencyNode;
import workbench.db.IndexDefinition;
import workbench.db.IndexReader;
import workbench.db.ObjectNameFilter;
import workbench.db.ObjectNameSorter;
import workbench.db.PkDefinition;
import workbench.db.ProcedureDefinition;
import workbench.db.ReaderFactory;
import workbench.db.TableDefinition;
import workbench.db.TableDependency;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.objectcache.Namespace;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

class ObjectCache {
    private boolean retrieveOraclePublicSynonyms;
    public static final Namespace DUMMY_NSP_KEY = new Namespace("-$$wb-null-schema$$-", "-$$wb-null-catalog$$-");
    private final Set<Namespace> schemasInCache = new HashSet<Namespace>();
    private final Map<TableIdentifier, List<DependencyNode>> referencedTables = new HashMap<TableIdentifier, List<DependencyNode>>();
    private final Map<TableIdentifier, List<DependencyNode>> referencingTables = new HashMap<TableIdentifier, List<DependencyNode>>();
    private final Map<TableIdentifier, List<ColumnIdentifier>> objects = new HashMap<TableIdentifier, List<ColumnIdentifier>>();
    private final Map<TableIdentifier, TableIdentifier> synonymMap = new HashMap<TableIdentifier, TableIdentifier>();
    private final Map<TableIdentifier, List<IndexDefinition>> indexMap = new HashMap<TableIdentifier, List<IndexDefinition>>();
    private final Map<TableIdentifier, PkDefinition> pkMap = new HashMap<TableIdentifier, PkDefinition>();
    private final Map<String, List<ProcedureDefinition>> procedureCache = new HashMap<String, List<ProcedureDefinition>>();
    private ObjectNameFilter schemaFilter;
    private ObjectNameFilter catalogFilter;
    private boolean supportsSchemas;
    private boolean supportsCatalogs;
    private boolean databasesCached;
    private final List<String> availableDatabases = new ArrayList<String>();
    private final DbObjectFinder finder;
    private final TableIdentifier dummyTable = new TableIdentifier("-$WB DUMMY$-", "-$WB DUMMY$-");

    ObjectCache(WbConnection wbConnection) {
        this.retrieveOraclePublicSynonyms = wbConnection.getMetadata().isOracle() && Settings.getInstance().getBoolProperty("workbench.editor.autocompletion.oracle.public_synonyms", false);
        this.schemaFilter = wbConnection.getProfile().getSchemaFilter();
        this.catalogFilter = wbConnection.getProfile().getCatalogFilter();
        this.supportsSchemas = wbConnection.getDbSettings().supportsSchemas();
        this.supportsCatalogs = wbConnection.getDbSettings().supportsCatalogs();
        this.finder = new DbObjectFinder(wbConnection);
    }

    private String[] getCompletionTypes(WbConnection wbConnection) {
        String string = wbConnection.getDbId();
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(CollectionUtil.caseInsensitiveSet(wbConnection.getMetadata().getSelectableTypes()));
        set.addAll(Settings.getInstance().getListProperty("workbench.db." + string + ".completion.types.additional", true, null));
        List<String> list = Settings.getInstance().getListProperty("workbench.db." + string + ".completion.types.exclude", true, null);
        set.removeAll(list);
        return StringUtil.toArray(set, true);
    }

    private boolean isFiltered(TableIdentifier tableIdentifier) {
        boolean bl = false;
        if (Settings.getInstance().getUseProfileFilterForCompletion()) {
            if (this.schemaFilter != null) {
                bl = this.schemaFilter.isExcluded(tableIdentifier.getSchema());
            }
            if (bl) {
                return true;
            }
            if (this.catalogFilter != null) {
                bl = this.catalogFilter.isExcluded(tableIdentifier.getCatalog());
            }
        }
        return bl;
    }

    private void setTables(List<TableIdentifier> list, WbConnection wbConnection) {
        for (TableIdentifier tableIdentifier : list) {
            if (this.isFiltered(tableIdentifier) || this.objects.containsKey(tableIdentifier)) continue;
            this.objects.put(tableIdentifier, null);
            Namespace namespace = Namespace.fromTable(tableIdentifier, wbConnection);
            this.schemasInCache.add(namespace);
        }
    }

    private String getSchemaToUse(WbConnection wbConnection, String string) {
        DbMetadata dbMetadata = wbConnection.getMetadata();
        return dbMetadata.adjustSchemaNameCase(string);
    }

    List<Namespace> getSearchPath(WbConnection wbConnection, Namespace namespace) {
        if (namespace != null && namespace.hasCatalogAndSchema() && this.supportsCatalogs && this.supportsSchemas) {
            return Collections.singletonList(namespace);
        }
        if (!wbConnection.getDbSettings().useCurrentNamespaceForCompletion()) {
            if (this.supportsSchemas) {
                return CollectionUtil.arrayList(new Namespace[]{null});
            }
            List<String> list = wbConnection.getMetadata().getCatalogs();
            return list.stream().map(string -> new Namespace(null, (String)string)).collect(Collectors.toList());
        }
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
        ArrayList<Namespace> arrayList2 = new ArrayList<Namespace>();
        String string3 = namespace == null ? null : namespace.getSchema();
        String string4 = namespace == null ? null : namespace.getCatalog();
        Namespace namespace2 = this.createNamespace(string3, string4);
        if (this.supportsSchemas && !this.supportsCatalogs) {
            List<String> list = DbSearchPath.Factory.getSearchPathHandler(wbConnection).getSearchPath(wbConnection, string3);
            arrayList.addAll(Namespace.convertSchemaList(list, null));
            arrayList2.addAll(Namespace.convertSchemaList(wbConnection.getDbSettings().getIgnoreCompletionSchemas()));
        } else if (this.supportsCatalogs && !this.supportsSchemas) {
            if (namespace2.isValid()) {
                arrayList.add(namespace2);
            } else {
                String string5 = wbConnection.getMetadata().getCurrentCatalog();
                arrayList.add(new Namespace(null, string5));
                List<String> list = wbConnection.getMetadata().getCatalogs();
                arrayList.addAll(list.stream().filter(string2 -> StringUtil.stringsAreNotEqual(string2, string5)).map(string -> new Namespace(null, (String)string)).collect(Collectors.toList()));
            }
            arrayList2.addAll(Namespace.convertCatalogList(wbConnection.getDbSettings().getIgnoreCompletionCatalogs()));
        } else if (this.supportsCatalogs && this.supportsSchemas) {
            String string6 = wbConnection.getMetadata().getCurrentCatalog();
            String string7 = wbConnection.getMetadata().getCurrentSchema();
            if (string3 == null && string4 == null) {
                arrayList.add(new Namespace(string7, string6));
            } else {
                arrayList.add(new Namespace(StringUtil.coalesce(string3, string7), StringUtil.coalesce(string4, string6)));
            }
            arrayList2.addAll(Namespace.convertCatalogList(wbConnection.getDbSettings().getIgnoreCompletionCatalogs()));
        }
        if (namespace2 != null) {
            arrayList2.remove(namespace2);
        }
        arrayList.removeAll(arrayList2);
        if (arrayList.isEmpty()) {
            return CollectionUtil.arrayList(Namespace.NULL_NSP);
        }
        return arrayList;
    }

    private Namespace createNamespace(String string, String string2) {
        if (this.supportsSchemas && !this.supportsCatalogs) {
            return new Namespace(string, null);
        }
        if (this.supportsCatalogs && !this.supportsSchemas) {
            return new Namespace(string, string2);
        }
        return new Namespace(string, string2);
    }

    synchronized Set<TableIdentifier> getTables(WbConnection wbConnection, Namespace namespace, Collection<String> collection) {
        if (wbConnection.isBusy()) {
            return Collections.emptySet();
        }
        List<Namespace> list = this.getSearchPath(wbConnection, namespace);
        LogMgr.logDebug(new CallerInfo(){}, "Getting tables using schema: " + namespace + ", filter: " + collection + ", search path: " + list);
        DbMetadata dbMetadata = wbConnection.getMetadata();
        for (Namespace namespace2 : list) {
            if (!this.objects.isEmpty() && this.schemasInCache.contains(namespace2)) continue;
            try {
                List<TableIdentifier> list2 = dbMetadata.getObjectList(null, namespace2, this.getCompletionTypes(wbConnection));
                for (TableIdentifier tableIdentifier : list2) {
                    tableIdentifier.checkQuotesNeeded(wbConnection);
                }
                this.setTables(list2, wbConnection);
                LogMgr.logDebug(new CallerInfo(){}, "Namespace \"" + namespace2 + "\" not found in cache. Retrieved " + list2.size() + " objects");
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not retrieve table list for namespace: " + namespace2, exception);
            }
        }
        if (collection != null) {
            return this.filterTablesByType(wbConnection, list, collection);
        }
        return this.filterTablesBySchema(wbConnection, list);
    }

    public List<DependencyNode> getReferencingTables(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return Collections.emptyList();
        }
        TableIdentifier tableIdentifier2 = this.finder.findTable(tableIdentifier, false);
        List<DependencyNode> list = this.referencingTables.get(tableIdentifier2);
        if (list == null && wbConnection.isBusy()) {
            return Collections.emptyList();
        }
        if (list == null) {
            TableDependency tableDependency = new TableDependency(wbConnection, tableIdentifier2);
            tableDependency.setRetrieveDirectChildrenOnly(true);
            tableDependency.readTreeForChildren();
            list = tableDependency.getLeafs();
            this.referencingTables.put(tableIdentifier, list);
        }
        return list;
    }

    public List<DependencyNode> getReferencedTables(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        if (tableIdentifier == null || wbConnection.isBusy()) {
            return Collections.emptyList();
        }
        TableIdentifier tableIdentifier2 = this.finder.findTable(tableIdentifier, false);
        List<DependencyNode> list = this.referencedTables.get(tableIdentifier2);
        if (list == null) {
            TableDependency tableDependency = new TableDependency(wbConnection, tableIdentifier2);
            tableDependency.setRetrieveDirectChildrenOnly(true);
            tableDependency.readTreeForParents();
            list = tableDependency.getLeafs();
            this.referencedTables.put(tableIdentifier, list);
        }
        return list;
    }

    public void addReferencedTables(TableIdentifier tableIdentifier, List<DependencyNode> list) {
        if (tableIdentifier == null) {
            return;
        }
        List<DependencyNode> list2 = this.referencedTables.put(tableIdentifier, list);
        if (list2 == null) {
            LogMgr.logDebug(new CallerInfo(){}, "Added referenced tables for " + tableIdentifier + "(" + list + ")");
        } else {
            LogMgr.logDebug(new CallerInfo(){}, "Replaced existing referenced tables for " + tableIdentifier);
        }
    }

    public void addReferencingTables(TableIdentifier tableIdentifier, List<DependencyNode> list) {
        if (tableIdentifier == null) {
            return;
        }
        List<DependencyNode> list2 = this.referencingTables.put(tableIdentifier, list);
        if (list2 == null) {
            LogMgr.logDebug(new CallerInfo(){}, "Added referencing tables for " + tableIdentifier + "(" + list + ")");
        } else {
            LogMgr.logDebug(new CallerInfo(){}, "Replaced existing referencing tables for " + tableIdentifier);
        }
    }

    Map<String, List<ProcedureDefinition>> getProcedures() {
        if (this.procedureCache == null) {
            return new HashMap<String, List<ProcedureDefinition>>(0);
        }
        return this.procedureCache;
    }

    public List<ProcedureDefinition> getProcedures(WbConnection wbConnection, String string) {
        String string2 = this.getSchemaToUse(wbConnection, string);
        List<ProcedureDefinition> list = this.procedureCache.get(string2);
        if (list == null) {
            if (wbConnection.isBusy()) {
                return Collections.emptyList();
            }
            try {
                list = wbConnection.getMetadata().getProcedureReader().getProcedureList(null, string2, "%");
                if (wbConnection.getDbSettings().getRetrieveProcParmsForAutoCompletion()) {
                    for (ProcedureDefinition procedureDefinition : list) {
                        procedureDefinition.readParameters(wbConnection);
                    }
                }
                this.procedureCache.put(string2, list);
            }
            catch (SQLException sQLException) {
                LogMgr.logError(new CallerInfo(){}, "Error retrieving procedures", sQLException);
            }
        }
        return list;
    }

    private Set<TableIdentifier> filterTablesByType(WbConnection wbConnection, List<Namespace> list, Collection<String> collection) {
        TreeSet<DbObject> treeSet = new TreeSet<DbObject>(new ObjectNameSorter());
        String string = null;
        if (list.size() == 1) {
            string = list.get(0).getSchema();
        }
        boolean bl = wbConnection.getDbSettings().alwaysUseSchemaForCompletion() || list.size() > 1;
        String string2 = wbConnection.getMetadata().getCurrentCatalog();
        for (TableIdentifier tableIdentifier : this.objects.keySet()) {
            String string3 = tableIdentifier.getType();
            Namespace namespace = Namespace.fromTable(tableIdentifier, wbConnection);
            if (!collection.contains(string3) || !list.contains(namespace)) continue;
            TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
            this.adjustSchemaAndCatalog(wbConnection, tableIdentifier2, string, string2, bl);
            treeSet.add(tableIdentifier2);
        }
        return treeSet;
    }

    private void adjustSchemaAndCatalog(WbConnection wbConnection, TableIdentifier tableIdentifier, String string, String string2, boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4;
        if (!wbConnection.getDbSettings().useCurrentNamespaceForCompletion()) {
            return;
        }
        DbMetadata dbMetadata = wbConnection.getMetadata();
        String string3 = tableIdentifier.getSchema();
        boolean bl5 = bl4 = bl ? false : dbMetadata.ignoreSchema(string3, string);
        if (bl4) {
            tableIdentifier.setSchema(null);
        }
        boolean bl6 = bl3 = (bl2 = wbConnection.getDbSettings().alwaysUseCatalogForCompletion()) ? false : dbMetadata.ignoreCatalog(tableIdentifier.getCatalog(), string2);
        if (bl3) {
            tableIdentifier.setCatalog(null);
        }
    }

    private Set<TableIdentifier> filterTablesBySchema(WbConnection wbConnection, List<Namespace> list) {
        TreeSet<DbObject> treeSet = new TreeSet<DbObject>(new ObjectNameSorter(true));
        DbMetadata dbMetadata = wbConnection.getMetadata();
        List list2 = list.stream().filter(namespace -> namespace != null).collect(Collectors.toList());
        boolean bl = wbConnection.getDbSettings().alwaysUseSchemaForCompletion() || list2.size() > 1;
        String string = null;
        if (list2.size() == 1) {
            string = this.supportsSchemas ? dbMetadata.getCurrentSchema() : dbMetadata.getCurrentCatalog();
        }
        String string2 = dbMetadata.getCurrentCatalog();
        for (TableIdentifier tableIdentifier : this.objects.keySet()) {
            Namespace namespace2 = Namespace.fromTable(tableIdentifier, wbConnection);
            if (!list2.contains(namespace2) && !list2.isEmpty()) continue;
            TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
            this.adjustSchemaAndCatalog(wbConnection, tableIdentifier2, string, string2, bl);
            treeSet.add(tableIdentifier2);
        }
        return treeSet;
    }

    public synchronized void addSynonym(TableIdentifier tableIdentifier, TableIdentifier tableIdentifier2) {
        this.synonymMap.put(tableIdentifier, tableIdentifier2);
    }

    public synchronized TableIdentifier getSynonymTable(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        if (!wbConnection.getMetadata().supportsSynonyms()) {
            return tableIdentifier;
        }
        TableIdentifier tableIdentifier2 = this.findInCache(tableIdentifier, this.synonymMap.keySet());
        TableIdentifier tableIdentifier3 = null;
        if (tableIdentifier2 != null) {
            tableIdentifier3 = this.synonymMap.get(tableIdentifier2);
        }
        if (tableIdentifier3 != null && tableIdentifier3.equals(this.dummyTable)) {
            return tableIdentifier;
        }
        if (tableIdentifier3 != null) {
            return tableIdentifier3;
        }
        if (tableIdentifier3 == null) {
            tableIdentifier3 = wbConnection.getMetadata().resolveSynonym(tableIdentifier);
        }
        TableIdentifier tableIdentifier4 = tableIdentifier.createCopy();
        tableIdentifier4.adjustCase(wbConnection);
        if (tableIdentifier3 == null || tableIdentifier3 == tableIdentifier) {
            this.synonymMap.put(tableIdentifier4, this.dummyTable);
        } else {
            this.synonymMap.put(tableIdentifier4, tableIdentifier3);
        }
        return tableIdentifier3 == null ? tableIdentifier : tableIdentifier3;
    }

    public synchronized List<ColumnIdentifier> getColumns(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        long l = System.currentTimeMillis();
        TableIdentifier tableIdentifier2 = this.findEntry(wbConnection, tableIdentifier);
        List<ColumnIdentifier> list = null;
        if (tableIdentifier2 != null) {
            list = this.objects.get(tableIdentifier2);
        } else if (!wbConnection.isBusy()) {
            tableIdentifier2 = this.finder.searchSelectableObjectOnPath(tableIdentifier);
            if (tableIdentifier2 == null) {
                return null;
            }
            tableIdentifier2.checkQuotesNeeded(wbConnection);
        }
        if (list == null && wbConnection.isBusy()) {
            LogMgr.logDebug(new CallerInfo(){}, "No columns found for table " + tableIdentifier.getTableExpression() + ", but connection " + wbConnection.getId() + " is busy.");
            return Collections.emptyList();
        }
        if (this.retrieveOraclePublicSynonyms && tableIdentifier2.getSchema() != null && list == null) {
            tableIdentifier2.setSchema(null);
            tableIdentifier2.setType(null);
            list = this.objects.get(tableIdentifier2);
            if (list == null) {
                this.getTables(wbConnection, new Namespace("PUBLIC", null), null);
                list = this.objects.get(tableIdentifier2);
            }
        }
        if (CollectionUtil.isEmpty(list)) {
            try {
                LogMgr.logDebug(new CallerInfo(){}, "Table not in cache, retrieving columns for " + tableIdentifier2.getTableExpression());
                list = wbConnection.getMetadata().getTableColumns(tableIdentifier2);
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Error retrieving columns for " + tableIdentifier2, throwable);
                list = null;
            }
            if (tableIdentifier2 != null && CollectionUtil.isNonEmpty(list)) {
                LogMgr.logDebug(new CallerInfo(){}, "Adding columns for " + tableIdentifier2.getTableExpression() + " to cache");
                this.objects.put(tableIdentifier2, list);
            }
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Checking columns for: " + tableIdentifier.getTableExpression(wbConnection) + " took " + l2 + "ms");
        return Collections.unmodifiableList(list);
    }

    synchronized void removeProcedure(WbConnection wbConnection, ProcedureDefinition procedureDefinition) {
        if (procedureDefinition == null) {
            return;
        }
        String string = procedureDefinition.getSchema();
        String string2 = procedureDefinition.getObjectNameForDrop(wbConnection);
        List<ProcedureDefinition> list = this.getProcedures(wbConnection, string);
        Iterator<ProcedureDefinition> iterator = list.iterator();
        while (iterator.hasNext()) {
            ProcedureDefinition procedureDefinition2 = iterator.next();
            String string3 = procedureDefinition2.getObjectNameForDrop(wbConnection);
            if (!string3.equals(string2)) continue;
            LogMgr.logDebug(new CallerInfo(){}, "Procedure " + string2 + " removed from the cache");
            iterator.remove();
            break;
        }
    }

    synchronized void removeTable(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return;
        }
        TableIdentifier tableIdentifier2 = this.findEntry(wbConnection, tableIdentifier);
        if (tableIdentifier2 == null) {
            return;
        }
        this.objects.remove(tableIdentifier2);
        LogMgr.logDebug(new CallerInfo(){}, "Removed " + tableIdentifier.getTableName() + " from the cache");
    }

    synchronized void addTableList(WbConnection wbConnection, DataStore dataStore, String string) {
        Set<String> set = wbConnection.getMetadata().getObjectsWithData();
        int n = 0;
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string2 = dataStore.getValueAsString(i, 1);
            if (!set.contains(string2)) continue;
            TableIdentifier tableIdentifier = this.createIdentifier(dataStore, i);
            if (this.objects.get(tableIdentifier) == null) {
                this.objects.put(tableIdentifier, null);
                ++n;
            }
            this.schemasInCache.add(Namespace.fromTable(tableIdentifier, wbConnection));
        }
        LogMgr.logDebug(new CallerInfo(){}, "Added " + n + " objects");
    }

    synchronized void addProcedureList(DataStore dataStore, String string) {
        if (string == null) {
            return;
        }
        int n = dataStore.getRowCount();
        ArrayList<ProcedureDefinition> arrayList = new ArrayList<ProcedureDefinition>();
        for (int i = 0; i < n; ++i) {
            Object object = dataStore.getRow(i).getUserObject();
            if (!(object instanceof ProcedureDefinition)) continue;
            ProcedureDefinition procedureDefinition = (ProcedureDefinition)object;
            arrayList.add(procedureDefinition);
        }
        this.procedureCache.put(string, arrayList);
        LogMgr.logDebug(new CallerInfo(){}, "Added " + arrayList.size() + " procedures");
    }

    private TableIdentifier createIdentifier(DataStore dataStore, int n) {
        String string = dataStore.getValueAsString(n, 0);
        String string2 = dataStore.getValueAsString(n, 3);
        String string3 = dataStore.getValueAsString(n, 2);
        String string4 = dataStore.getValueAsString(n, 1);
        String string5 = dataStore.getValueAsString(n, 4);
        TableIdentifier tableIdentifier = new TableIdentifier(string3, string2, string);
        tableIdentifier.setType(string4);
        tableIdentifier.setNeverAdjustCase(true);
        tableIdentifier.setComment(string5);
        return tableIdentifier;
    }

    public synchronized void addTable(TableIdentifier tableIdentifier, WbConnection wbConnection) {
        if (tableIdentifier == null) {
            return;
        }
        if (this.findInCache(tableIdentifier) == null) {
            this.objects.put(tableIdentifier, null);
        }
    }

    public synchronized void addTable(TableDefinition tableDefinition, WbConnection wbConnection) {
        if (tableDefinition == null) {
            return;
        }
        this.objects.put(tableDefinition.getTable(), tableDefinition.getColumns());
    }

    synchronized TableIdentifier findEntry(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        String string;
        if (tableIdentifier == null) {
            return null;
        }
        String string2 = string = this.supportsSchemas ? tableIdentifier.getSchema() : tableIdentifier.getCatalog();
        if (string == null) {
            TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
            tableIdentifier2.adjustCase(wbConnection);
            String string3 = wbConnection.getCurrentSchema();
            List<Namespace> list = this.getSearchPath(wbConnection, new Namespace(string3, null));
            for (Namespace namespace : list) {
                tableIdentifier2.setCatalog(namespace.getCatalog());
                tableIdentifier2.setSchema(namespace.getSchema());
                TableIdentifier tableIdentifier3 = this.findInCache(tableIdentifier2);
                if (tableIdentifier3 == null) continue;
                return tableIdentifier3;
            }
        }
        return this.findInCache(tableIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PkDefinition getPrimaryKey(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        Map<TableIdentifier, PkDefinition> map = this.pkMap;
        synchronized (map) {
            TableIdentifier tableIdentifier2;
            PkDefinition pkDefinition = this.getPkFromTableCache(wbConnection, tableIdentifier);
            if (pkDefinition == null && (tableIdentifier2 = this.findInCache(tableIdentifier, this.pkMap.keySet())) != null) {
                pkDefinition = this.pkMap.get(tableIdentifier);
            }
            if (pkDefinition == null) {
                pkDefinition = wbConnection.getMetadata().getIndexReader().getPrimaryKey(tableIdentifier);
                this.pkMap.put(tableIdentifier, pkDefinition);
            }
            return pkDefinition;
        }
    }

    private PkDefinition getPkFromTableCache(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        TableIdentifier tableIdentifier2 = this.findEntry(wbConnection, tableIdentifier);
        if (tableIdentifier2 == null) {
            return null;
        }
        List<ColumnIdentifier> list = this.objects.get(tableIdentifier2);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        for (ColumnIdentifier columnIdentifier : list) {
            if (!columnIdentifier.isPkColumn()) continue;
            arrayList.add(columnIdentifier.getColumnName());
        }
        return new PkDefinition(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<IndexDefinition> getUniqueIndexes(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        Map<TableIdentifier, List<IndexDefinition>> map = this.indexMap;
        synchronized (map) {
            TableIdentifier tableIdentifier2 = this.findInCache(tableIdentifier, this.indexMap.keySet());
            List<IndexDefinition> list = null;
            if (tableIdentifier2 != null) {
                list = this.indexMap.get(tableIdentifier2);
            }
            if (list == null) {
                IndexReader indexReader = ReaderFactory.getIndexReader(wbConnection.getMetadata());
                list = indexReader.getUniqueIndexes(tableIdentifier);
                if (list == null) {
                    list = new ArrayList<IndexDefinition>(0);
                }
                this.indexMap.put(tableIdentifier, list);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushCachedDatabase() {
        ObjectCache objectCache = this;
        synchronized (objectCache) {
            this.databasesCached = false;
            this.availableDatabases.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getAvailableDatabases(WbConnection wbConnection) {
        ObjectCache objectCache = this;
        synchronized (objectCache) {
            DbSwitcher dbSwitcher;
            if (this.databasesCached) {
                return new ArrayList<String>(this.availableDatabases);
            }
            if (wbConnection.isBusy()) {
                LogMgr.logWarning(new CallerInfo(){}, "Connection is marked as busy!", new Exception("Backtrace"));
            }
            if ((dbSwitcher = DbSwitcher.Factory.createDatabaseSwitcher(wbConnection)) == null) {
                return null;
            }
            this.availableDatabases.clear();
            try {
                List<String> list = dbSwitcher.getAvailableDatabases(wbConnection);
                if (list != null) {
                    this.availableDatabases.addAll(list);
                }
                this.databasesCached = true;
            }
            catch (Exception exception) {
                LogMgr.logWarning(new CallerInfo(){}, "Could not retrieve available databases", exception);
                this.databasesCached = false;
            }
            return new ArrayList<String>(this.availableDatabases);
        }
    }

    private TableIdentifier findInCache(TableIdentifier tableIdentifier) {
        return this.findInCache(tableIdentifier, this.objects.keySet());
    }

    private TableIdentifier findInCache(TableIdentifier tableIdentifier, Set<TableIdentifier> set) {
        if (tableIdentifier == null) {
            return null;
        }
        for (TableIdentifier tableIdentifier2 : set) {
            if (!tableIdentifier.compareNames(tableIdentifier2)) continue;
            return tableIdentifier2;
        }
        return null;
    }

    public void clear() {
        this.objects.clear();
        this.schemasInCache.clear();
        this.referencedTables.clear();
        this.referencingTables.clear();
        this.procedureCache.clear();
        this.synonymMap.clear();
        this.availableDatabases.clear();
        this.databasesCached = false;
        LogMgr.logDebug(new CallerInfo(){}, "Removed all entries from the cache");
    }

    Collection<String> getSchemasInCache() {
        return this.schemasInCache.stream().map(namespace -> namespace.toString()).collect(Collectors.toList());
    }

    Collection<Namespace> getNamespacesInCache() {
        return Collections.unmodifiableSet(this.schemasInCache);
    }

    Map<TableIdentifier, List<DependencyNode>> getReferencedTables() {
        return Collections.unmodifiableMap(this.referencedTables);
    }

    Map<TableIdentifier, List<DependencyNode>> getReferencingTables() {
        return Collections.unmodifiableMap(this.referencingTables);
    }

    Map<TableIdentifier, List<ColumnIdentifier>> getObjects() {
        return Collections.unmodifiableMap(this.objects);
    }

    public Map<TableIdentifier, TableIdentifier> getSynonyms() {
        return Collections.unmodifiableMap(this.synonymMap);
    }

    public Map<TableIdentifier, PkDefinition> getPKMap() {
        return Collections.unmodifiableMap(this.pkMap);
    }

    public Map<TableIdentifier, List<IndexDefinition>> getIndexes() {
        return Collections.unmodifiableMap(this.indexMap);
    }

    void initExternally(Map<TableIdentifier, List<ColumnIdentifier>> map, Collection<Namespace> collection, Map<TableIdentifier, List<DependencyNode>> map2, Map<TableIdentifier, List<DependencyNode>> map3, Map<String, List<ProcedureDefinition>> map4, Map<TableIdentifier, TableIdentifier> map5, Map<TableIdentifier, List<IndexDefinition>> map6, Map<TableIdentifier, PkDefinition> map7) {
        if (map == null || collection == null) {
            return;
        }
        this.clear();
        this.objects.putAll(map);
        this.schemasInCache.addAll(collection);
        int n = 0;
        if (map2 != null) {
            this.referencedTables.putAll(map2);
            n += map2.size();
        }
        if (map3 != null) {
            this.referencingTables.putAll(map3);
            n += map3.size();
        }
        if (map4 != null) {
            this.procedureCache.putAll(map4);
        }
        if (map5 != null) {
            this.synonymMap.putAll(map5);
        }
        if (map6 != null) {
            this.indexMap.putAll(map6);
        }
        if (map7 != null) {
            this.pkMap.putAll(map7);
        }
        LogMgr.logDebug(new CallerInfo(){}, "Added " + this.objects.size() + " objects, " + this.procedureCache.values().size() + " procedures, " + this.synonymMap.size() + " synonyms and " + n + " foreign key definitions from local storage");
    }
}

