/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import workbench.db.DbObject;
import workbench.db.DbObjectComparator;
import workbench.db.JdbcUtils;
import workbench.db.PackageDefinition;
import workbench.db.ProcedureDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TriggerDefinition;
import workbench.db.WbConnection;
import workbench.db.dependency.DependencyReader;
import workbench.db.oracle.OracleObjectType;
import workbench.gui.dbobjects.objecttree.DbObjectSorter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;

public class OracleDependencyReader
implements DependencyReader {
    private final String searchUsedBySql = "select owner, name, type  \nfrom all_dependencies \nwhere referenced_owner = ? \n  and referenced_name = ? \n  and referenced_type = ? \n  and owner not in ('SYS', 'SYSTEM', 'PUBLIC')";
    private final String searchUsedSql = "select referenced_owner, referenced_name, referenced_type \nfrom all_dependencies \nwhere owner = ? \n  and name = ? \n  and type = ? \n  and referenced_owner not in ('SYS', 'SYSTEM', 'PUBLIC')";
    private final Set<String> types = CollectionUtil.caseInsensitiveSet("TABLE", "VIEW", "MATERIALIZED VIEW", "PROCEDURE", "TYPE", "FUNCTION", "TRIGGER", "PACKAGE");

    @Override
    public List<DbObject> getUsedObjects(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null || wbConnection == null) {
            return Collections.emptyList();
        }
        List<DbObject> list = this.retrieveObjects(wbConnection, dbObject, "select referenced_owner, referenced_name, referenced_type \nfrom all_dependencies \nwhere owner = ? \n  and name = ? \n  and type = ? \n  and referenced_owner not in ('SYS', 'SYSTEM', 'PUBLIC')");
        DbObjectSorter.sort(list, true, true);
        if (dbObject.getObjectType().equals("MATERIALIZED VIEW")) {
            list.removeIf(dbObject2 -> DbObjectComparator.namesAreEqual(dbObject, dbObject2, false));
        }
        return list;
    }

    @Override
    public List<DbObject> getUsedBy(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null || wbConnection == null) {
            return Collections.emptyList();
        }
        List<DbObject> list = this.retrieveObjects(wbConnection, dbObject, "select owner, name, type  \nfrom all_dependencies \nwhere referenced_owner = ? \n  and referenced_name = ? \n  and referenced_type = ? \n  and owner not in ('SYS', 'SYSTEM', 'PUBLIC')");
        DbObjectSorter.sort(list, true, true);
        return list;
    }

    private List<DbObject> removeBodies(List<DbObject> list) {
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>(list.size());
        for (DbObject dbObject : list) {
            if (dbObject.getObjectType().endsWith("BODY") && this.containsDeclaration(list, dbObject)) continue;
            arrayList.add(dbObject);
        }
        return arrayList;
    }

    private boolean containsDeclaration(List<DbObject> list, DbObject dbObject) {
        String string = dbObject.getObjectType().replace("BODY", "").trim();
        for (DbObject dbObject2 : list) {
            if (!dbObject2.getObjectType().equals(string) || !dbObject2.getObjectName().equals(dbObject.getObjectName()) || !dbObject2.getSchema().equals(dbObject.getSchema())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsUsedByDependency(String string) {
        return this.types.contains(string);
    }

    @Override
    public boolean supportsIsUsingDependency(String string) {
        if ("table".equalsIgnoreCase(string)) {
            return false;
        }
        return this.types.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DbObject> retrieveObjects(WbConnection wbConnection, DbObject dbObject, String string) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>();
        LogMgr.logMetadataSql(new CallerInfo(){}, "object dependency", string, dbObject.getSchema(), dbObject.getObjectName(), dbObject.getObjectType());
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, dbObject.getSchema());
            preparedStatement.setString(2, dbObject.getObjectName());
            preparedStatement.setString(3, dbObject.getObjectType());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                DbObject dbObject2 = null;
                if (string4.equals("PROCEDURE")) {
                    dbObject2 = new ProcedureDefinition(null, string2, string3);
                } else if (string4.equals("FUNCTION")) {
                    dbObject2 = new ProcedureDefinition(null, string2, string3, 2);
                } else if (string4.equals("TRIGGER")) {
                    dbObject2 = new TriggerDefinition(null, string2, string3);
                } else if (string4.equals("TYPE BODY") || string4.equals("TYPE")) {
                    dbObject2 = new OracleObjectType(string2, string3);
                } else if (string4.equals("PACKAGE BODY") || string4.equals("PACKAGE")) {
                    dbObject2 = new PackageDefinition(string2, string3);
                } else {
                    TableIdentifier tableIdentifier = new TableIdentifier(null, string2, string3);
                    tableIdentifier.setType(string4);
                    tableIdentifier.setNeverAdjustCase(true);
                    dbObject2 = tableIdentifier;
                }
                if (DbObjectComparator.namesAreEqual(dbObject, dbObject2)) continue;
                arrayList.add(dbObject2);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "object dependency", string, dbObject.getSchema(), dbObject.getObjectName(), dbObject.getObjectType());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return this.removeBodies(arrayList);
    }
}

