/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import workbench.db.DbMetadata;
import workbench.db.IndexColumn;
import workbench.db.IndexDefinition;
import workbench.db.JdbcIndexReader;
import workbench.db.JdbcUtils;
import workbench.db.ObjectSourceOptions;
import workbench.db.PkDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.oracle.DbmsMetadata;
import workbench.db.oracle.OracleIndexPartition;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class OracleIndexReader
extends JdbcIndexReader {
    private static final String PROP_USE_JDBC_FOR_PK_INFO = "workbench.db.oracle.getprimarykeyindex.usejdbc";
    private static final String PROP_USE_JDBC_FOR_INDEXLIST = "workbench.db.oracle.indexlist.usejdbc";
    private static final String IDX_PROP_COMPRESS = "compression_level";
    private PreparedStatement indexStatement;
    private PreparedStatement pkStament;
    private String defaultTablespace;
    private final boolean hasCompression;
    private String currentUser;

    public OracleIndexReader(DbMetadata dbMetadata) {
        super(dbMetadata);
        boolean bl = Settings.getInstance().getBoolProperty(PROP_USE_JDBC_FOR_PK_INFO, false);
        if (!bl) {
            this.pkIndexNameColumn = "PK_INDEX_NAME";
            this.pkStatusColumn = "PK_STATUS";
            this.partitionedFlagColumn = "PARTITIONED";
        }
        if (OracleUtils.checkDefaultTablespace()) {
            this.defaultTablespace = OracleUtils.getDefaultTablespace(dbMetadata.getWbConnection());
        }
        this.hasCompression = JdbcUtils.hasMinimumServerVersion(dbMetadata.getWbConnection(), "9.0");
        this.currentUser = dbMetadata.getWbConnection().getCurrentUser();
    }

    @Override
    public void indexInfoProcessed() {
        JdbcUtils.closeStatement(this.indexStatement);
        this.indexStatement = null;
    }

    @Override
    public ResultSet getIndexInfo(TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        if (Settings.getInstance().getBoolProperty(PROP_USE_JDBC_FOR_INDEXLIST, false)) {
            return super.getIndexInfo(tableIdentifier, bl);
        }
        return this.getIndexInfo(tableIdentifier, null, null, bl);
    }

    @Override
    public boolean supportsIndexStatus() {
        return true;
    }

    @Override
    public boolean supportsTableSpaces() {
        return !Settings.getInstance().getBoolProperty(PROP_USE_JDBC_FOR_INDEXLIST, false);
    }

    private ResultSet getIndexInfo(TableIdentifier tableIdentifier, String string, String string2, boolean bl) throws SQLException {
        String string3;
        if (this.indexStatement != null) {
            LogMgr.logWarning(new CallerInfo(){}, "getIndexInfo() called with pending results!");
            this.indexInfoProcessed();
        }
        if ("VIEW".equals(tableIdentifier.getType())) {
            return null;
        }
        TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
        tableIdentifier2.adjustCase(this.metaData.getWbConnection());
        boolean bl2 = false;
        if (OracleUtils.optimizeCatalogQueries() && (StringUtil.isEmptyString(string3 = tableIdentifier2.getRawSchema()) || string3.equalsIgnoreCase(this.currentUser))) {
            bl2 = true;
        }
        string3 = "-- SQL Workbench \nSELECT " + OracleUtils.getCacheHint() + " null as table_cat, \n       " + (bl2 ? "user" : "i.owner") + " as table_schem, \n       i.table_name, \n       decode (i.uniqueness, 'UNIQUE', 0, 1) as non_unique, \n       null as index_qualifier, \n       i.index_name, \n       i.index_type as type, \n       c.column_position as ordinal_position, \n       c.column_name, \n       decode(c.descend, 'ASC', 'A', 'DESC', 'D', null) as asc_or_desc, \n       i.distinct_keys as cardinality, \n       i.leaf_blocks as pages, \n       null as filter_condition, \n       i.tablespace_name, \n       i.status as index_status, \n       i.partitioned, \n" + (this.hasCompression ? "       i.compression, \n       i.prefix_length \n" : "       null as compression, \n       -1 as prefix_length \n");
        string3 = bl2 ? string3 + "FROM user_indexes i \n  JOIN user_ind_columns c \n    ON i.index_name = c.index_name \n   AND i.table_name = c.table_name \n" : string3 + "FROM all_indexes i \n  JOIN all_ind_columns c \n    ON i.index_name = c.index_name \n   AND i.table_owner = c.table_owner \n   AND i.table_name = c.table_name \n   AND i.owner = c.index_owner \n";
        string3 = string3 + "WHERE i.table_name = ? \n";
        if (tableIdentifier2.getRawSchema() != null && !bl2) {
            string3 = string3 + "  AND i.owner = ? \n";
        }
        if (bl) {
            string3 = string3 + "  AND i.uniqueness = 'UNIQUE'\n";
        }
        if (StringUtil.isNonBlank(string)) {
            string3 = string3 + "  AND i.index_name = '" + string + "' \n";
        }
        if (StringUtil.isNonEmpty(string2) && !bl2) {
            string3 = string3 + "  AND i.owner = '" + string2 + "' \n";
        }
        if (Settings.getInstance().getBoolProperty("workbench.db.oracle.indexlist.filtersnapindex", true)) {
            string3 = string3 + "  AND i.index_name NOT LIKE 'I_SNAP$%' \n";
        }
        string3 = string3 + "ORDER BY non_unique, type, index_name, ordinal_position ";
        LogMgr.logMetadataSql(new CallerInfo(){}, "index information ", string3, tableIdentifier2.getRawTableName(), tableIdentifier2.getRawSchema());
        this.indexStatement = this.metaData.getWbConnection().getSqlConnection().prepareStatement(string3);
        this.indexStatement.setString(1, tableIdentifier.getRawTableName());
        if (tableIdentifier.getSchema() != null && !bl2) {
            this.indexStatement.setString(2, tableIdentifier.getRawSchema());
        }
        ResultSet resultSet = this.indexStatement.executeQuery();
        return resultSet;
    }

    @Override
    protected void processIndexResultRow(ResultSet resultSet, IndexDefinition indexDefinition, TableIdentifier tableIdentifier) throws SQLException {
        String string;
        if (Settings.getInstance().getBoolProperty(PROP_USE_JDBC_FOR_INDEXLIST, false)) {
            return;
        }
        String string2 = resultSet.getString("TABLESPACE_NAME");
        if (this.hasCompression) {
            string = resultSet.getString("COMPRESSION");
            int n = resultSet.getInt("PREFIX_LENGTH");
            if ("ENABLED".equals(string) && n > 0) {
                ObjectSourceOptions objectSourceOptions = indexDefinition.getSourceOptions();
                objectSourceOptions.addConfigSetting(IDX_PROP_COMPRESS, Integer.toString(n));
            }
        }
        indexDefinition.setTablespace(string2);
        string = resultSet.getString("INDEX_STATUS");
        indexDefinition.setStatus(string);
        String string3 = resultSet.getString("partitioned");
        indexDefinition.setPartitioned(StringUtil.equalString("YES", string3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexDefinition getIndexDefinition(TableIdentifier tableIdentifier, String string, String string2) throws SQLException {
        List<IndexDefinition> list;
        IndexDefinition indexDefinition;
        ResultSet resultSet;
        block5: {
            IndexDefinition indexDefinition2;
            resultSet = null;
            indexDefinition = null;
            try {
                resultSet = this.getIndexInfo(tableIdentifier, string, string2, false);
                PkDefinition pkDefinition = tableIdentifier.getPrimaryKey();
                if (pkDefinition == null) {
                    pkDefinition = this.getPrimaryKey(tableIdentifier);
                }
                if (!(list = this.processIndexResult(resultSet, pkDefinition, tableIdentifier)).isEmpty()) break block5;
                indexDefinition2 = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResult(resultSet);
                this.indexInfoProcessed();
                throw throwable;
            }
            JdbcUtils.closeResult(resultSet);
            this.indexInfoProcessed();
            return indexDefinition2;
        }
        if (list.size() > 1) {
            LogMgr.logError(new CallerInfo(){}, "Got more than one index for indexName= " + string + " and table=" + tableIdentifier.toString(), null);
        }
        indexDefinition = list.get(0);
        JdbcUtils.closeResult(resultSet);
        this.indexInfoProcessed();
        return indexDefinition;
    }

    @Override
    protected StringBuilder processCreateIndexTemplate(TableIdentifier tableIdentifier, IndexDefinition indexDefinition) {
        StringBuilder stringBuilder = super.processCreateIndexTemplate(tableIdentifier, indexDefinition);
        CharSequence charSequence = this.getPartitionDefinition(indexDefinition, "   ");
        if (charSequence == null) {
            return stringBuilder;
        }
        StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.length() + charSequence.length() + 5);
        stringBuilder2.append(SqlUtil.trimSemicolon(stringBuilder.toString()));
        stringBuilder2.append('\n');
        stringBuilder2.append(charSequence);
        stringBuilder2.append(";\n");
        return stringBuilder2;
    }

    public static Set<String> getUseDbmsMetaForTypes() {
        List<String> list = Settings.getInstance().getListProperty("workbench.db.oracle.index.types.usedbmsmetadata", false, "DOMAIN");
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(list);
        return set;
    }

    @Override
    public CharSequence getIndexSource(TableIdentifier tableIdentifier, IndexDefinition indexDefinition) {
        if (indexDefinition == null) {
            return null;
        }
        boolean bl = OracleUtils.getUseOracleDBMSMeta(OracleUtils.DbmsMetadataTypes.index);
        Set<String> set = OracleIndexReader.getUseDbmsMetaForTypes();
        if (bl || set.contains(indexDefinition.getIndexType())) {
            try {
                return this.getSourceFromDBMSMeta(tableIdentifier, indexDefinition);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return super.getIndexSource(tableIdentifier, indexDefinition);
    }

    private String getSourceFromDBMSMeta(TableIdentifier tableIdentifier, IndexDefinition indexDefinition) throws SQLException {
        String string;
        String string2 = DbmsMetadata.getDDL(this.metaData.getWbConnection(), "INDEX", indexDefinition.getObjectName(), indexDefinition.getSchema());
        boolean bl = this.metaData.getDbSettings().createInlinePKConstraints();
        if (!bl && indexDefinition.isUniqueConstraint() && StringUtil.isNonBlank(string = DbmsMetadata.getDependentDDL(this.metaData.getWbConnection(), "CONSTRAINT", tableIdentifier.getTableName(), tableIdentifier.getSchema()))) {
            string2 = string2 + "\n\n" + string;
        }
        return string2;
    }

    @Override
    public String getIndexOptions(TableIdentifier tableIdentifier, IndexDefinition indexDefinition) {
        String string;
        String string2 = "";
        if (OracleUtils.shouldAppendTablespace(indexDefinition.getTablespace(), this.defaultTablespace, indexDefinition.getSchema(), this.metaData.getWbConnection().getCurrentUser())) {
            string2 = "\n   TABLESPACE " + indexDefinition.getTablespace();
        }
        if ("NORMAL/REV".equals(indexDefinition.getIndexType())) {
            string2 = string2 + "\n    REVERSE";
        }
        if ((string = indexDefinition.getSourceOptions().getConfigSettings().get(IDX_PROP_COMPRESS)) != null) {
            string2 = string2 + "\n   COMPRESS " + string;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processIndexList(Collection<IndexDefinition> collection) {
        Statement statement;
        String string;
        String string2;
        if (CollectionUtil.isEmpty(collection)) {
            return;
        }
        String string3 = "-- SQL Workbench \nSELECT " + OracleUtils.getCacheHint() + "i.index_name, e.column_expression, e.column_position \nFROM all_indexes i \n  JOIN all_ind_expressions e \n    ON i.index_name = e.index_name \n   AND i.owner = e.index_owner \n   AND i.table_name = e.table_name \n   AND e.index_owner = i.owner \n WHERE i.index_type like 'FUNCTION-BASED%' ";
        StringBuilder stringBuilder = new StringBuilder(300);
        stringBuilder.append(string3);
        boolean bl = false;
        stringBuilder.append(" AND (i.owner, i.index_name) IN (");
        for (IndexDefinition object2 : collection) {
            string2 = object2.getIndexType();
            if (string2 == null || !string2.startsWith("FUNCTION-BASED")) continue;
            if (bl) {
                stringBuilder.append(',');
            }
            bl = true;
            stringBuilder.append(" (");
            string = StringUtil.coalesce(object2.getSchema(), object2.getBaseTable().getSchema());
            string = string == null ? "USER" : "'" + this.metaData.removeQuotes(string) + "'";
            stringBuilder.append(string);
            stringBuilder.append(",'");
            stringBuilder.append(this.metaData.removeQuotes(object2.getName()));
            stringBuilder.append("')");
        }
        stringBuilder.append(" ) \n");
        stringBuilder.append(" ORDER BY 1,3");
        if (!bl) {
            return;
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "index info", stringBuilder, new Object[0]);
        Object object3 = null;
        Statement statement2 = null;
        try {
            statement = this.metaData.getWbConnection().createStatementForQuery();
            object3 = statement.executeQuery(stringBuilder.toString());
            while (object3.next()) {
                Object object;
                string2 = object3.getString(1);
                string = object3.getString(2);
                int n = object3.getInt(3);
                IndexDefinition indexDefinition = this.findIndex(collection, string2);
                if (indexDefinition == null) continue;
                List<IndexColumn> list = indexDefinition.getColumns();
                if (n >= 0 && n <= list.size()) {
                    object = list.get(n - 1);
                    ((IndexColumn)object).setColumn(SqlUtil.removeObjectQuotes(string));
                }
                if (((String)(object = indexDefinition.getIndexType())).startsWith("FUNCTION-BASED")) {
                    indexDefinition.setIndexType(((String)object).replace("FUNCTION-BASED ", ""));
                    continue;
                }
                if (((String)object).indexOf(32) <= -1 && ((String)object).indexOf(45) <= -1) continue;
                indexDefinition.setIndexType("NORMAL");
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "index info", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(object3, statement2);
                throw throwable;
            }
            JdbcUtils.closeAll((ResultSet)object3, statement2);
        }
        JdbcUtils.closeAll((ResultSet)object3, statement);
    }

    private IndexDefinition findIndex(Collection<IndexDefinition> collection, String string) {
        for (IndexDefinition indexDefinition : collection) {
            if (!indexDefinition.getName().equals(string)) continue;
            return indexDefinition;
        }
        return null;
    }

    public CharSequence getPartitionDefinition(IndexDefinition indexDefinition, String string) {
        if (!indexDefinition.isPartitioned()) {
            return null;
        }
        WbConnection wbConnection = this.metaData.getWbConnection();
        try {
            OracleIndexPartition oracleIndexPartition = new OracleIndexPartition(wbConnection);
            oracleIndexPartition.retrieve(indexDefinition, wbConnection);
            if (oracleIndexPartition.isPartitioned()) {
                return oracleIndexPartition.getSourceForIndexDefinition(string);
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error reading partition definition", sQLException);
        }
        return null;
    }

    @Override
    protected ResultSet getPrimaryKeyInfo(String string, String string2, String string3) throws SQLException {
        boolean bl = Settings.getInstance().getBoolProperty(PROP_USE_JDBC_FOR_PK_INFO, false);
        if (bl) {
            return super.getPrimaryKeyInfo(string, string2, string3);
        }
        String string4 = "-- SQL Workbench \nselect " + OracleUtils.getCacheHint() + "null as table_cat,  \n       cols.owner as table_schem,  \n       cols.table_name,  \n       cols.column_name,  \n       cols.position as key_seq,  \n       cons.constraint_name as pk_name,  \n       cons.index_name as pk_index_name,  \n       cons.status as pk_status \nfrom all_cons_columns cols  \n  join all_constraints cons on cols.constraint_name = cons.constraint_name and cols.owner = cons.owner  \nwhere cons.constraint_type = 'P' \n and cons.owner = ? \n and cons.table_name = ? ";
        if (OracleUtils.optimizeCatalogQueries() && (StringUtil.isEmptyString(string2) || string2.equalsIgnoreCase(this.currentUser))) {
            string4 = string4.replace(" all_co", " user_co");
        }
        if (this.pkStament != null) {
            LogMgr.logDebug(new CallerInfo(){}, "getPrimeryKeys() called with pending statement!");
            this.primaryKeysResultDone();
        }
        if (string2 == null) {
            string2 = this.metaData.getWbConnection().getCurrentSchema();
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "PK information", string4, string2, string3);
        this.pkStament = this.metaData.getSqlConnection().prepareStatement(string4);
        this.pkStament.setString(1, string2);
        this.pkStament.setString(2, string3);
        return this.pkStament.executeQuery();
    }

    @Override
    protected void primaryKeysResultDone() {
        JdbcUtils.closeStatement(this.pkStament);
        this.pkStament = null;
    }

    @Override
    protected Boolean isStatusEnabled(String string) {
        if (string == null) {
            return null;
        }
        return "ENABLED".equals(string);
    }
}

