/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.storage.ColumnData;
import workbench.storage.MergeGenerator;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.RowDataContainer;
import workbench.storage.SqlLiteralFormatter;

public class OracleMergeGenerator
implements MergeGenerator {
    private SqlLiteralFormatter formatter = new SqlLiteralFormatter("ansi");

    @Override
    public String generateMergeStart(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(100);
        this.generateStart(stringBuilder, rowDataContainer, false);
        return stringBuilder.toString();
    }

    @Override
    public String addRow(ResultInfo resultInfo, RowData rowData, long l) {
        StringBuilder stringBuilder = new StringBuilder(100);
        if (l > 0L) {
            stringBuilder.append("\n  UNION ALL\n");
        }
        this.appendValues(stringBuilder, resultInfo, rowData, l == 0L);
        return stringBuilder.toString();
    }

    @Override
    public String generateMergeEnd(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(rowDataContainer.getRowCount());
        this.appendJoin(stringBuilder, rowDataContainer);
        this.appendUpdate(stringBuilder, rowDataContainer);
        this.appendInsert(stringBuilder, rowDataContainer);
        return stringBuilder.toString();
    }

    @Override
    public String generateMerge(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(rowDataContainer.getRowCount());
        this.generateStart(stringBuilder, rowDataContainer, true);
        this.appendJoin(stringBuilder, rowDataContainer);
        this.appendUpdate(stringBuilder, rowDataContainer);
        this.appendInsert(stringBuilder, rowDataContainer);
        return stringBuilder.toString();
    }

    private void generateStart(StringBuilder stringBuilder, RowDataContainer rowDataContainer, boolean bl) {
        TableIdentifier tableIdentifier = rowDataContainer.getUpdateTable();
        stringBuilder.append("MERGE INTO ");
        stringBuilder.append(tableIdentifier.getTableExpression(rowDataContainer.getOriginalConnection()));
        stringBuilder.append(" ut\nUSING (\n");
        if (bl) {
            ResultInfo resultInfo = rowDataContainer.getResultInfo();
            for (int i = 0; i < rowDataContainer.getRowCount(); ++i) {
                if (i > 0) {
                    stringBuilder.append("\n  UNION ALL\n");
                }
                this.appendValues(stringBuilder, resultInfo, rowDataContainer.getRow(i), i == 0);
            }
        }
    }

    private void appendJoin(StringBuilder stringBuilder, RowDataContainer rowDataContainer) {
        ResultInfo resultInfo = rowDataContainer.getResultInfo();
        stringBuilder.append("\n) md ON (");
        int n = 0;
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            ColumnIdentifier columnIdentifier = resultInfo.getColumn(i);
            if (!columnIdentifier.isPkColumn()) continue;
            if (n > 0) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append("ut.");
            stringBuilder.append(resultInfo.getColumnName(i));
            stringBuilder.append(" = md.");
            stringBuilder.append(resultInfo.getColumnName(i));
            ++n;
        }
        stringBuilder.append(")");
    }

    private void appendValues(StringBuilder stringBuilder, ResultInfo resultInfo, RowData rowData, boolean bl) {
        stringBuilder.append("  SELECT ");
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            ColumnData columnData = new ColumnData(rowData.getValue(i), resultInfo.getColumn(i));
            stringBuilder.append(this.formatter.getDefaultLiteral(columnData));
            if (!bl) continue;
            stringBuilder.append(" AS ");
            stringBuilder.append(resultInfo.getColumnName(i));
        }
        stringBuilder.append(" FROM dual");
    }

    private void appendUpdate(StringBuilder stringBuilder, RowDataContainer rowDataContainer) {
        stringBuilder.append("\nWHEN MATCHED THEN UPDATE");
        ResultInfo resultInfo = rowDataContainer.getResultInfo();
        int n = 0;
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            ColumnIdentifier columnIdentifier = resultInfo.getColumn(i);
            if (columnIdentifier.isPkColumn()) continue;
            if (n == 0) {
                stringBuilder.append("\n     SET ");
            }
            if (n > 0) {
                stringBuilder.append(",\n         ");
            }
            stringBuilder.append("ut.");
            stringBuilder.append(resultInfo.getColumnName(i));
            stringBuilder.append(" = md.");
            stringBuilder.append(resultInfo.getColumnName(i));
            ++n;
        }
    }

    private void appendInsert(StringBuilder stringBuilder, RowDataContainer rowDataContainer) {
        stringBuilder.append("\nWHEN NOT MATCHED THEN\n  INSERT (");
        ResultInfo resultInfo = rowDataContainer.getResultInfo();
        StringBuilder stringBuilder2 = new StringBuilder(resultInfo.getColumnCount() * 10);
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
                stringBuilder2.append(", ");
            }
            stringBuilder.append(resultInfo.getColumnName(i));
            stringBuilder2.append("md.");
            stringBuilder2.append(resultInfo.getColumnName(i));
        }
        stringBuilder.append(")\n");
        stringBuilder.append("  VALUES (");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(");");
    }
}

