/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class OraclePartitionDefinition {
    private String type;
    private String subPartitionType;
    private String name;
    private String partitionValue;
    private int position;
    private String compressOption;
    private List<OraclePartitionDefinition> subPartitions;
    private boolean isSubpartition;

    public OraclePartitionDefinition(String string, String string2, int n) {
        this.name = string;
        this.position = n;
        this.type = string2;
    }

    public boolean isSubpartition() {
        return this.isSubpartition;
    }

    public void setIsSubpartition(boolean bl) {
        this.isSubpartition = bl;
    }

    public List<OraclePartitionDefinition> getSubPartitions() {
        if (this.subPartitions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.subPartitions);
    }

    public void addSubPartition(OraclePartitionDefinition oraclePartitionDefinition) {
        if (this.subPartitions == null) {
            this.subPartitions = new ArrayList<OraclePartitionDefinition>();
        }
        this.subPartitions.add(oraclePartitionDefinition);
    }

    public String getSubPartitionType() {
        return this.subPartitionType;
    }

    public void setSubPartitionType(String string) {
        this.subPartitionType = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getCompressOption() {
        return this.compressOption;
    }

    public void setCompressOption(String string) {
        this.compressOption = string;
    }

    public String getName() {
        return this.name;
    }

    public void setPartitionValue(String string) {
        this.partitionValue = string;
    }

    public String getPartitionValue() {
        return this.partitionValue;
    }

    public int getPosition() {
        return this.position;
    }

    public CharSequence getSource(boolean bl, int n, String string) {
        StringBuilder stringBuilder = new StringBuilder((this.partitionValue == null ? 15 : this.partitionValue.length()) + 20);
        stringBuilder.append(string);
        if (this.isSubpartition) {
            stringBuilder.append("  SUBPARTITION ");
        } else {
            stringBuilder.append("  PARTITION ");
        }
        stringBuilder.append(StringUtil.padRight(SqlUtil.quoteObjectname(this.name), n));
        if (this.partitionValue != null && bl) {
            if ("RANGE".equals(this.type)) {
                stringBuilder.append(" VALUES LESS THAN (");
                stringBuilder.append(this.partitionValue);
                stringBuilder.append(')');
            } else {
                stringBuilder.append(" VALUES (");
                stringBuilder.append(this.partitionValue);
                stringBuilder.append(')');
            }
        }
        if (this.compressOption != null && this.partitionValue != null && this.partitionValue.indexOf(39) > -1) {
            if ("DISABLED".equals(this.compressOption)) {
                stringBuilder.append(" NOCOMPRESS");
            }
            if ("ENABLED".equals(this.compressOption)) {
                stringBuilder.append(" COMPRESS");
            }
        }
        if (this.subPartitions != null && !this.subPartitions.isEmpty()) {
            int n2 = OraclePartitionDefinition.getMaxPartitionNameLength(this.subPartitions);
            stringBuilder.append("\n  ");
            stringBuilder.append(string);
            stringBuilder.append("(\n");
            for (int i = 0; i < this.subPartitions.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(",\n");
                }
                stringBuilder.append("  ");
                stringBuilder.append(string);
                stringBuilder.append(this.subPartitions.get(i).getSource(bl, n2, string + "  "));
            }
            stringBuilder.append("\n  ");
            stringBuilder.append(string);
            stringBuilder.append(")");
        }
        return stringBuilder;
    }

    static int getMaxPartitionNameLength(List<OraclePartitionDefinition> list) {
        int n = 0;
        for (OraclePartitionDefinition oraclePartitionDefinition : list) {
            String string = SqlUtil.quoteObjectname(oraclePartitionDefinition.getName());
            if (string.length() <= n) continue;
            n = string.length();
        }
        return n;
    }
}

