/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import workbench.db.WbConnection;
import workbench.db.oracle.AbstractOraclePartition;

public class OracleTablePartition
extends AbstractOraclePartition {
    public OracleTablePartition(WbConnection wbConnection) {
        super(wbConnection, true);
        this.isIndex = false;
    }

    protected OracleTablePartition(WbConnection wbConnection, boolean bl) {
        super(wbConnection, bl);
        this.isIndex = false;
    }

    @Override
    protected String getRetrieveColumnsSql() {
        return "-- SQL Workbench \nselect column_name, \n       column_position \nfrom all_part_key_columns \nwhere object_type = 'TABLE' \n  and owner = ? \n  and name = ? \norder by column_position \n";
    }

    @Override
    protected String getRetrievePartitionDefinitionSql() {
        return "-- SQL Workbench \nselect owner,  \n       table_name, \n       partitioning_type,  \n       partition_count, \n       partitioning_key_count, \n       subpartitioning_type, \n       subpartitioning_key_count, \n       def_subpartition_count,        " + (this.supportsIntervals ? "interval" : "null as interval") + ", \n       " + (this.supportsRefPartitions ? "ref_ptn_constraint_name" : "null as ref_ptn_constraint_name") + ", \n       def_tablespace_name \n from all_part_tables pt \nwhere pt.owner = ? \n  and pt.table_name = ? ";
    }

    @Override
    protected String getRetrievePartitionsSql() {
        if (this.useCompression) {
            return "-- SQL Workbench \nSELECT partition_name,  \n       high_value,  \n       partition_position, \n       subpartition_count, \n       compression \nFROM all_tab_partitions \nWHERE table_owner = ?  \n  AND table_name = ? \nORDER BY partition_position";
        }
        return "-- SQL Workbench \nSELECT partition_name,  \n       high_value,  \n       partition_position, \n       subpartition_count \nFROM all_tab_partitions \nWHERE table_owner = ?  \n  AND table_name = ? \nORDER BY partition_position";
    }

    @Override
    protected String getRetrieveSubColumnsSql() {
        return "-- SQL Workbench \nselect name, \n       object_type, \n       column_name, \n       column_position \nfrom all_subpart_key_columns \nwhere owner = ? \n  and name = ? \norder by column_position";
    }

    @Override
    protected String getRetrieveSubPartitionsSql() {
        if (this.useCompression) {
            return "-- SQL Workbench \nselect partition_name,  \n       subpartition_name,  \n       high_value, \n       subpartition_position, \n       compression \nfrom all_tab_subpartitions \nwhere table_owner = ?  \n  and table_name = ?  \norder by subpartition_position";
        }
        return "-- SQL Workbench \nselect partition_name,  \n       subpartition_name,  \n       high_value, \n       subpartition_position \nfrom all_tab_subpartitions \nwhere table_owner = ?  \n  and table_name = ?  \norder by subpartition_position";
    }
}

