/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import workbench.db.DbMetadata;
import workbench.db.IndexDefinition;
import workbench.db.JdbcIndexReader;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresIndexReader
extends JdbcIndexReader {
    private static final String PROP_RETRIEVE_DETAILS = "workbench.db.postgres.index.retrieve.details";

    public PostgresIndexReader(DbMetadata dbMetadata) {
        super(dbMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public StringBuilder getIndexSource(TableIdentifier tableIdentifier, List<IndexDefinition> list) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        WbConnection wbConnection = this.metaData.getWbConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        CallerInfo callerInfo = new CallerInfo(){};
        int n = list.size();
        String string = "'" + tableIdentifier.getRawSchema() + "'";
        StringBuilder stringBuilder = new StringBuilder(50 + n * 20);
        String string2 = "null::int[] as column_stats";
        if (JdbcUtils.hasMinimumServerVersion(wbConnection, "11")) {
            string2 = "(select array_agg(a.attstattarget) from pg_attribute a where a.attrelid = pg_catalog.format('%I.%I', i.schemaname, i.indexname)::regclass) as column_stats";
        }
        String string3 = JdbcUtils.hasMinimumServerVersion(wbConnection, "11") ? "  SELECT c.relnamespace::regnamespace::text AS schemaname, \n         c.relname AS tablename, \n         i.relname AS indexname, \n         t.spcname AS tablespace, \n         pg_catalog.pg_get_indexdef(i.oid) AS indexdef \n  FROM pg_catalog.pg_index x \n     JOIN pg_catalog.pg_class c ON c.oid = x.indrelid \n     JOIN pg_catalog.pg_class i ON i.oid = x.indexrelid \n     LEFT JOIN pg_catalog.pg_tablespace t ON t.oid = i.reltablespace \n  WHERE c.relkind in ('r','m','p') \n    AND i.relkind in ('i', 'I') \n     AND NOT i.relispartition \n" : "select * from pg_indexes\n";
        if (JdbcUtils.hasMinimumServerVersion(wbConnection, "8.0")) {
            stringBuilder.append("with my_pg_indexes as (" + string3 + ")\nSELECT i.indexdef, \n       i.indexname, \n       i.tablespace, \n       pg_catalog.obj_description((quote_ident(i.schemaname)||'.'||quote_ident(i.indexname))::regclass, 'pg_class') as remarks, \n       " + string2 + ", \n        ts.default_tablespace \nFROM my_pg_indexes i \n  cross join (\n    select ts.spcname as default_tablespace\n    from pg_catalog.pg_database d\n      join pg_catalog.pg_tablespace ts on ts.oid = d.dattablespace\n    where d.datname = current_database()\n  ) ts \n WHERE (i.schemaname, i.indexname) IN (");
        } else {
            stringBuilder.append("SELECT indexdef, indexname, null::text as tablespace, null::text as remarks, null::text as default_tablespace \nFROM pg_catalog.pg_indexes \nWHERE (schemaname, indexname) IN (");
        }
        boolean bl = wbConnection.getDbSettings().getBoolProperty("show.nonstandard.tablespace", true);
        String string4 = Settings.getInstance().getInternalEditorLineEnding();
        StringBuilder stringBuilder2 = new StringBuilder(n * 50);
        Savepoint savepoint = null;
        int n2 = 0;
        try {
            Integer[] integerArray;
            String string5;
            for (IndexDefinition object2 : list) {
                string5 = "'" + wbConnection.getMetadata().removeQuotes(object2.getName()) + "'";
                if (object2.isPrimaryKeyIndex() || object2.isAutoGenerated()) continue;
                if (object2.isUniqueConstraint()) {
                    integerArray = this.getUniqueConstraint(tableIdentifier, object2);
                    stringBuilder2.append((String)integerArray);
                    stringBuilder2.append(string4);
                    continue;
                }
                if (n2 > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append('(');
                stringBuilder.append(string);
                stringBuilder.append(',');
                stringBuilder.append(string5);
                stringBuilder.append(')');
                ++n2;
            }
            stringBuilder.append(')');
            if (n2 > 0) {
                LogMgr.logMetadataSql(callerInfo, "index definition", stringBuilder, new Object[0]);
                savepoint = wbConnection.setSavepoint();
                statement = wbConnection.createStatementForQuery();
                resultSet = statement.executeQuery(stringBuilder.toString());
                while (resultSet.next()) {
                    Object object;
                    void var18_23;
                    stringBuilder2.append(this.addIfNotExists(resultSet.getString("indexdef")));
                    String string6 = resultSet.getString("indexname");
                    String string7 = resultSet.getString("tablespace");
                    string5 = resultSet.getString("default_tablespace");
                    integerArray = JdbcUtils.getArray(resultSet, "column_stats", Integer[].class);
                    if (bl && !"pg_default".equals(string5) && StringUtil.isEmptyString(string7)) {
                        String string8 = string5;
                    }
                    if (StringUtil.isNonEmpty((CharSequence)var18_23)) {
                        object = this.findIndexByName(list, string6);
                        ((IndexDefinition)object).setTablespace((String)var18_23);
                        stringBuilder2.append(" TABLESPACE ");
                        stringBuilder2.append((String)var18_23);
                    }
                    stringBuilder2.append(';');
                    stringBuilder2.append(string4);
                    if (integerArray != null) {
                        stringBuilder2.append(string4);
                        for (int i = 0; i < integerArray.length; ++i) {
                            if (integerArray[i] <= 0) continue;
                            stringBuilder2.append("ALTER INDEX " + SqlUtil.quoteObjectname(string6) + " ALTER COLUMN " + (i + 1) + " SET STATISTICS " + integerArray[i] + ";");
                            stringBuilder2.append(string4);
                        }
                    }
                    if (!StringUtil.isNonBlank((CharSequence)(object = resultSet.getString("remarks")))) continue;
                    stringBuilder2.append("COMMENT ON INDEX " + SqlUtil.quoteObjectname(string6) + " IS '" + SqlUtil.escapeQuotes((String)object) + "'");
                }
                wbConnection.releaseSavepoint(savepoint);
            }
        }
        catch (Exception exception) {
            wbConnection.rollback(savepoint);
            LogMgr.logMetadataError(callerInfo, exception, "index definition", stringBuilder, new Object[0]);
            stringBuilder2 = new StringBuilder(ExceptionUtil.getDisplay(exception));
        }
        finally {
            JdbcUtils.closeAll(resultSet, statement);
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder2.append(string4);
        }
        return stringBuilder2;
    }

    private boolean useIfNotExists() {
        if (this.metaData == null) {
            return false;
        }
        return StringUtil.isNonEmpty(this.metaData.getDbSettings().getDDLIfNoExistsOption("INDEX"));
    }

    private String addIfNotExists(String string) {
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        if (this.useIfNotExists()) {
            return string.replace("CREATE INDEX", "CREATE INDEX IF NOT EXISTS");
        }
        return string;
    }

    @Override
    public String getIndexOptions(TableIdentifier tableIdentifier, IndexDefinition indexDefinition) {
        if (indexDefinition != null && StringUtil.isNonEmpty(indexDefinition.getTablespace())) {
            return "\n   TABLESPACE " + indexDefinition.getTablespace();
        }
        return null;
    }

    @Override
    public boolean supportsTableSpaces() {
        return Settings.getInstance().getBoolProperty(PROP_RETRIEVE_DETAILS, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processIndexList(Collection<IndexDefinition> collection) {
        String string;
        String string2;
        if (!Settings.getInstance().getBoolProperty(PROP_RETRIEVE_DETAILS, true)) {
            return;
        }
        if (CollectionUtil.isEmpty(collection)) {
            return;
        }
        WbConnection wbConnection = this.metaData.getWbConnection();
        if (!JdbcUtils.hasMinimumServerVersion(wbConnection, "8.0")) {
            return;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        int n = collection.size();
        boolean bl = JdbcUtils.hasMinimumServerVersion(wbConnection, "11");
        StringBuilder stringBuilder = new StringBuilder(50 + n * 20);
        stringBuilder.append("SELECT i.relname AS indexname, \n       coalesce(t.spcname, ts.default_tablespace) as tablespace, \n       pg_catalog.obj_description(i.oid) as remarks, \n       am.amname as index_type, \n       pg_catalog.pg_get_expr(x.indpred, x.indrelid, true) as filter_expression \nFROM pg_catalog.pg_index x \n  JOIN pg_catalog.pg_class i ON i.oid = x.indexrelid \n  JOIN pg_catalog.pg_class c ON c.oid = x.indrelid \n  JOIN pg_catalog.pg_am am on am.oid = i.relam \n  LEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace \n  LEFT JOIN pg_catalog.pg_tablespace t ON t.oid = i.reltablespace \n  cross join ( \n    select nullif(ts.spcname, 'pg_default') as default_tablespace \n    from pg_catalog.pg_database d \n      join pg_tablespace ts on ts.oid = d.dattablespace \n    where d.datname = current_database() \n  ) ts \nWHERE c.relkind in ('r', 'm', 'p')  \n  AND i.relkind in ('i','I') \n" + (bl ? "  and not i.relispartition \n" : "") + "and (n.nspname, i.relname) IN (");
        int n2 = 0;
        for (IndexDefinition object2 : collection) {
            string2 = wbConnection.getMetadata().removeQuotes(object2.getName());
            string = wbConnection.getMetadata().removeQuotes(object2.getSchema());
            if (n2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append("('");
            stringBuilder.append(string);
            stringBuilder.append("','");
            stringBuilder.append(string2);
            stringBuilder.append("')");
            ++n2;
        }
        stringBuilder.append(')');
        LogMgr.logMetadataSql(new CallerInfo(){}, "index information", stringBuilder, new Object[0]);
        Object object = null;
        try {
            object = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(stringBuilder.toString());
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                string2 = resultSet.getString(2);
                string = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                String string5 = resultSet.getString(5);
                IndexDefinition indexDefinition = this.findIndexByName(collection, string3);
                if (StringUtil.isNonEmpty(string2)) {
                    indexDefinition.setTablespace(string2);
                }
                indexDefinition.setComment(string);
                indexDefinition.setIndexType(string4);
                indexDefinition.setFilterExpression(string5);
            }
            wbConnection.releaseSavepoint((Savepoint)object);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback((Savepoint)object);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "index information", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
    }

    @Override
    public CharSequence getIndexSource(TableIdentifier tableIdentifier, IndexDefinition indexDefinition) {
        if (indexDefinition == null) {
            return null;
        }
        if (tableIdentifier == null) {
            return null;
        }
        if (Settings.getInstance().getBoolProperty("workbench.db.postgresql.default.indexsource", false)) {
            return super.getIndexSource(tableIdentifier, indexDefinition);
        }
        if (indexDefinition.isUniqueConstraint()) {
            return this.getUniqueConstraint(tableIdentifier, indexDefinition);
        }
        return this.getIndexSource(tableIdentifier, Collections.singletonList(indexDefinition));
    }

    @Override
    public boolean supportsIndexComments() {
        return true;
    }
}

