/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import workbench.db.DbMetadata;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListCleaner;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresObjectListCleaner
implements ObjectListCleaner {
    public static final String CLEANUP_PARTITIONS_PROP = "partitions.tablelist.remove";

    public boolean removePartitions() {
        return Settings.getInstance().getBoolProperty("workbench.db.postgresql.partitions.tablelist.remove", false);
    }

    @Override
    public void cleanupObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (DbMetadata.typeIncluded("TABLE", stringArray) && this.removePartitions()) {
            this.removePartitions(wbConnection, dataStore);
        }
        if (wbConnection.getDbSettings().returnAccessibleTablesOnly()) {
            this.removeInaccessible(wbConnection, dataStore);
        }
    }

    private void removePartitions(WbConnection wbConnection, DataStore dataStore) {
        if (dataStore.getRowCount() == 0) {
            return;
        }
        List<TableIdentifier> list = this.getAllPartitions(wbConnection);
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        int n = dataStore.getRowCount();
        for (int i = n - 1; i >= 0; --i) {
            String string;
            String string2 = dataStore.getValueAsString(i, 3);
            TableIdentifier tableIdentifier = new TableIdentifier(string2, string = dataStore.getValueAsString(i, 0));
            if (TableIdentifier.findTableByNameAndSchema(list, tableIdentifier) == null) continue;
            LogMgr.logDebug(new CallerInfo(){}, "Removing: " + string2 + "." + string);
            dataStore.deleteRow(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TableIdentifier> getAllPartitions(WbConnection wbConnection) {
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>();
        if (!JdbcUtils.hasMinimumServerVersion(wbConnection, "11")) {
            return arrayList;
        }
        String string = "with recursive inh as ( \n\n  select i.inhrelid, i.inhparent\n  from pg_catalog.pg_inherits i  \n  where i.inhparent in (select partrelid from pg_partitioned_table)\n\n  union all \n\n  select i.inhrelid, i.inhparent\n  from inh \n    join pg_catalog.pg_inherits i on inh.inhrelid = i.inhparent\n) \nselect c.relnamespace::regnamespace::text as partition_schema, \n       c.relname as partition_name \nfrom inh \n  join pg_catalog.pg_class c on inh.inhrelid = c.oid";
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        long l = System.currentTimeMillis();
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string);
            LogMgr.logMetadataSql(new CallerInfo(){}, "table partitions", string, new Object[0]);
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                arrayList.add(new TableIdentifier(string2, string3));
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "table partitions", string, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Reading all partitions took: " + l2 + "ms");
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInaccessible(WbConnection wbConnection, DataStore dataStore) {
        Object object;
        if (dataStore.getRowCount() == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        String string = this.buildTableList(dataStore);
        if (string.isEmpty()) {
            return;
        }
        CallerInfo callerInfo = new CallerInfo(){};
        String string2 = "with table_list (schemaname, tablename) as (\n values " + string + "\n)\nselect s.nspname, t.relname\nfrom pg_class t\n  join pg_namespace s on s.oid = t.relnamespace\n  join table_list l on (l.schemaname, l.tablename) = (s.nspname, t.relname) \nwhere not has_table_privilege(t.oid, 'select')";
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>();
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string2);
            LogMgr.logMetadataSql(callerInfo, "table permissions", string2, new Object[0]);
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                object = resultSet.getString(2);
                arrayList.add(new TableIdentifier(string3, (String)object));
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                arrayList.clear();
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(callerInfo, exception, "table permissions", string2, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        int n = dataStore.getRowCount();
        object = new ArrayList();
        for (int i = n - 1; i >= 0; --i) {
            String string4 = dataStore.getValueAsString(i, 0);
            String string5 = dataStore.getValueAsString(i, 3);
            TableIdentifier tableIdentifier = new TableIdentifier(string5, string4);
            if (TableIdentifier.findTableByNameAndSchema(arrayList, tableIdentifier) == null) continue;
            dataStore.deleteRow(i);
            object.add(tableIdentifier.getTableExpression());
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(callerInfo, "The following tables were removed from the result because the current user has no select privilege: " + StringUtil.listToString((Collection)object, "\n  ", false));
        LogMgr.logInfo(callerInfo, "Checking table permissions took: " + l2 + "ms");
    }

    private String buildTableList(DataStore dataStore) {
        Set<String> set = CollectionUtil.caseInsensitiveSet("TABLE", "MATERIALIZED VIEW", "FOREIGN TABLE", "VIEW");
        StringBuilder stringBuilder = new StringBuilder(dataStore.getRowCount() * 60);
        try {
            int n = 0;
            for (int i = 0; i < dataStore.getRowCount(); ++i) {
                String string = dataStore.getValueAsString(i, 1);
                if (!set.contains(string)) continue;
                String string2 = SqlUtil.escapeQuotes(dataStore.getValueAsString(i, 0));
                String string3 = SqlUtil.escapeQuotes(dataStore.getValueAsString(i, 3));
                if (n > 0) {
                    stringBuilder.append(',');
                }
                if (n % 5 == 0) {
                    stringBuilder.append("\n    ");
                }
                ++n;
                stringBuilder.append("('" + string3 + "','" + string2 + "')");
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not build table list", throwable);
        }
        return stringBuilder.toString();
    }
}

