/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.postgres.PgSubscription;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresSubscriptionReader
implements ObjectListExtender {
    private Boolean hasPrivileges;

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("SUBSCRIPTION");
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public boolean handlesType(String string) {
        return "SUBSCRIPTION".equalsIgnoreCase(string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PgSubscription> getSubscriptions(WbConnection wbConnection, String string) {
        ArrayList<PgSubscription> arrayList = new ArrayList<PgSubscription>();
        this.checkPrivileges(wbConnection);
        if (!this.hasPrivileges.booleanValue()) {
            return arrayList;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        StringBuilder stringBuilder = new StringBuilder("select s.subname, \n       s.subconninfo, \n       s.subpublications, \n       s.subenabled, \n       s.subslotname, \n       s.subsynccommit, \n       pg_catalog.obj_description(oid) as remarks \nfrom pg_catalog.pg_subscription s \nwhere subdbid = (select oid \n                 from pg_catalog.pg_database \n                 where datname = pg_catalog.current_database())");
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append("\n  and ");
            SqlUtil.appendExpression(stringBuilder, "s.subname", string, wbConnection);
        }
        stringBuilder.append("\norder by s.subname");
        LogMgr.logMetadataSql(new CallerInfo(){}, "subscriptions", stringBuilder, new Object[0]);
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(stringBuilder.toString());
            while (resultSet.next()) {
                String string2 = resultSet.getString("subname");
                String string3 = resultSet.getString("remarks");
                PgSubscription pgSubscription = new PgSubscription(string2);
                pgSubscription.setConnectionInfo(resultSet.getString("subconninfo"));
                pgSubscription.setEnabled(resultSet.getBoolean("subenabled"));
                pgSubscription.setSyncCommitEnabled(resultSet.getBoolean("subsynccommit"));
                pgSubscription.setSlotName(resultSet.getString("subslotname"));
                String[] stringArray = JdbcUtils.getArray(resultSet, "subpublications", String[].class);
                pgSubscription.setPublications(Arrays.asList(stringArray));
                pgSubscription.setComment(string3);
                arrayList.add(pgSubscription);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "subscriptions", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    @Override
    public PgSubscription getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        List<PgSubscription> list = this.getSubscriptions(wbConnection, dbObject.getObjectName());
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject instanceof PgSubscription) {
            return this.getSource((PgSubscription)dbObject);
        }
        PgSubscription pgSubscription = this.getObjectDefinition(wbConnection, dbObject);
        return this.getSource(pgSubscription);
    }

    private String getSource(PgSubscription pgSubscription) {
        if (pgSubscription == null) {
            return null;
        }
        return pgSubscription.getSource();
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("SUBSCRIPTION", stringArray)) {
            return false;
        }
        List<PgSubscription> list = this.getSubscriptions(wbConnection, string3);
        for (PgSubscription pgSubscription : list) {
            int n = dataStore.addRow();
            dataStore.getRow(n).setUserObject(pgSubscription);
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, null);
            dataStore.setValue(n, 0, (Object)pgSubscription.getObjectName());
            dataStore.setValue(n, 4, (Object)pgSubscription.getComment());
            dataStore.setValue(n, 1, (Object)pgSubscription.getObjectType());
        }
        return list.size() > 0;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableIdentifier> getTables(WbConnection wbConnection, DbObject dbObject) {
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>();
        this.checkPrivileges(wbConnection);
        if (!this.hasPrivileges.booleanValue()) {
            return arrayList;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        String string = "SELECT c.relnamespace::regnamespace::text as table_schema, \n       c.relname as table_name, \n       pg_catalog.obj_description(c.oid) as remarks \nFROM pg_catalog.pg_subscription s \n  JOIN pg_catalog.pg_subscription_rel rel ON rel.srsubid = s.oid \n  JOIN pg_catalog.pg_class c on c.oid = rel.srrelid \nwhere s.subname = ? ";
        LogMgr.logMetadataSql(new CallerInfo(){}, "subscription tables", string, new Object[0]);
        try {
            savepoint = wbConnection.setSavepoint();
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, dbObject.getObjectName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString("table_schema");
                String string3 = resultSet.getString("table_name");
                String string4 = resultSet.getString("remarks");
                TableIdentifier tableIdentifier = new TableIdentifier(string2, string3);
                tableIdentifier.setComment(string4);
                tableIdentifier.setNeverAdjustCase(true);
                arrayList.add(tableIdentifier);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "subscription tables", string, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }

    private synchronized void checkPrivileges(WbConnection wbConnection) {
        if (this.hasPrivileges != null) {
            return;
        }
        try {
            this.hasPrivileges = false;
            LogMgr.logDebug(new CallerInfo(){}, "Checking privileges for pg_catalog.pg_subscription");
            JdbcUtils.runQuery(wbConnection, "select has_table_privilege('pg_catalog.pg_subscription', 'select')", false, resultSet -> {
                if (resultSet.next()) {
                    this.hasPrivileges = resultSet.getBoolean(1);
                }
            });
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not check privileges for pg_catalog.pg_subscription", sQLException);
            this.hasPrivileges = false;
        }
    }
}

