/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import workbench.db.ColumnIdentifier;
import workbench.db.DbSettings;
import workbench.db.DependencyNode;
import workbench.db.DomainIdentifier;
import workbench.db.DropType;
import workbench.db.EnumIdentifier;
import workbench.db.IndexDefinition;
import workbench.db.JdbcUtils;
import workbench.db.ObjectSourceOptions;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.WbConnection;
import workbench.db.postgres.InheritanceEntry;
import workbench.db.postgres.PostgresColumnEnhancer;
import workbench.db.postgres.PostgresDomainReader;
import workbench.db.postgres.PostgresEnumReader;
import workbench.db.postgres.PostgresInheritanceReader;
import workbench.db.postgres.PostgresPartition;
import workbench.db.postgres.PostgresPartitionReader;
import workbench.db.postgres.PostgresPolicyReader;
import workbench.db.postgres.PostgresRuleReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresTableSourceBuilder
extends TableSourceBuilder {
    private boolean isPostgres10 = false;
    public static final String FORCE_RLS_OPTION = "FORCE_RLS";
    public static final String RLS_ENABLED_OPTION = "RLS_ENABLED";
    public static final String REPLICA_IDENT_OPTION = "REPLICA_IDENTITY";
    public static final String REPLICA_INDEX = "REPLICA_INDEX";

    public PostgresTableSourceBuilder(WbConnection wbConnection) {
        super(wbConnection);
        this.isPostgres10 = JdbcUtils.hasMinimumServerVersion(wbConnection, "10.0");
    }

    protected CharSequence baseCreateTable(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, List<IndexDefinition> list2, List<DependencyNode> list3, DropType dropType, boolean bl, boolean bl2, boolean bl3) {
        return super.getCreateTable(tableIdentifier, list, list2, list3, dropType, bl, bl2, bl3);
    }

    @Override
    public CharSequence getCreateTable(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, List<IndexDefinition> list2, List<DependencyNode> list3, DropType dropType, boolean bl, boolean bl2, boolean bl3) {
        PostgresPartition postgresPartition = null;
        if (this.isPostgres10) {
            postgresPartition = PostgresPartitionReader.getPartitionDefinition(tableIdentifier, this.dbConnection);
        }
        if (postgresPartition == null) {
            return super.getCreateTable(tableIdentifier, list, list2, list3, dropType, bl, bl2, bl3);
        }
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append(this.generateDrop(tableIdentifier, dropType));
        stringBuilder.append("\n\n");
        stringBuilder.append(PostgresPartitionReader.generatePartitionDDL(postgresPartition, null, this.dbConnection));
        stringBuilder.append(";\n\n");
        return stringBuilder;
    }

    @Override
    public void readTableOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        if (objectSourceOptions.isInitialized()) {
            return;
        }
        PostgresRuleReader postgresRuleReader = new PostgresRuleReader();
        CharSequence charSequence = postgresRuleReader.getTableRuleSource(this.dbConnection, tableIdentifier);
        if (charSequence != null) {
            objectSourceOptions.setAdditionalSql(charSequence.toString());
        }
        if ("FOREIGN TABLE".equals(tableIdentifier.getType())) {
            this.readForeignTableOptions(tableIdentifier);
        } else {
            this.readTableOptions(tableIdentifier);
        }
        objectSourceOptions.setInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTableOptions(TableIdentifier tableIdentifier) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        if (!JdbcUtils.hasMinimumServerVersion(this.dbConnection, "8.1")) {
            return;
        }
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        StringBuilder stringBuilder = this.readInherits(tableIdentifier);
        StringBuilder stringBuilder2 = new StringBuilder();
        String string8 = null;
        string8 = JdbcUtils.hasMinimumServerVersion(this.dbConnection, "9.1") ? "ct.relpersistence" : (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "8.4") ? "case when ct.relistemp then 't' else null::char end as relpersistence" : "null::char as relpersistence");
        if (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "9.4")) {
            string7 = "ct.relreplident";
            string6 = "case \n          when ct.relreplident = 'i'                then (select ix.indexrelid::regclass::text from pg_index ix where ix.indrelid = ct.oid and ix.indisreplident) \n          else null \n       end as replica_index";
        } else {
            string7 = "null as relreplident";
            string6 = "null as replica_index";
        }
        boolean bl = this.dbConnection.getDbSettings().getBoolProperty("show.nonstandard.tablespace", true);
        boolean bl2 = JdbcUtils.hasMinimumServerVersion(this.dbConnection, "9.5");
        if (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "8.0")) {
            string5 = "spc.spcname";
            string4 = "ts.default_tablespace";
            string3 = "  cross join (\n    select ts.spcname as default_tablespace\n    from pg_catalog.pg_database d\n      join pg_catalog.pg_tablespace ts on ts.oid = d.dattablespace\n    where d.datname = current_database()\n  ) ts \n ";
        } else {
            string5 = "null as spcname";
            string4 = "null as default_tablespace";
            string3 = "";
            bl = false;
        }
        if (bl2) {
            string2 = "ct.relrowsecurity";
            string = "ct.relforcerowsecurity";
        } else {
            string2 = "false as relrowsecurity";
            string = "false as relforcerowsecurity";
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string9 = "select " + string8 + ", \n       ct.relkind, \n       array_to_string(ct.reloptions, ', ') as options, \n       " + string5 + ", \n       own.rolname as owner, \n       " + string4 + ", \n       " + string2 + ", \n       " + string + ", \n        " + string7 + ", \n       " + string6 + " \nfrom pg_catalog.pg_class ct \n  join pg_catalog.pg_namespace cns on ct.relnamespace = cns.oid \n   join pg_catalog.pg_roles own on ct.relowner = own.oid \n   left join pg_catalog.pg_tablespace spc on spc.oid = ct.reltablespace \n" + string3 + " where cns.nspname = ? \n   and ct.relname = ?";
        boolean bl3 = false;
        CallerInfo callerInfo = new CallerInfo(){};
        Savepoint savepoint = null;
        try {
            savepoint = this.dbConnection.setSavepoint();
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string9);
            preparedStatement.setString(1, tableIdentifier.getRawSchema());
            preparedStatement.setString(2, tableIdentifier.getRawTableName());
            LogMgr.logMetadataSql(callerInfo, "table options", string9, tableIdentifier.getSchema(), tableIdentifier.getTableName());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string10;
                Object object;
                String string11 = resultSet.getString("relpersistence");
                String string12 = resultSet.getString("relreplident");
                String string13 = resultSet.getString("relkind");
                String string14 = resultSet.getString("options");
                String string15 = resultSet.getString("spcname");
                String string16 = resultSet.getString("owner");
                String string17 = resultSet.getString("default_tablespace");
                boolean bl4 = resultSet.getBoolean("relrowsecurity");
                boolean bl5 = resultSet.getBoolean("relforcerowsecurity");
                if (bl && !"pg_default".equals(string17) && StringUtil.isEmptyString(string15)) {
                    string15 = string17;
                }
                tableIdentifier.setOwner(string16);
                tableIdentifier.setTablespace(string15);
                if (StringUtil.isNonEmpty(string11)) {
                    switch (string11.charAt(0)) {
                        case 'u': {
                            objectSourceOptions.setTypeModifier("UNLOGGED");
                            break;
                        }
                        case 't': {
                            objectSourceOptions.setTypeModifier("TEMPORARY");
                        }
                    }
                }
                if (StringUtil.isNonEmpty(string12)) {
                    object = tableIdentifier.getTableExpression(this.dbConnection);
                    string10 = "ALTER TABLE " + (String)object + " REPLICA IDENTITY ";
                    switch (string12.charAt(0)) {
                        case 'n': {
                            objectSourceOptions.appendAdditionalSql(string10 + "NOTHING;");
                            objectSourceOptions.addConfigSetting(REPLICA_IDENT_OPTION, "nothing");
                            break;
                        }
                        case 'f': {
                            objectSourceOptions.appendAdditionalSql(string10 + "FULL;");
                            objectSourceOptions.addConfigSetting(REPLICA_IDENT_OPTION, "full");
                            break;
                        }
                        case 'i': {
                            String string18 = resultSet.getString("replica_index");
                            objectSourceOptions.appendAdditionalSql(string10 + "USING INDEX " + SqlUtil.quoteObjectname(string18) + ";");
                            objectSourceOptions.addConfigSetting(REPLICA_IDENT_OPTION, "index");
                            objectSourceOptions.addConfigSetting(REPLICA_INDEX, string18);
                        }
                    }
                }
                if (bl5) {
                    objectSourceOptions.addConfigSetting(FORCE_RLS_OPTION, "true");
                }
                if (bl4) {
                    objectSourceOptions.addConfigSetting(RLS_ENABLED_OPTION, "true");
                }
                if ("f".equalsIgnoreCase(string13)) {
                    objectSourceOptions.setTypeModifier("FOREIGN");
                }
                if (!(bl3 = "p".equals(string13)) && stringBuilder != null) {
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append('\n');
                    }
                    stringBuilder2.append((CharSequence)stringBuilder);
                }
                if (StringUtil.isNonEmpty(string14)) {
                    this.setConfigSettings(string14, objectSourceOptions);
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append('\n');
                    }
                    stringBuilder2.append("WITH (");
                    stringBuilder2.append(string14);
                    stringBuilder2.append(")");
                }
                if (StringUtil.isNonBlank(string15)) {
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append('\n');
                    }
                    stringBuilder2.append("TABLESPACE ");
                    stringBuilder2.append(string15);
                }
                if (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "9.5")) {
                    object = new PostgresPolicyReader();
                    string10 = ((PostgresPolicyReader)object).getTablePolicies(this.dbConnection, tableIdentifier);
                    objectSourceOptions.appendAdditionalSql(string10);
                }
            }
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                this.dbConnection.rollback(savepoint);
                LogMgr.logMetadataError(callerInfo, sQLException, "table options", string9, tableIdentifier.getSchema(), tableIdentifier.getTableName());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        objectSourceOptions.setTableOption(stringBuilder2.toString());
        if (bl3) {
            this.handlePartitions(tableIdentifier);
        }
    }

    protected void setConfigSettings(String string, ObjectSourceOptions objectSourceOptions) {
        List<String> list = StringUtil.stringToList(string, ",", true, true, false, true);
        for (String string2 : list) {
            String[] stringArray = string2.split("=");
            if (stringArray.length != 2) continue;
            objectSourceOptions.addConfigSetting(stringArray[0], stringArray[1]);
        }
    }

    protected void handlePartitions(TableIdentifier tableIdentifier) {
        PostgresPartitionReader postgresPartitionReader = new PostgresPartitionReader(tableIdentifier, this.dbConnection);
        postgresPartitionReader.readPartitionInformation();
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        String string = postgresPartitionReader.getPartitionDefinition();
        objectSourceOptions.appendTableOptionSQL(string);
        objectSourceOptions.addConfigSetting("partition_strategy", postgresPartitionReader.getStrategy().toLowerCase());
        objectSourceOptions.addConfigSetting("partition_expression", postgresPartitionReader.getPartitionExpression());
        String string2 = postgresPartitionReader.getCreatePartitions();
        if (string2 != null) {
            objectSourceOptions.appendAdditionalSql(string2);
        }
    }

    protected StringBuilder readInherits(TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return null;
        }
        StringBuilder stringBuilder = null;
        PostgresInheritanceReader postgresInheritanceReader = new PostgresInheritanceReader();
        List<TableIdentifier> list = postgresInheritanceReader.getParents(this.dbConnection, tableIdentifier);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        stringBuilder = new StringBuilder(list.size() * 30);
        stringBuilder.append("INHERITS (");
        for (int i = 0; i < list.size(); ++i) {
            TableIdentifier tableIdentifier2 = list.get(i);
            tableIdentifier.getSourceOptions().addConfigSetting("inherits", tableIdentifier2.getTableName());
            stringBuilder.append(tableIdentifier2.getTableName());
            if (i <= 0) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(')');
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readForeignTableOptions(TableIdentifier tableIdentifier) {
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        String string = "select ft.ftoptions, fs.srvname \nfrom pg_foreign_table ft \n  join pg_class tbl on tbl.oid = ft.ftrelid  \n  join pg_namespace ns on tbl.relnamespace = ns.oid  \n  join pg_foreign_server fs on ft.ftserver = fs.oid \n  WHERE tbl.relname = ? \n   and ns.nspname = ? ";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        StringBuilder stringBuilder = new StringBuilder(100);
        Savepoint savepoint = null;
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            savepoint = this.dbConnection.setSavepoint();
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getRawTableName());
            preparedStatement.setString(2, tableIdentifier.getRawSchema());
            LogMgr.logMetadataSql(callerInfo, "foreign table options", string, tableIdentifier.getTableName(), tableIdentifier.getSchema());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String[] stringArray = JdbcUtils.getArray(resultSet, "ftoptions", String[].class);
                String string2 = resultSet.getString(2);
                stringBuilder.append("SERVER ");
                stringBuilder.append(string2);
                if (stringArray != null && stringArray.length > 0) {
                    stringBuilder.append("\nOPTIONS (");
                    for (int i = 0; i < stringArray.length; ++i) {
                        String[] stringArray2;
                        if (i > 0) {
                            stringBuilder.append(", ");
                        }
                        if ((stringArray2 = stringArray[i].split("=")).length != 2) continue;
                        stringBuilder.append(stringArray2[0] + " '" + stringArray2[1] + "'");
                    }
                    stringBuilder.append(')');
                }
                objectSourceOptions.setTableOption(stringBuilder.toString());
            }
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                this.dbConnection.rollback(savepoint);
                savepoint = null;
                LogMgr.logMetadataError(callerInfo, sQLException, "foreign table options", tableIdentifier.getTableName(), tableIdentifier.getSchema());
                this.dbConnection.releaseSavepoint(savepoint);
            }
            catch (Throwable throwable) {
                this.dbConnection.releaseSavepoint(savepoint);
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }

    @Override
    public StringBuilder getFkSource(TableIdentifier tableIdentifier, List<DependencyNode> list, boolean bl) {
        StringBuilder stringBuilder = super.getFkSource(tableIdentifier, list, bl);
        this.appendFKComments(tableIdentifier, stringBuilder, list);
        return stringBuilder;
    }

    private void appendFKComments(TableIdentifier tableIdentifier, StringBuilder stringBuilder, List<DependencyNode> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        String string = tableIdentifier.getTableExpression(this.dbConnection);
        for (DependencyNode dependencyNode : list) {
            String string2 = SqlUtil.quoteObjectname(dependencyNode.getFkName());
            String string3 = SqlUtil.escapeQuotes(dependencyNode.getComment());
            if (!StringUtil.isNonEmpty(string3)) continue;
            String string4 = "\nCOMMENT ON CONSTRAINT " + string2 + " ON " + string + " IS '" + string3 + "';";
            stringBuilder.append(string4);
        }
    }

    @Override
    public String getAdditionalTableInfo(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, List<IndexDefinition> list2) {
        String string = tableIdentifier.getSchemaToUse(this.dbConnection);
        CharSequence charSequence = this.getEnumInformation(list, string);
        CharSequence charSequence2 = this.getDomainInformation(list, string);
        CharSequence charSequence3 = this.getColumnSequenceInformation(tableIdentifier, list);
        CharSequence charSequence4 = null;
        if (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "10.0")) {
            charSequence4 = this.readExtendeStats(tableIdentifier);
        }
        CharSequence charSequence5 = null;
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        if (objectSourceOptions.getConfigSettings().get("partition_strategy") == null) {
            charSequence5 = this.getChildTables(tableIdentifier);
        }
        StringBuilder stringBuilder = this.getColumnStorage(tableIdentifier, list);
        String string2 = this.getOwnerSql(tableIdentifier);
        if (StringUtil.allEmpty(charSequence, charSequence2, charSequence3, charSequence5, string2, stringBuilder, charSequence4)) {
            return null;
        }
        StringBuilder stringBuilder2 = new StringBuilder(200);
        if (stringBuilder != null) {
            stringBuilder2.append((CharSequence)stringBuilder);
        }
        if (charSequence != null) {
            stringBuilder2.append(charSequence);
        }
        if (charSequence2 != null) {
            stringBuilder2.append(charSequence2);
        }
        if (charSequence3 != null) {
            stringBuilder2.append(charSequence3);
        }
        if (charSequence4 != null) {
            stringBuilder2.append(charSequence4);
        }
        if (charSequence5 != null) {
            stringBuilder2.append(charSequence5);
        }
        if (string2 != null) {
            stringBuilder2.append(string2);
        }
        return stringBuilder2.toString();
    }

    private StringBuilder getColumnStorage(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        StringBuilder stringBuilder = null;
        String string = tableIdentifier.getTableExpression(this.dbConnection);
        for (ColumnIdentifier columnIdentifier : list) {
            int n = columnIdentifier.getPgStorage();
            String string2 = PostgresColumnEnhancer.getStorageOption(n);
            if (string2 == null || this.isDefaultStorage(columnIdentifier.getDataType(), n)) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(50);
                stringBuilder.append('\n');
            }
            stringBuilder.append("ALTER TABLE ");
            stringBuilder.append(string);
            stringBuilder.append(" ALTER ");
            stringBuilder.append(this.dbConnection.getMetadata().quoteObjectname(columnIdentifier.getColumnName()));
            stringBuilder.append(" SET STORAGE ");
            stringBuilder.append(string2);
            stringBuilder.append(";\n");
        }
        return stringBuilder;
    }

    private boolean isDefaultStorage(int n, int n2) {
        if (n == 2 && n2 == 2) {
            return true;
        }
        return n2 == 4;
    }

    protected String getOwnerSql(TableIdentifier tableIdentifier) {
        try {
            String string;
            DbSettings.GenerateOwnerType generateOwnerType = this.dbConnection.getDbSettings().getGenerateTableOwner();
            if (generateOwnerType == DbSettings.GenerateOwnerType.never) {
                return null;
            }
            String string2 = tableIdentifier.getOwner();
            if (StringUtil.isBlank(string2)) {
                return null;
            }
            if (generateOwnerType == DbSettings.GenerateOwnerType.whenNeeded && (string = this.dbConnection.getCurrentUser()).equalsIgnoreCase(string2)) {
                return null;
            }
            return "\nALTER TABLE " + tableIdentifier.getFullyQualifiedName(this.dbConnection) + " OWNER TO " + SqlUtil.quoteObjectname(string2) + ";";
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CharSequence getColumnSequenceInformation(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        if (!JdbcUtils.hasMinimumServerVersion(this.dbConnection, "8.4")) {
            return null;
        }
        if (tableIdentifier == null) {
            return null;
        }
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        String string = tableIdentifier.getTableExpression(this.dbConnection);
        ResultSet resultSet = null;
        Statement statement = null;
        StringBuilder stringBuilder = new StringBuilder(100);
        Savepoint savepoint = null;
        String string2 = null;
        try {
            savepoint = this.dbConnection.setSavepoint();
            statement = this.dbConnection.createStatementForQuery();
            for (ColumnIdentifier columnIdentifier : list) {
                String string3;
                String string4 = columnIdentifier.getDefaultValue();
                if (string4 != null && string4.toLowerCase().contains("nextval")) continue;
                String string5 = StringUtil.trimQuotes(columnIdentifier.getColumnName());
                string2 = "select pg_get_serial_sequence('" + string + "', '" + string5 + "')";
                LogMgr.logMetadataSql(new CallerInfo(){}, "sequence information", string2, new Object[0]);
                resultSet = statement.executeQuery(string2);
                if (!resultSet.next() || !StringUtil.isNonBlank(string3 = resultSet.getString(1))) continue;
                String string6 = ResourceMgr.getFormattedString("TxtSequenceCol", columnIdentifier.getColumnName(), string3);
                stringBuilder.append("\n-- ");
                stringBuilder.append(string6);
            }
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                this.dbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "sequence information", string2, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder;
    }

    protected CharSequence getEnumInformation(List<ColumnIdentifier> list, String string) {
        PostgresEnumReader postgresEnumReader = new PostgresEnumReader();
        Map<String, EnumIdentifier> map = postgresEnumReader.getEnumInfo(this.dbConnection, string, null);
        if (CollectionUtil.isEmpty(map)) {
            return null;
        }
        StringBuilder stringBuilder = null;
        for (ColumnIdentifier columnIdentifier : list) {
            String string2 = columnIdentifier.getDbmsType();
            EnumIdentifier enumIdentifier = map.get(string2);
            if (enumIdentifier == null) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(50);
            }
            stringBuilder.append("\n-- enum '");
            stringBuilder.append(string2);
            stringBuilder.append("': ");
            stringBuilder.append(StringUtil.listToString(enumIdentifier.getValues(), ",", true, '\''));
        }
        return stringBuilder;
    }

    public CharSequence getDomainInformation(List<ColumnIdentifier> list, String string) {
        PostgresDomainReader postgresDomainReader = new PostgresDomainReader();
        Map<String, DomainIdentifier> map = postgresDomainReader.getDomainInfo(this.dbConnection, string);
        if (map == null || map.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = null;
        for (ColumnIdentifier columnIdentifier : list) {
            String string2 = columnIdentifier.getDbmsType();
            DomainIdentifier domainIdentifier = map.get(string2);
            if (domainIdentifier == null) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(50);
            }
            stringBuilder.append("\n-- domain '");
            stringBuilder.append(string2);
            stringBuilder.append("': ");
            stringBuilder.append(domainIdentifier.getSummary());
        }
        return stringBuilder;
    }

    protected CharSequence getChildTables(TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return null;
        }
        PostgresInheritanceReader postgresInheritanceReader = new PostgresInheritanceReader();
        List<InheritanceEntry> list = postgresInheritanceReader.getChildren(this.dbConnection, tableIdentifier);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(list.size() * 50);
        boolean bl = JdbcUtils.hasMinimumServerVersion(this.dbConnection, "8.4");
        if (bl) {
            stringBuilder.append("\n/* Inheritance tree:\n\n");
            stringBuilder.append(tableIdentifier.getSchema());
            stringBuilder.append('.');
            stringBuilder.append(tableIdentifier.getTableName());
        } else {
            stringBuilder.append("\n-- Child tables:");
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i).getTable().getTableName();
            String string2 = list.get(i).getTable().getSchema();
            int n = list.get(i).getLevel();
            if (bl) {
                stringBuilder.append('\n');
                stringBuilder.append(StringUtil.padRight(" ", n * 2));
            } else {
                stringBuilder.append("\n--  ");
            }
            stringBuilder.append(string2);
            stringBuilder.append('.');
            stringBuilder.append(string);
        }
        if (bl) {
            stringBuilder.append("\n*/");
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence readExtendeStats(TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return null;
        }
        String string = "select st.stxname as statistic_name, \n       sn.nspname as statistic_schema, \n       string_agg(col.attname, ',') as columns, \n       array_to_string(stxkind, '') as stxkind \nfrom pg_statistic_ext st \n  join pg_namespace sn on sn.oid = st.stxnamespace \n  join pg_class t on t.oid = st.stxrelid\n  join pg_namespace nsp on nsp.oid = t.relnamespace\n  join pg_attribute col on t.oid = col.attrelid and col.attnum = any(stxkeys)\nwhere nsp.nspname = ? \n  and t.relname = ? \ngroup by st.stxname, sn.nspname, st.stxkind";
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        StringBuilder stringBuilder = new StringBuilder(100);
        Savepoint savepoint = null;
        StringBuilder stringBuilder2 = null;
        CallerInfo callerInfo = new CallerInfo(){};
        LogMgr.logMetadataSql(callerInfo, "extended column statistics", string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        try {
            savepoint = this.dbConnection.setSavepoint();
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getRawSchema());
            preparedStatement.setString(2, tableIdentifier.getRawTableName());
            resultSet = preparedStatement.executeQuery();
            String string2 = tableIdentifier.getTableExpression(this.dbConnection);
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4);
                TableIdentifier tableIdentifier2 = new TableIdentifier(string4, string3);
                if (stringBuilder2 == null) {
                    stringBuilder2 = new StringBuilder(100);
                }
                stringBuilder2.append("\nCREATE STATISTICS ");
                stringBuilder2.append(tableIdentifier2.getTableExpression(this.dbConnection));
                if (StringUtil.isNonBlank(string6)) {
                    stringBuilder2.append(" (");
                    block10: for (int i = 0; i < string6.length(); ++i) {
                        if (i > 0) {
                            stringBuilder2.append(',');
                        }
                        switch (string6.charAt(i)) {
                            case 'd': {
                                stringBuilder2.append("ndistinct");
                                continue block10;
                            }
                            case 'f': {
                                stringBuilder2.append("dependencies");
                                continue block10;
                            }
                            case 'm': {
                                stringBuilder2.append("mcv");
                            }
                        }
                    }
                    stringBuilder2.append(")");
                }
                stringBuilder2.append(" ON ");
                stringBuilder2.append(string5);
                stringBuilder2.append(" FROM ");
                stringBuilder2.append(string2);
                stringBuilder2.append(';');
                objectSourceOptions.addConfigSetting("column_statistics", stringBuilder2.toString());
            }
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                this.dbConnection.rollback(savepoint);
                LogMgr.logMetadataError(callerInfo, exception, "extended column statistics", string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
                stringBuilder2 = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return stringBuilder2;
    }
}

