/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.List;
import workbench.db.ConstraintDefinition;
import workbench.db.IndexDefinition;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.UniqueConstraintReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;

public class PostgresUniqueConstraintReader
implements UniqueConstraintReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readUniqueConstraints(TableIdentifier tableIdentifier, List<IndexDefinition> list, WbConnection wbConnection) {
        ResultSet resultSet;
        String string;
        Object object;
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        if (wbConnection == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(500);
        String string2 = null;
        string2 = JdbcUtils.hasMinimumServerVersion(wbConnection, "9.0") ? "  select ind.relname as index_name, \n         indschem.nspname as index_schema, \n         cons.conname as constraint_name, \n         cons.condeferrable as deferrable, \n         cons.condeferred as deferred \n  from pg_catalog.pg_constraint cons \n    join pg_catalog.pg_class tbl ON tbl.oid = cons.conrelid \n    join pg_catalog.pg_namespace ns ON ns.oid = tbl.relnamespace \n    join pg_catalog.pg_class ind ON ind.oid = cons.conindid \n    join pg_catalog.pg_namespace indschem ON indschem.oid = ind.relnamespace \n  where cons.contype = 'u'" : "  select cons.conname as index_name,  \n         cns.nspname as index_schema, \n         cons.conname as constraint_name, \n         false as deferrable, \n         false as deferred \n  from pg_catalog.pg_constraint cons  \n    join pg_catalog.pg_class tbl ON tbl.oid = cons.conrelid  \n    join pg_catalog.pg_namespace cns on cns.oid = cons.connamespace \n  where cons.contype = 'u'";
        stringBuilder.append("select *  \nfrom ( \n");
        stringBuilder.append(string2);
        stringBuilder.append(") t \nwhere (index_name, index_schema) in (");
        boolean bl = true;
        int n = 0;
        for (IndexDefinition object22 : list) {
            if (!object22.isUnique() || object22.isPrimaryKeyIndex()) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            ++n;
            object = wbConnection.getMetadata().removeQuotes(object22.getSchema());
            string = wbConnection.getMetadata().removeQuotes(object22.getObjectName());
            stringBuilder.append(" ('");
            stringBuilder.append(string);
            stringBuilder.append("', '");
            stringBuilder.append((String)object);
            stringBuilder.append("') ");
        }
        stringBuilder.append(')');
        if (n == 0) {
            return;
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "unique constraints", stringBuilder, new Object[0]);
        Object object3 = null;
        ResultSet resultSet2 = null;
        object = null;
        try {
            object = wbConnection.setSavepoint();
            object3 = wbConnection.createStatement();
            resultSet = object3.executeQuery(stringBuilder.toString());
            while (resultSet.next()) {
                string = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                boolean bl2 = resultSet.getBoolean("deferrable");
                boolean bl3 = resultSet.getBoolean("deferred");
                IndexDefinition indexDefinition = IndexDefinition.findIndex(list, string, string3);
                if (indexDefinition == null) continue;
                ConstraintDefinition constraintDefinition = ConstraintDefinition.createUniqueConstraint(string4);
                constraintDefinition.setDeferrable(bl2);
                constraintDefinition.setInitiallyDeferred(bl3);
                indexDefinition.setUniqueConstraint(constraintDefinition);
            }
            wbConnection.releaseSavepoint((Savepoint)object);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback((Savepoint)object);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "unique constraints", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet2, object3);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet2, (Statement)object3);
        }
        JdbcUtils.closeAll(resultSet, (Statement)object3);
    }
}

