/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.progress;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.TreeMap;
import workbench.db.ColumnDefinitionEnhancer;
import workbench.db.ColumnIdentifier;
import workbench.db.DBID;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.SqlUtil;

public class OpenEdgeColumnEnhancer
implements ColumnDefinitionEnhancer {
    @Override
    public void updateColumnDefinition(TableDefinition tableDefinition, WbConnection wbConnection) {
        if (Settings.getInstance().getBoolProperty("workbench.db." + DBID.OPENEDGE.getId() + ".remarks.columns.retrieve", true)) {
            this.updateColumnRemarks(tableDefinition, wbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateColumnRemarks(TableDefinition tableDefinition, WbConnection wbConnection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "select col, description \nfrom sysprogress.syscolumns_full \nwhere owner = ? \n  and tbl = ? ";
        String string2 = SqlUtil.removeObjectQuotes(tableDefinition.getTable().getTableName());
        String string3 = SqlUtil.removeObjectQuotes(tableDefinition.getTable().getSchema());
        LogMgr.logMetadataSql(new CallerInfo(){}, "column remarks", string, string3, string2);
        TreeMap<String, String> treeMap = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, string3);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                String object = resultSet.getString(2);
                if (string4 == null || object == null) continue;
                treeMap.put(string4.trim(), object);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "column remarks", string, string3, string2);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        for (ColumnIdentifier columnIdentifier : tableDefinition.getColumns()) {
            String string4 = (String)treeMap.get(SqlUtil.removeObjectQuotes(columnIdentifier.getColumnName()));
            columnIdentifier.setComment(string4);
        }
    }
}

