/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.redshift;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import workbench.db.JdbcUtils;
import workbench.db.TableGrantReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class RedshiftTableGrantReader
extends TableGrantReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuilder getTableGrantSource(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        String string = "SELECT * FROM (\nWITH objprivs AS ( \n\tSELECT objowner, \n\tschemaname, \n\tobjname, \n\tobjtype,\n\tCASE WHEN split_part(aclstring,'=',1)='' THEN 'PUBLIC' ELSE translate(trim(split_part(aclstring,'=',1)),'\"','') END::text AS grantee,\n\ttranslate(trim(split_part(aclstring,'/',2)),'\"','')::text AS grantor, \n\ttrim(split_part(split_part(aclstring,'=',2),'/',1))::text AS privilege, \n\tCASE WHEN objtype = 'default acl' THEN objname \n\tWHEN objtype = 'function' AND regexp_instr(schemaname,'[^a-z]') > 0 THEN objname\n\tWHEN objtype = 'function' THEN QUOTE_IDENT(schemaname)||'.'||objname \n\tELSE nvl(QUOTE_IDENT(schemaname)||'.'||QUOTE_IDENT(objname),QUOTE_IDENT(objname)) END::text as fullobjname,\n\tCASE WHEN split_part(aclstring,'=',1)='' THEN 'PUBLIC' \n\tELSE trim(split_part(aclstring,'=',1)) \n\tEND::text as splitgrantee,\n\tgrantseq \n\tFROM (\n\t\t-- TABLE AND VIEW privileges\n\t\tSELECT pg_get_userbyid(b.relowner)::text AS objowner, \n\t\ttrim(c.nspname)::text AS schemaname,  \n\t\tb.relname::text AS objname,\n\t\tCASE WHEN relkind='r' THEN 'table' ELSE 'view' END::text AS objtype, \n\t\tTRIM(SPLIT_PART(array_to_string(b.relacl,','), ',', NS.n))::text AS aclstring, \n\t\tNS.n as grantseq\n\t\tFROM \n\t\t(SELECT oid,generate_series(1,array_upper(relacl,1))  AS n FROM pg_class) NS\n\t\tinner join pg_class B ON b.oid = ns.oid AND  NS.n <= array_upper(b.relacl,1)\n\t\tjoin pg_namespace c on b.relnamespace = c.oid\n\t\twhere relkind in ('r','v')\n\t\tUNION ALL\n\t\t-- SCHEMA privileges\n\t\tSELECT pg_get_userbyid(b.nspowner)::text AS objowner,\n\t\tnull::text AS schemaname,\n\t\tb.nspname::text AS objname,\n\t\t'schema'::text AS objtype,\n\t\tTRIM(SPLIT_PART(array_to_string(b.nspacl,','), ',', NS.n))::text AS aclstring,\n\t\tNS.n as grantseq\n\t\tFROM \n\t\t(SELECT oid,generate_series(1,array_upper(nspacl,1)) AS n FROM pg_namespace) NS\n\t\tinner join pg_namespace B ON b.oid = ns.oid AND NS.n <= array_upper(b.nspacl,1)\n\t\tUNION ALL\n\t\t-- DATABASE privileges\n\t\tSELECT pg_get_userbyid(b.datdba)::text AS objowner,\n\t\tnull::text AS schemaname,\n\t\tb.datname::text AS objname,\n\t\t'database'::text AS objtype,\n\t\tTRIM(SPLIT_PART(array_to_string(b.datacl,','), ',', NS.n))::text AS aclstring,\n\t\tNS.n as grantseq\n\t\tFROM \n\t\t(SELECT oid,generate_series(1,array_upper(datacl,1)) AS n FROM pg_database) NS\n\t\tinner join pg_database B ON b.oid = ns.oid AND NS.n <= array_upper(b.datacl,1) \n\t\tUNION ALL\n\t\t-- FUNCTION privileges \n\t\tSELECT pg_get_userbyid(b.proowner)::text AS objowner,\n\t\ttrim(c.nspname)::text AS schemaname, \n\t\ttextin(regprocedureout(b.oid::regprocedure))::text AS objname,\n\t\t'function'::text AS objtype,\n\t\tTRIM(SPLIT_PART(array_to_string(b.proacl,','), ',', NS.n))::text AS aclstring,\n\t\tNS.n as grantseq  \n\t\tFROM \n\t\t(SELECT oid,generate_series(1,array_upper(proacl,1)) AS n FROM pg_proc) NS\n\t\tinner join pg_proc B ON b.oid = ns.oid and NS.n <= array_upper(b.proacl,1)\n\t\tjoin pg_namespace c on b.pronamespace=c.oid \n\t\tUNION ALL\n\t\t-- LANGUAGE privileges\n\t\tSELECT null::text AS objowner,\n\t\tnull::text AS schemaname,\n\t\tlanname::text AS objname,\n\t\t'language'::text AS objtype,\n\t\tTRIM(SPLIT_PART(array_to_string(b.lanacl,','), ',', NS.n))::text AS aclstring,\n\t\tNS.n as grantseq \n\t\tFROM \n\t\t(SELECT oid,generate_series(1,array_upper(lanacl,1)) AS n FROM pg_language) NS\n\t\tinner join pg_language B ON b.oid = ns.oid and NS.n <= array_upper(b.lanacl,1)\n\t\tUNION ALL\n\t\t-- DEFAULT ACL privileges\n\t\tSELECT pg_get_userbyid(b.defacluser)::text AS objowner,\n\t\ttrim(c.nspname)::text AS schemaname,\n\t\tdecode(b.defaclobjtype,'r','tables','f','functions')::text AS objname,\n\t\t'default acl'::text AS objtype,\n\t\tTRIM(SPLIT_PART(array_to_string(b.defaclacl,','), ',', NS.n))::text AS aclstring,\n\t\tNS.n as grantseq \n\t\tFROM \n\t\t(SELECT oid,generate_series(1,array_upper(defaclacl,1)) AS n FROM pg_default_acl) NS\n\t\tjoin pg_default_acl b ON b.oid = ns.oid and NS.n <= array_upper(b.defaclacl,1) \n\t\tleft join  pg_namespace c on b.defaclnamespace=c.oid\n\t) \n\twhere  (split_part(aclstring,'=',1) <> split_part(aclstring,'/',2) \n\tand split_part(aclstring,'=',1) <> 'rdsdb'\n\tand NOT (split_part(aclstring,'=',1)='' AND split_part(aclstring,'/',2) = 'rdsdb'))\n\tOR (split_part(aclstring,'=',1) = split_part(aclstring,'/',2) AND objtype='default acl')\n)\n-- Extract object GRANTS\nSELECT objowner, schemaname, objname, objtype, grantor, grantee, 'grant' AS ddltype, grantseq,\ndecode(objtype,'database',0,'schema',1,'language',1,'table',2,'view',2,'function',2,'default acl',3) AS objseq,\nCASE WHEN (grantor <> current_user AND grantor <> 'rdsdb' AND objtype <> 'default acl') THEN 'SET SESSION AUTHORIZATION '||QUOTE_IDENT(grantor)||';' ELSE '' END::text||\nCASE WHEN objtype = 'default acl' THEN 'ALTER DEFAULT PRIVILEGES for user '||QUOTE_IDENT(grantor)||nvl(' in schema '||QUOTE_IDENT(schemaname)||' ',' ')\nELSE '' END::text||(CASE WHEN privilege = 'arwdRxt' OR privilege = 'a*r*w*d*R*x*t*' THEN 'GRANT ALL on '||fullobjname||' to '||splitgrantee||\n(CASE WHEN privilege = 'a*r*w*d*R*x*t*' THEN ' with grant option;' ELSE ';' END::text) \nwhen privilege = 'UC' OR privilege = 'U*C*' THEN 'GRANT ALL on '||objtype||' '||fullobjname||' to '||splitgrantee||\n(CASE WHEN privilege = 'U*C*' THEN ' with grant option;' ELSE ';' END::text) \nwhen privilege = 'CT' OR privilege = 'U*C*' THEN 'GRANT ALL on '||objtype||' '||fullobjname||' to '||splitgrantee||\n(CASE WHEN privilege = 'C*T*' THEN ' with grant option;' ELSE ';' END::text)\nELSE  \n(\nCASE WHEN charindex('a',privilege) > 0 THEN 'GRANT INSERT on '||fullobjname||' to '||splitgrantee|| \n(CASE WHEN charindex('a*',privilege) > 0 THEN ' with grant option;' ELSE ';' END::text) ELSE '' END::text||\nCASE WHEN charindex('r',privilege) > 0 THEN 'GRANT SELECT on '||fullobjname||' to '||splitgrantee||\n(CASE WHEN charindex('r*',privilege) > 0 THEN ' with grant option;' ELSE ';' END::text) ELSE '' END::text||\nCASE WHEN charindex('w',privilege) > 0 THEN 'GRANT UPDATE on '||fullobjname||' to '||splitgrantee||\n(CASE WHEN charindex('w*',privilege) > 0 THEN ' with grant option;' ELSE ';' END::text) ELSE '' END::text||\nCASE WHEN charindex('d',privilege) > 0 THEN 'GRANT DELETE on '||fullobjname||' to '||splitgrantee||\n(CASE WHEN charindex('d*',privilege) > 0 THEN ' with grant option;' ELSE ';' END::text) ELSE '' END::text||\nCASE WHEN charindex('R',privilege) > 0 THEN 'GRANT RULE on '||fullobjname||' to '||splitgrantee||\n(CASE WHEN charindex('R*',privilege) > 0 THEN ' with grant option;' ELSE ';' END::text) ELSE '' END::text||\nCASE WHEN charindex('x',privilege) > 0 THEN 'GRANT REFERENCES on '||fullobjname||' to '||splitgrantee||\n(CASE WHEN charindex('x*',privilege) > 0 THEN ' with grant option;' ELSE ';' END::text) ELSE '' END::text||\nCASE WHEN charindex('t',privilege) > 0 THEN 'GRANT TRIGGER on '||fullobjname||' to '||splitgrantee||\n(CASE WHEN charindex('t*',privilege) > 0 THEN ' with grant option;' ELSE ';' END::text) ELSE '' END::text||\nCASE WHEN charindex('U',privilege) > 0 THEN 'GRANT USAGE on '||objtype||' '||fullobjname||' to '||splitgrantee||\n(CASE WHEN charindex('U*',privilege) > 0 THEN ' with grant option;' ELSE ';' END::text) ELSE '' END::text||\nCASE WHEN charindex('C',privilege) > 0 THEN 'GRANT CREATE on '||objtype||' '||fullobjname||' to '||splitgrantee||\n(CASE WHEN charindex('C*',privilege) > 0 THEN ' with grant option;' ELSE ';' END::text) ELSE '' END::text||\nCASE WHEN charindex('T',privilege) > 0 THEN 'GRANT TEMP on '||objtype||' '||fullobjname||' to '||splitgrantee||\n(CASE WHEN charindex('T*',privilege) > 0 THEN ' with grant option;' ELSE ';' END::text) ELSE '' END::text||\nCASE WHEN charindex('X',privilege) > 0 THEN 'GRANT EXECUTE on '||\n(CASE WHEN objtype = 'default acl' THEN '' ELSE objtype||' ' END::text)||fullobjname||' to '||splitgrantee||\n(CASE WHEN charindex('X*',privilege) > 0 THEN ' with grant option;' ELSE ';' END::text) ELSE '' END::text\n) END::text)|| \nCASE WHEN (grantor <> current_user AND grantor <> 'rdsdb' AND objtype <> 'default acl') THEN 'RESET SESSION AUTHORIZATION;' ELSE '' END::text AS ddl\nFROM objprivs\nUNION ALL\n-- Extract object REVOKES\nSELECT objowner, schemaname, objname, objtype, grantor, grantee, 'revoke'::text AS ddltype, grantseq,\ndecode(objtype,'default acl',0,'function',1,'table',1,'view',1,'schema',2,'language',2,'database',3) AS objseq,\nCASE WHEN (grantor <> current_user AND grantor <> 'rdsdb' AND objtype <> 'default acl' AND grantor <> objowner) THEN 'SET SESSION AUTHORIZATION '||QUOTE_IDENT(grantor)||';' ELSE '' END::text||\n(CASE WHEN objtype = 'default acl' THEN 'ALTER DEFAULT PRIVILEGES for user '||QUOTE_IDENT(grantor)||nvl(' in schema '||QUOTE_IDENT(schemaname)||' ',' ')\n||'REVOKE ALL on '||fullobjname||' FROM '||splitgrantee||';'\nELSE 'REVOKE ALL on '||(CASE WHEN objtype = 'table' OR objtype = 'view' THEN '' ELSE objtype||' ' END::text)||fullobjname||' FROM '||splitgrantee||';' END::text)||\nCASE WHEN (grantor <> current_user AND grantor <> 'rdsdb' AND objtype <> 'default acl' AND grantor <> objowner) THEN 'RESET SESSION AUTHORIZATION;' ELSE '' END::text AS ddl\nFROM objprivs\nWHERE NOT (objtype = 'default acl' AND grantee = 'PUBLIC' and objname='functions')\nUNION ALL\n-- Eliminate empty default ACLs\nSELECT null::text AS objowner, trim(c.nspname)::text AS schemaname, decode(b.defaclobjtype,'r','tables','f','functions')::text AS objname,\n\t\t'default acl'::text AS objtype,  pg_get_userbyid(b.defacluser)::text AS grantor, null::text AS grantee, 'revoke'::text AS ddltype, 5 as grantseq, 5 AS objseq,\n  'ALTER DEFAULT PRIVILEGES for user '||QUOTE_IDENT(pg_get_userbyid(b.defacluser))||nvl(' in schema '||QUOTE_IDENT(trim(c.nspname))||' ',' ')\n||'GRANT ALL on '||decode(b.defaclobjtype,'r','tables','f','functions')||' TO '||QUOTE_IDENT(pg_get_userbyid(b.defacluser))||\nCASE WHEN b.defaclobjtype = 'f' then ', PUBLIC;' ELSE ';' END::text AS ddl \n\t\tFROM pg_default_acl b \n\t\tLEFT JOIN  pg_namespace c on b.defaclnamespace = c.oid\n\t\twhere EXISTS (select 1 where b.defaclacl='{}'::aclitem[]\n\t\tUNION ALL\n\t\tselect 1 WHERE array_to_string(b.defaclacl,'')=('=X/'||QUOTE_IDENT(pg_get_userbyid(b.defacluser))))\n) X\nWHERE ddltype = 'grant' AND grantee <> 'PUBLIC' AND schemaname = ? AND objname = ? \nORDER BY schemaname, objname, grantseq";
        StringBuilder stringBuilder = new StringBuilder(100);
        LogMgr.logMetadataSql(new CallerInfo(){}, "table grants", string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getSchema());
            preparedStatement.setString(2, tableIdentifier.getTableName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString("ddl");
                stringBuilder.append(string2);
                stringBuilder.append("\n");
            }
        }
        catch (SQLException sQLException) {
            StringBuilder stringBuilder2;
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "table grants", string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
                stringBuilder2 = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return stringBuilder2;
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return stringBuilder;
    }
}

