/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.report;

import workbench.db.report.ForeignKeyDefinition;
import workbench.db.report.ReportTable;
import workbench.db.report.TagWriter;
import workbench.util.NumberStringCache;

public class ColumnReference {
    public static final String TAG_REFERENCE = "references";
    public static final String TAG_CONSTRAINT_NAME = "constraint-name";
    public static final String TAG_UPDATE_RULE = "update-rule";
    public static final String TAG_DELETE_RULE = "delete-rule";
    public static final String TAG_DEFER_RULE = "deferrable";
    private ForeignKeyDefinition fkDefinition;
    private String foreignColumn;
    private TagWriter tagWriter = new TagWriter();

    public ColumnReference(ForeignKeyDefinition foreignKeyDefinition) {
        this.fkDefinition = foreignKeyDefinition;
    }

    public String getFkName() {
        return this.fkDefinition.getFkName();
    }

    public void setCompareFKRule(boolean bl) {
        if (this.fkDefinition != null) {
            this.fkDefinition.setCompareFKRules(bl);
        }
    }

    public ReportTable getForeignTable() {
        return this.fkDefinition.getForeignTable();
    }

    public String getDeleteRule() {
        return this.fkDefinition.getDeleteRule();
    }

    public String getUpdateRule() {
        return this.fkDefinition.getUpdateRule();
    }

    public void setForeignColumn(String string) {
        this.foreignColumn = string;
    }

    public String getForeignColumn() {
        return this.foreignColumn;
    }

    public String toString() {
        return this.getFkName();
    }

    public StringBuilder getXml(StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder(250);
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder);
        stringBuilder3.append("  ");
        this.tagWriter.appendOpenTag(stringBuilder2, stringBuilder, TAG_REFERENCE);
        stringBuilder2.append('\n');
        stringBuilder2.append((CharSequence)this.getInnerXml(stringBuilder3));
        this.tagWriter.appendCloseTag(stringBuilder2, stringBuilder, TAG_REFERENCE);
        return stringBuilder2;
    }

    public StringBuilder getInnerXml(StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder(250);
        this.fkDefinition.getForeignTable().appendTableNameXml(stringBuilder2, stringBuilder);
        this.tagWriter.appendTag(stringBuilder2, stringBuilder, "column-name", this.foreignColumn);
        this.tagWriter.appendTag(stringBuilder2, stringBuilder, TAG_CONSTRAINT_NAME, this.getFkName());
        this.tagWriter.appendTag(stringBuilder2, stringBuilder, TAG_DELETE_RULE, this.fkDefinition.getDeleteRule(), "jdbcValue", NumberStringCache.getNumberString(this.fkDefinition.getDeleteRuleValue()));
        this.tagWriter.appendTag(stringBuilder2, stringBuilder, TAG_UPDATE_RULE, this.fkDefinition.getUpdateRule(), "jdbcValue", NumberStringCache.getNumberString(this.fkDefinition.getUpdateRuleValue()));
        this.tagWriter.appendTag(stringBuilder2, stringBuilder, TAG_DEFER_RULE, this.fkDefinition.getDeferRule(), "jdbcValue", NumberStringCache.getNumberString(this.fkDefinition.getDeferrableRuleValue()));
        return stringBuilder2;
    }

    public int hashCode() {
        int n = 3;
        n = 83 * n + (this.fkDefinition != null ? this.fkDefinition.hashCode() : 0);
        n = 83 * n + (this.foreignColumn != null ? this.foreignColumn.hashCode() : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ColumnReference) {
            return this.equals((ColumnReference)object);
        }
        return false;
    }

    public boolean isColumnEqual(ColumnReference columnReference) {
        return this.foreignColumn.equalsIgnoreCase(columnReference.foreignColumn);
    }

    public boolean isFkNameEqual(ColumnReference columnReference) {
        return this.fkDefinition.isNameEqual(columnReference.fkDefinition);
    }

    public boolean isFkDefinitionEqual(ColumnReference columnReference) {
        return this.fkDefinition.isDefinitionEqual(columnReference.fkDefinition);
    }
}

