/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.report;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import workbench.db.IndexColumn;
import workbench.db.IndexDefinition;
import workbench.db.IndexReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleIndexPartition;
import workbench.db.report.ObjectOption;
import workbench.db.report.TagAttribute;
import workbench.db.report.TagWriter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class IndexReporter {
    public static final String TAG_INDEX = "index-def";
    public static final String TAG_INDEX_NAME = "name";
    public static final String TAG_INDEX_UNIQUE = "unique";
    public static final String TAG_INDEX_PK = "primary-key";
    public static final String TAG_INDEX_TYPE = "type";
    public static final String TAG_INDEX_EXPR = "index-expression";
    public static final String TAG_INDEX_COLUMN_LIST = "column-list";
    public static final String TAG_INDEX_COLUMN_NAME = "column";
    public static final String TAG_INDEX_OPTION = "index-option";
    public static final String TAG_INDEX_COMMENT = "comment";
    public static final String TAG_INDEX_FILTER = "filter-expression";
    private List<IndexDefinition> indexList;
    private TagWriter tagWriter = new TagWriter();
    private String mainTagToUse;
    private Map<IndexDefinition, List<ObjectOption>> indexOptions = new TreeMap<IndexDefinition, List<ObjectOption>>(IndexDefinition.getNameSorter());

    public IndexReporter(TableIdentifier tableIdentifier, WbConnection wbConnection, boolean bl) {
        this.indexList = wbConnection.getMetadata().getIndexReader().getTableIndexList(tableIdentifier, true);
        Collections.sort(this.indexList, IndexDefinition.getNameSorter());
        this.removeEmptyIndexes();
        if (bl) {
            this.retrieveOracleOptions(wbConnection);
        }
        this.retrieveSourceOptions(tableIdentifier, wbConnection);
    }

    public IndexReporter(IndexDefinition indexDefinition) {
        this.indexList = new ArrayList<IndexDefinition>(1);
        this.indexList.add(indexDefinition);
    }

    public void setMainTagToUse(String string) {
        this.mainTagToUse = string;
    }

    public void appendXml(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string) {
        int n = this.indexList.size();
        if (n == 0) {
            return;
        }
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
        stringBuilder3.append("  ");
        for (IndexDefinition indexDefinition : this.indexList) {
            List<IndexColumn> list;
            this.tagWriter.appendOpenTag(stringBuilder, stringBuilder2, this.mainTagToUse == null ? TAG_INDEX : this.mainTagToUse);
            stringBuilder.append('\n');
            if (string != null && indexDefinition.isPrimaryKeyIndex()) {
                this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_INDEX_NAME, string);
            } else {
                this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_INDEX_NAME, indexDefinition.getName());
            }
            this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_INDEX_EXPR, indexDefinition.getExpression());
            this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_INDEX_UNIQUE, indexDefinition.isUnique());
            if (indexDefinition.isUniqueConstraint()) {
                this.tagWriter.appendTag(stringBuilder, stringBuilder3, "constraint-name", indexDefinition.getUniqueConstraintName());
            }
            this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_INDEX_PK, indexDefinition.isPrimaryKeyIndex());
            this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_INDEX_TYPE, indexDefinition.getIndexType());
            if (StringUtil.isNonBlank(indexDefinition.getComment())) {
                this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_INDEX_COMMENT, indexDefinition.getComment(), true);
            }
            if ((list = indexDefinition.getColumns()).size() > 0) {
                StringBuilder stringBuilder4 = new StringBuilder(stringBuilder3);
                stringBuilder4.append("  ");
                this.tagWriter.appendOpenTag(stringBuilder, stringBuilder3, TAG_INDEX_COLUMN_LIST);
                stringBuilder.append('\n');
                for (IndexColumn indexColumn : list) {
                    ArrayList<TagAttribute> arrayList = new ArrayList<TagAttribute>(2);
                    arrayList.add(new TagAttribute(TAG_INDEX_NAME, SqlUtil.removeObjectQuotes(indexColumn.getColumn())));
                    if (indexColumn.getDirection() != null) {
                        arrayList.add(new TagAttribute("direction", indexColumn.getDirection()));
                    }
                    this.tagWriter.appendOpenTag(stringBuilder, stringBuilder4, TAG_INDEX_COLUMN_NAME, arrayList, false);
                    stringBuilder.append("/>\n");
                }
                this.tagWriter.appendCloseTag(stringBuilder, stringBuilder3, TAG_INDEX_COLUMN_LIST);
            }
            if (StringUtil.isNonBlank(indexDefinition.getFilterExpression())) {
                this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_INDEX_FILTER, indexDefinition.getFilterExpression(), true);
            }
            if (StringUtil.isNonBlank(indexDefinition.getTablespace())) {
                this.tagWriter.appendTag(stringBuilder, stringBuilder3, "tablespace", indexDefinition.getTablespace(), false);
            }
            this.writeDbmsOptions(stringBuilder, stringBuilder3, indexDefinition);
            this.tagWriter.appendCloseTag(stringBuilder, stringBuilder2, this.mainTagToUse == null ? TAG_INDEX : this.mainTagToUse);
        }
    }

    private void writeDbmsOptions(StringBuilder stringBuilder, StringBuilder stringBuilder2, IndexDefinition indexDefinition) {
        List<ObjectOption> list = this.indexOptions.get(indexDefinition);
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
        stringBuilder3.append("  ");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("<index-options>\n");
        for (ObjectOption objectOption : list) {
            StringBuilder stringBuilder4 = objectOption.getXml(stringBuilder3);
            stringBuilder.append((CharSequence)stringBuilder4);
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("</index-options>\n");
    }

    private void retrieveSourceOptions(TableIdentifier tableIdentifier, WbConnection wbConnection) {
        IndexReader indexReader = wbConnection.getMetadata().getIndexReader();
        for (IndexDefinition indexDefinition : this.indexList) {
            indexReader.getIndexOptions(tableIdentifier, indexDefinition);
            Map<String, String> map = indexDefinition.getSourceOptions().getConfigSettings();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                ObjectOption objectOption = new ObjectOption(entry.getKey(), entry.getValue());
                objectOption.setWriteFlaxXML(!TagWriter.needsCData(entry.getValue()));
                this.addOption(indexDefinition, objectOption);
            }
        }
    }

    private void retrieveOracleOptions(WbConnection wbConnection) {
        if (!wbConnection.getMetadata().isOracle()) {
            return;
        }
        try {
            for (IndexDefinition indexDefinition : this.indexList) {
                OracleIndexPartition oracleIndexPartition = new OracleIndexPartition(wbConnection);
                oracleIndexPartition.retrieve(indexDefinition, wbConnection);
                if (!oracleIndexPartition.isPartitioned()) continue;
                ObjectOption objectOption = new ObjectOption("partition", oracleIndexPartition.getSourceForIndexDefinition());
                this.addOption(indexDefinition, objectOption);
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not retrieve index options", sQLException);
        }
    }

    private void addOption(IndexDefinition indexDefinition, ObjectOption objectOption) {
        List<ObjectOption> list = this.indexOptions.get(indexDefinition);
        if (list == null) {
            list = new ArrayList<ObjectOption>();
            this.indexOptions.put(indexDefinition, list);
        }
        list.add(objectOption);
    }

    public Collection<IndexDefinition> getIndexList() {
        return this.indexList;
    }

    private void removeEmptyIndexes() {
        if (this.indexList == null) {
            return;
        }
        Iterator<IndexDefinition> iterator = this.indexList.iterator();
        while (iterator.hasNext()) {
            IndexDefinition indexDefinition = iterator.next();
            if (!indexDefinition.isEmpty()) continue;
            iterator.remove();
        }
    }
}

