/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.report;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import workbench.db.ColumnIdentifier;
import workbench.db.DependencyNode;
import workbench.db.IndexDefinition;
import workbench.db.ReaderFactory;
import workbench.db.TableCommentReader;
import workbench.db.TableConstraint;
import workbench.db.TableDefinition;
import workbench.db.TableDependency;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.TableSourceBuilderFactory;
import workbench.db.TriggerDefinition;
import workbench.db.TriggerReaderFactory;
import workbench.db.WbConnection;
import workbench.db.oracle.AbstractOraclePartition;
import workbench.db.oracle.OracleTablePartition;
import workbench.db.oracle.OracleUtils;
import workbench.db.postgres.PostgresPartitionReader;
import workbench.db.postgres.PostgresUtil;
import workbench.db.report.ColumnReference;
import workbench.db.report.ForeignKeyDefinition;
import workbench.db.report.IndexReporter;
import workbench.db.report.ObjectOption;
import workbench.db.report.ReportColumn;
import workbench.db.report.ReportTableGrants;
import workbench.db.report.ReportTrigger;
import workbench.db.report.TagAttribute;
import workbench.db.report.TagWriter;
import workbench.db.sqltemplates.ConstraintNameTester;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class ReportTable {
    public static final String TAG_TABLE_DEF = "table-def";
    public static final String TAG_TABLE_NAME = "table-name";
    public static final String TAG_TABLE_OWNER = "table-owner";
    public static final String TAG_TABLE_CATALOG = "table-catalog";
    public static final String TAG_TABLE_SCHEMA = "table-schema";
    public static final String TAG_TABLE_COMMENT = "table-comment";
    public static final String TAG_TABLE_PK_NAME = "primary-key-name";
    public static final String TAG_TABLE_CONSTRAINTS = "table-constraints";
    public static final String TAG_CONSTRAINT_DEF = "constraint-definition";
    public static final String TAG_CONSTRAINT_COMMENT = "constraint-comment";
    public static final String TAG_TABLESPACE = "tablespace";
    public static final String TAG_TABLE_TYPE = "table-type";
    private TableIdentifier table;
    private Map<String, ForeignKeyDefinition> foreignKeys = new TreeMap<String, ForeignKeyDefinition>();
    private List<ReportColumn> columns;
    private IndexReporter indexReporter;
    private String tableComment;
    private TagWriter tagWriter = new TagWriter();
    private String schemaNameToUse;
    private boolean includePrimaryKey = true;
    private boolean includePartitions;
    private List<TableConstraint> tableConstraints;
    private List<TriggerDefinition> triggers;
    private ReportTableGrants grants;
    private final List<ObjectOption> dbmsOptions = new ArrayList<ObjectOption>();
    private boolean fixDefaultValues;
    private boolean generatePKName;
    private ConstraintNameTester nameTester;
    private int maxIdentifierLength;

    public ReportTable(TableIdentifier tableIdentifier, WbConnection wbConnection, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) throws SQLException {
        Object object;
        Object object2;
        this.includePrimaryKey = bl3;
        this.includePartitions = bl7;
        this.fixDefaultValues = !wbConnection.getDbSettings().returnsValidDefaultExpressions();
        this.nameTester = new ConstraintNameTester(wbConnection.getDbId());
        this.maxIdentifierLength = wbConnection.getMetadata().getMaxTableNameLength();
        TableDefinition tableDefinition = wbConnection.getMetadata().getTableDefinition(tableIdentifier);
        this.table = tableDefinition.getTable();
        this.table.checkQuotesNeeded(wbConnection);
        List<ColumnIdentifier> list = tableDefinition.getColumns();
        Collections.sort(list);
        if (this.table.commentIsDefined()) {
            this.tableComment = this.table.getComment();
        } else {
            object2 = new TableCommentReader();
            this.tableComment = ((TableCommentReader)object2).getTableComment(wbConnection, this.table);
        }
        object2 = this.table.getSchema();
        if ((object2 == null || ((String)object2).length() == 0) && (object2 = wbConnection.getMetadata().getSchemaToUse()) != null) {
            this.table.setSchema((String)object2);
        }
        this.setColumns(list);
        if (bl) {
            this.indexReporter = new IndexReporter(this.table, wbConnection, bl7);
        }
        if (bl2) {
            this.readForeignKeys(wbConnection);
        }
        if (bl4) {
            object = ReaderFactory.getConstraintReader(wbConnection.getMetadata());
            this.tableConstraints = object.getTableConstraints(wbConnection, tableDefinition);
        }
        if (bl5) {
            this.grants = new ReportTableGrants(wbConnection, this.table);
        }
        if (bl6) {
            object = TriggerReaderFactory.createReader(wbConnection);
            try {
                this.triggers = object.getTriggerList(this.table.getCatalog(), this.table.getSchema(), this.table.getTableName());
                if (this.triggers != null) {
                    for (TriggerDefinition triggerDefinition : this.triggers) {
                        triggerDefinition.setSource(object.getTriggerSource(triggerDefinition, false));
                    }
                }
            }
            catch (SQLException sQLException) {
                LogMgr.logError(new CallerInfo(){}, "Could not retrieve table triggers", sQLException);
                this.triggers = null;
            }
        }
        this.retrieveOptions(wbConnection);
    }

    public ReportTable(TableIdentifier tableIdentifier) {
        this.table = tableIdentifier;
    }

    public void setGeneratePKName(boolean bl) {
        this.generatePKName = bl;
    }

    public boolean grantsIncluded() {
        return this.grants != null;
    }

    public List<ObjectOption> getDbmsOptions() {
        return Collections.unmodifiableList(this.dbmsOptions);
    }

    private List<ColumnIdentifier> getColumnList() {
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(this.columns.size());
        for (ReportColumn reportColumn : this.columns) {
            arrayList.add(reportColumn.getColumn());
        }
        return arrayList;
    }

    private void retrieveOptions(WbConnection wbConnection) throws SQLException {
        Map<String, String> map;
        TableSourceBuilder tableSourceBuilder = TableSourceBuilderFactory.getBuilder(wbConnection);
        if (this.includePartitions && OracleUtils.supportsPartitioning(wbConnection)) {
            map = new OracleTablePartition(wbConnection);
            ((AbstractOraclePartition)((Object)map)).retrieve(this.table, wbConnection);
            if (((AbstractOraclePartition)((Object)map)).isPartitioned()) {
                String string = ((AbstractOraclePartition)((Object)map)).getSourceForTableDefinition();
                ObjectOption object = new ObjectOption("partition", string);
                this.dbmsOptions.add(object);
            }
            tableSourceBuilder.setIncludePartitions(false);
        } else if (this.includePartitions && PostgresUtil.supportsPartitioning(wbConnection)) {
            map = new PostgresPartitionReader(this.table, wbConnection);
            ((PostgresPartitionReader)((Object)map)).readPartitionInformation();
            this.dbmsOptions.add(new ObjectOption("partition_strategy", ((PostgresPartitionReader)((Object)map)).getStrategy()));
            this.dbmsOptions.add(new ObjectOption("partition_expression", ((PostgresPartitionReader)((Object)map)).getPartitionExpression()));
            this.dbmsOptions.add(new ObjectOption("partition_definition", ((PostgresPartitionReader)((Object)map)).getPartitionDefinition()));
            this.dbmsOptions.add(new ObjectOption("partitions", ((PostgresPartitionReader)((Object)map)).getCreatePartitions()));
        } else {
            tableSourceBuilder.setIncludePartitions(this.includePartitions);
        }
        tableSourceBuilder.readTableOptions(this.table, this.getColumnList());
        map = this.table.getSourceOptions().getConfigSettings();
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                ObjectOption objectOption = new ObjectOption((String)entry.getKey(), (String)entry.getValue());
                objectOption.setWriteFlaxXML(true);
                this.dbmsOptions.add(objectOption);
            }
        }
    }

    public List<TriggerDefinition> getTriggers() {
        return this.triggers;
    }

    public ReportTableGrants getGrants() {
        return this.grants;
    }

    public List<String> getPrimaryKeyColumns() {
        if (!this.includePrimaryKey) {
            return Collections.emptyList();
        }
        if (this.table.getPrimaryKey() == null) {
            return Collections.emptyList();
        }
        return this.table.getPrimaryKey().getColumns();
    }

    public String getPrimaryKeyName() {
        if (!this.includePrimaryKey) {
            return null;
        }
        if (this.table.getPrimaryKey() == null) {
            return null;
        }
        String string = this.table.getPrimaryKeyName();
        if (this.generatePKName && this.nameTester.isSystemConstraintName(string)) {
            string = this.nameTester.generatePKName(this.table, this.maxIdentifierLength);
        }
        return string;
    }

    public final void setColumns(List<ColumnIdentifier> list) {
        if (list == null) {
            return;
        }
        int n = list.size();
        this.columns = new ArrayList<ReportColumn>(n);
        for (ColumnIdentifier columnIdentifier : list) {
            ReportColumn reportColumn = new ReportColumn(columnIdentifier);
            reportColumn.setFixDefaultValue(this.fixDefaultValues);
            this.columns.add(reportColumn);
        }
    }

    private void readForeignKeys(WbConnection wbConnection) {
        TableDependency tableDependency = new TableDependency(wbConnection, this.table);
        List<DependencyNode> list = tableDependency.getOutgoingForeignKeys();
        for (DependencyNode dependencyNode : list) {
            ForeignKeyDefinition foreignKeyDefinition = new ForeignKeyDefinition(dependencyNode);
            foreignKeyDefinition.setCompareFKRules(true);
            TableIdentifier tableIdentifier = dependencyNode.getTable().createCopy();
            if (tableIdentifier.getSchema() == null) {
                tableIdentifier.setSchema(this.table.getSchema());
            }
            if (tableIdentifier.getCatalog() == null) {
                tableIdentifier.setCatalog(this.table.getCatalog());
            }
            foreignKeyDefinition.setForeignTable(new ReportTable(tableIdentifier));
            Map<String, String> map = dependencyNode.getColumns();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                ReportColumn reportColumn = this.findColumn(entry.getValue());
                if (reportColumn == null) continue;
                ColumnReference columnReference = new ColumnReference(foreignKeyDefinition);
                columnReference.setForeignColumn(entry.getKey());
                reportColumn.setForeignKeyReference(columnReference);
            }
            this.foreignKeys.put(dependencyNode.getFkName(), foreignKeyDefinition);
        }
    }

    public Map<String, ForeignKeyDefinition> getForeignKeys() {
        return this.foreignKeys;
    }

    public ReportColumn findColumn(String string) {
        return ReportTable.findColumn(this.columns, string);
    }

    public static ReportColumn findColumn(List<ReportColumn> list, String string) {
        if (string == null) {
            return null;
        }
        if (list == null) {
            return null;
        }
        ReportColumn reportColumn = null;
        for (ReportColumn reportColumn2 : list) {
            if (!string.equalsIgnoreCase(reportColumn2.getColumn().getColumnName())) continue;
            reportColumn = reportColumn2;
            break;
        }
        return reportColumn;
    }

    public Collection<IndexDefinition> getIndexList() {
        if (this.indexReporter == null) {
            return null;
        }
        return this.indexReporter.getIndexList();
    }

    public List<ReportColumn> getColumnsSorted() {
        Comparator comparator = (reportColumn, reportColumn2) -> {
            int n = reportColumn.getColumn().getPosition();
            int n2 = reportColumn2.getColumn().getPosition();
            return n - n2;
        };
        ArrayList<ReportColumn> arrayList = new ArrayList<ReportColumn>(this.columns.size());
        arrayList.addAll(this.columns);
        arrayList.sort(comparator);
        return arrayList;
    }

    public List<ReportColumn> getColumns() {
        return new ArrayList<ReportColumn>(this.columns);
    }

    public TableIdentifier getTable() {
        return this.table;
    }

    public void setSchemaNameToUse(String string) {
        this.schemaNameToUse = string;
    }

    public void writeXml(Writer writer) throws IOException {
        StringBuilder stringBuilder = this.getXml();
        writer.append(stringBuilder);
    }

    public StringBuilder getXml() {
        return this.getXml(new StringBuilder("  "));
    }

    public String toString() {
        return this.table.toString();
    }

    public String getTableComment() {
        return this.tableComment;
    }

    public List<TableConstraint> getTableConstraints() {
        return this.tableConstraints;
    }

    public void appendTableNameXml(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        this.tagWriter.appendTag(stringBuilder, stringBuilder2, TAG_TABLE_CATALOG, SqlUtil.removeObjectQuotes(this.table.getCatalog()));
        this.tagWriter.appendTag(stringBuilder, stringBuilder2, TAG_TABLE_SCHEMA, StringUtil.isBlank(this.schemaNameToUse) ? SqlUtil.removeObjectQuotes(this.table.getSchema()) : this.schemaNameToUse);
        this.tagWriter.appendTag(stringBuilder, stringBuilder2, TAG_TABLE_NAME, SqlUtil.removeObjectQuotes(this.table.getTableName()));
        String string = this.table.getOwner();
        if (string != null) {
            this.tagWriter.appendTag(stringBuilder, stringBuilder2, TAG_TABLE_OWNER, SqlUtil.removeObjectQuotes(string));
        }
    }

    public StringBuilder getXml(StringBuilder stringBuilder) {
        Object object;
        Object object2;
        StringBuilder stringBuilder2 = new StringBuilder(500);
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder);
        stringBuilder3.append("  ");
        String string = this.table.getType();
        if (!"TABLE".equalsIgnoreCase(string)) {
            object2 = new String[]{"name", "type"};
            object = new String[]{SqlUtil.removeObjectQuotes(this.table.getTableName()), string};
            this.tagWriter.appendOpenTag(stringBuilder2, stringBuilder, TAG_TABLE_DEF, (String[])object2, (String[])object);
        } else {
            this.tagWriter.appendOpenTag(stringBuilder2, stringBuilder, TAG_TABLE_DEF, "name", SqlUtil.removeObjectQuotes(this.table.getTableName()));
        }
        stringBuilder2.append('\n');
        this.appendTableNameXml(stringBuilder2, stringBuilder3);
        this.tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_TABLE_PK_NAME, this.getPrimaryKeyName(), false);
        this.tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_TABLE_COMMENT, this.tableComment, true);
        if (StringUtil.isNonBlank(this.table.getTablespace())) {
            this.tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_TABLESPACE, this.table.getTablespace(), false);
        }
        if (StringUtil.isNonBlank((CharSequence)(object2 = this.table.getSourceOptions().getTypeModifier()))) {
            this.tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_TABLE_TYPE, (CharSequence)object2, false);
        }
        for (ReportColumn iterator : this.columns) {
            iterator.appendXml(stringBuilder2, stringBuilder3);
        }
        if (this.indexReporter != null) {
            this.indexReporter.appendXml(stringBuilder2, stringBuilder3, this.generatePKName ? this.getPrimaryKeyName() : null);
        }
        ReportTable.writeConstraints(this.tableConstraints, this.tagWriter, stringBuilder2, stringBuilder3);
        if (this.foreignKeys.size() > 0) {
            this.tagWriter.appendOpenTag(stringBuilder2, stringBuilder3, "foreign-keys");
            stringBuilder2.append('\n');
            object = new StringBuilder(stringBuilder3);
            ((StringBuilder)object).append("  ");
            for (ForeignKeyDefinition foreignKeyDefinition : this.foreignKeys.values()) {
                stringBuilder2.append((CharSequence)foreignKeyDefinition.getXml((StringBuilder)object));
            }
            this.tagWriter.appendCloseTag(stringBuilder2, stringBuilder3, "foreign-keys");
        }
        if (this.grants != null) {
            this.grants.appendXml(stringBuilder2, stringBuilder3);
        }
        if (this.triggers != null) {
            for (TriggerDefinition triggerDefinition : this.triggers) {
                ReportTrigger reportTrigger = new ReportTrigger(triggerDefinition);
                reportTrigger.setIndent(stringBuilder3);
                stringBuilder2.append((CharSequence)reportTrigger.getXml());
            }
        }
        this.writeDBMSOptions(stringBuilder2, stringBuilder);
        this.tagWriter.appendCloseTag(stringBuilder2, stringBuilder, TAG_TABLE_DEF);
        return stringBuilder2;
    }

    private void writeDBMSOptions(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        if (CollectionUtil.isEmpty(this.dbmsOptions) && StringUtil.isEmptyString(this.table.getSourceOptions().getAdditionalSql())) {
            return;
        }
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
        stringBuilder3.append("  ");
        stringBuilder.append((CharSequence)stringBuilder3);
        stringBuilder.append("<table-options>\n");
        StringBuilder stringBuilder4 = new StringBuilder(stringBuilder3);
        stringBuilder4.append("  ");
        for (ObjectOption objectOption : this.dbmsOptions) {
            StringBuilder stringBuilder5 = objectOption.getXml(stringBuilder4);
            stringBuilder.append((CharSequence)stringBuilder5);
        }
        if (StringUtil.isNonEmpty(this.table.getSourceOptions().getAdditionalSql())) {
            this.tagWriter.appendCDATATag(stringBuilder, stringBuilder4, "additional-sql", (CharSequence)this.table.getSourceOptions().getAdditionalSql(), new TagAttribute[0]);
        }
        stringBuilder.append((CharSequence)stringBuilder3);
        stringBuilder.append("</table-options>\n");
    }

    public static void writeConstraints(List<TableConstraint> list, TagWriter tagWriter, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        if (list != null && list.size() > 0) {
            tagWriter.appendOpenTag(stringBuilder, stringBuilder2, TAG_TABLE_CONSTRAINTS);
            stringBuilder.append('\n');
            StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
            stringBuilder3.append("  ");
            for (TableConstraint tableConstraint : list) {
                ReportTable.writeConstraint(tableConstraint, tagWriter, stringBuilder, stringBuilder3);
            }
            tagWriter.appendCloseTag(stringBuilder, stringBuilder2, TAG_TABLE_CONSTRAINTS);
        }
    }

    public static void writeConstraint(TableConstraint tableConstraint, TagWriter tagWriter, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        if (tableConstraint == null) {
            return;
        }
        String string = tableConstraint.getConstraintName();
        String string2 = tableConstraint.getExpression();
        String string3 = Boolean.toString(tableConstraint.isSystemName());
        TagAttribute tagAttribute = new TagAttribute("type", tableConstraint.getConstraintType().name().toLowerCase());
        TagAttribute tagAttribute2 = null;
        TagAttribute tagAttribute3 = null;
        if (string != null) {
            tagAttribute3 = new TagAttribute("name", string);
            tagAttribute2 = new TagAttribute("generated-name", string3);
        }
        tagWriter.appendCDATATag(stringBuilder, stringBuilder2, TAG_CONSTRAINT_DEF, (CharSequence)string2, tagAttribute, tagAttribute2, tagAttribute3);
        if (StringUtil.isNonBlank(tableConstraint.getComment())) {
            tagWriter.appendTag(stringBuilder, stringBuilder2, TAG_CONSTRAINT_COMMENT, tableConstraint.getComment());
        }
    }

    public void done() {
        this.columns = null;
    }

    public int hashCode() {
        int n = 119 + (this.table != null ? this.table.hashCode() : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof ReportTable) {
            return this.equals((ReportTable)object);
        }
        return false;
    }

    public boolean equals(ReportTable reportTable) {
        if (reportTable == null) {
            return false;
        }
        return SqlUtil.objectNamesAreEqual(this.table, reportTable.table, false);
    }
}

