/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.report;

import java.util.Collection;
import java.util.Collections;
import workbench.db.TableGrant;
import workbench.db.TableGrantReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.report.TagWriter;

public class ReportTableGrants {
    public static final String TAG_GRANT = "grant";
    public static final String TAG_GRANT_GRANTEE = "grantee";
    public static final String TAG_GRANT_PRIV = "privilege";
    public static final String TAG_GRANT_GRANTABLE = "grantable";
    private Collection<TableGrant> grants;

    public ReportTableGrants(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        TableGrantReader tableGrantReader = TableGrantReader.createReader(wbConnection);
        this.grants = tableGrantReader.getTableGrants(wbConnection, tableIdentifier);
    }

    public ReportTableGrants(Collection<TableGrant> collection) {
        this.grants = collection;
    }

    public void appendXml(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        if (this.grants.isEmpty()) {
            return;
        }
        TagWriter tagWriter = new TagWriter();
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
        stringBuilder3.append("  ");
        for (TableGrant tableGrant : this.grants) {
            tagWriter.appendOpenTag(stringBuilder, stringBuilder2, TAG_GRANT);
            stringBuilder.append('\n');
            tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_GRANT_PRIV, tableGrant.getPrivilege());
            tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_GRANT_GRANTEE, tableGrant.getGrantee());
            tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_GRANT_GRANTABLE, tableGrant.isGrantable());
            tagWriter.appendCloseTag(stringBuilder, stringBuilder2, TAG_GRANT);
        }
    }

    public Collection<TableGrant> getGrants() {
        return Collections.unmodifiableCollection(this.grants);
    }
}

