/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.search;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import workbench.db.CatalogChanger;
import workbench.db.DbObject;
import workbench.db.ProcedureDefinition;
import workbench.db.ProcedureReader;
import workbench.db.TableIdentifier;
import workbench.db.TriggerDefinition;
import workbench.db.TriggerReader;
import workbench.db.TriggerReaderFactory;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.RowActionMonitor;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class ObjectSourceSearcher {
    private List<String> schemas;
    private Set<String> types;
    private List<String> names;
    private WbConnection connection;
    private List<DbObject> searchResult;
    private RowActionMonitor monitor;
    private boolean cancelSearch;
    private boolean isRunning;
    private int numSearched;
    private Set<String> searchedObjects;
    private String catalog;
    private CatalogChanger catalogChanger = new CatalogChanger();

    public ObjectSourceSearcher(WbConnection wbConnection) {
        this.connection = wbConnection;
        this.schemas = CollectionUtil.arrayList();
        this.names = CollectionUtil.arrayList();
        this.types = CollectionUtil.caseInsensitiveSet("trigger", "procedure", "function", "view");
        if (wbConnection.getMetadata().supportsMaterializedViews()) {
            this.types.add(wbConnection.getMetadata().getMViewTypeName().toLowerCase());
        }
        this.searchedObjects = CollectionUtil.caseInsensitiveSet();
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public int getNumberOfObjectsSearched() {
        return this.numSearched;
    }

    public void setRowMonitor(RowActionMonitor rowActionMonitor) {
        this.monitor = rowActionMonitor;
    }

    public void cancelSearch() {
        this.cancelSearch = true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getSearchSchemaCount() {
        return this.schemas.size();
    }

    public void setTypesToSearch(List<String> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        this.types.clear();
        this.types.addAll(list);
    }

    public void setSchemasToSearch(List<String> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        this.schemas.clear();
        for (String string : list) {
            String string2 = this.connection.getMetadata().adjustSchemaNameCase(string);
            this.schemas.add(string2);
        }
    }

    public void setNamesToSearch(List<String> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        this.names.clear();
        for (String string : list) {
            String string2 = this.connection.getMetadata().adjustObjectnameCase(string);
            this.names.add(string2);
        }
    }

    private boolean typeIncluded(String string, Collection<String> collection) {
        if (collection.contains("%")) {
            return true;
        }
        if (collection.contains("*")) {
            return true;
        }
        return collection.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<DbObject> searchObjects(List<String> list, boolean bl, boolean bl2, boolean bl3) {
        this.searchedObjects.clear();
        this.cancelSearch = false;
        this.isRunning = true;
        this.numSearched = 0;
        String string = this.connection.getMetadata().getCurrentCatalog();
        boolean bl4 = false;
        try {
            List<DbObject> list2;
            if (this.connection.getDbSettings().supportsCatalogs()) {
                bl4 = this.changeCatalog(this.catalog);
            }
            this.searchResult = CollectionUtil.sizedArrayList(50);
            if (CollectionUtil.isEmpty(this.schemas)) {
                this.schemas = CollectionUtil.arrayList(this.connection.getCurrentSchema());
            }
            if (CollectionUtil.isEmpty(this.names)) {
                this.names = CollectionUtil.arrayList("%");
            }
            Set<String> set = CollectionUtil.caseInsensitiveSet();
            set.addAll(this.types);
            if (this.typeIncluded("trigger", set)) {
                list2 = this.retrieveTriggers();
                if (this.cancelSearch) {
                    List<DbObject> list3 = null;
                    return list3;
                }
                set.remove("trigger");
                this.searchList(list2, list, bl, bl2, bl3);
            }
            if (this.cancelSearch) {
                list2 = null;
                return list2;
            }
            if (this.typeIncluded("procedure", set) || this.typeIncluded("function", set)) {
                list2 = this.retrieveProcedures();
                if (this.cancelSearch) {
                    List<DbObject> list4 = null;
                    return list4;
                }
                set.remove("procedure");
                set.remove("function");
                this.searchList(list2, list, bl, bl2, bl3);
            }
            if (this.cancelSearch) {
                list2 = null;
                return list2;
            }
            if (set.size() > 0) {
                if (set.contains("*") || set.contains("%")) {
                    set.clear();
                    set.addAll(this.connection.getMetadata().getObjectTypes());
                }
                list2 = this.retrieveObjects(set);
                this.searchList(list2, list, bl, bl2, bl3);
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving objects", sQLException);
        }
        finally {
            this.isRunning = false;
            if (bl4) {
                this.changeCatalog(string);
            }
        }
        return this.searchResult;
    }

    private boolean changeCatalog(String string) {
        if (string == null) {
            return false;
        }
        try {
            return this.catalogChanger.setCurrentCatalog(this.connection, string);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not change catalot to: " + string, exception);
            return false;
        }
    }

    private void searchList(List<DbObject> list, List<String> list2, boolean bl, boolean bl2, boolean bl3) {
        if (this.monitor != null) {
            this.monitor.setMonitorType(6);
        }
        int n = list.size();
        int n2 = 1;
        for (DbObject dbObject : list) {
            ++this.numSearched;
            if (this.cancelSearch) {
                return;
            }
            if (this.monitor != null) {
                this.monitor.setCurrentObject(dbObject.getObjectName(), n2, n);
            }
            try {
                String string;
                CharSequence charSequence = null;
                if (this.connection.getMetadata().isTableType(dbObject.getObjectType())) {
                    ((TableIdentifier)dbObject).setRetrieveFkSource(true);
                }
                ProcedureDefinition procedureDefinition = null;
                if (dbObject instanceof ProcedureDefinition) {
                    procedureDefinition = (ProcedureDefinition)dbObject;
                }
                if (!this.searchedObjects.contains(string = this.getObjectKey(dbObject))) {
                    charSequence = dbObject.getSource(this.connection);
                    if (StringUtil.isBlank(charSequence)) {
                        LogMgr.logWarning(new CallerInfo(){}, "Empty source returned for " + dbObject.toString());
                    }
                    if (StringUtil.containsWords(charSequence, list2, bl, bl2, bl3)) {
                        this.searchResult.add(dbObject);
                    }
                    this.searchedObjects.add(string);
                }
            }
            catch (SQLException sQLException) {
                LogMgr.logError(new CallerInfo(){}, "Error retrieving object source", sQLException);
            }
            ++n2;
        }
    }

    private List<DbObject> retrieveProcedures() throws SQLException {
        if (this.monitor != null) {
            this.monitor.setMonitorType(7);
            this.monitor.setCurrentObject(ResourceMgr.getString("MsgRetrievingProcedures"), -1L, -1L);
        }
        List<DbObject> list = CollectionUtil.sizedArrayList(50);
        ProcedureReader procedureReader = this.connection.getMetadata().getProcedureReader();
        if (procedureReader == null) {
            return list;
        }
        for (String string : this.schemas) {
            for (String string2 : this.names) {
                if (this.cancelSearch) {
                    return null;
                }
                List<ProcedureDefinition> list2 = procedureReader.getProcedureList(null, string, string2);
                list.addAll(list2);
            }
        }
        return list;
    }

    private List<DbObject> retrieveTriggers() throws SQLException {
        if (this.monitor != null) {
            this.monitor.setMonitorType(7);
            this.monitor.setCurrentObject(ResourceMgr.getString("MsgRetrievingTriggers"), -1L, -1L);
        }
        TriggerReader triggerReader = TriggerReaderFactory.createReader(this.connection);
        List<DbObject> list = CollectionUtil.sizedArrayList(50);
        for (String string : this.schemas) {
            if (this.cancelSearch) {
                return null;
            }
            List<TriggerDefinition> list2 = triggerReader.getTriggerList(null, string, null);
            list.addAll(list2);
        }
        return list;
    }

    private List<DbObject> retrieveObjects(Set<String> set) throws SQLException {
        if (this.monitor != null) {
            this.monitor.setMonitorType(7);
            this.monitor.setCurrentObject(ResourceMgr.getString("MsgRetrievingTables"), -1L, -1L);
        }
        List<DbObject> list = CollectionUtil.sizedArrayList(50);
        String[] stringArray = new String[set.size()];
        int n = 0;
        for (String string : set) {
            if (string == null) continue;
            stringArray[n] = string.toUpperCase();
            ++n;
        }
        for (String string : this.schemas) {
            for (String string2 : this.names) {
                if (this.cancelSearch) {
                    return null;
                }
                List<TableIdentifier> list2 = this.connection.getMetadata().getObjectList(string2, string, stringArray);
                list.addAll(list2);
            }
        }
        return list;
    }

    private String getObjectKey(DbObject dbObject) {
        ProcedureDefinition procedureDefinition;
        if (dbObject instanceof ProcedureDefinition && (procedureDefinition = (ProcedureDefinition)dbObject).isPackageProcedure()) {
            return procedureDefinition.getSchema() + "." + procedureDefinition.getPackageName();
        }
        return dbObject.getObjectNameForDrop(this.connection);
    }
}

