/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.search;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Set;
import workbench.db.exporter.TextRowDataConverter;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.filter.ColumnComparator;
import workbench.storage.filter.ColumnExpression;
import workbench.storage.filter.ContainsComparator;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;

public class RowDataSearcher {
    private ColumnExpression filterExpression;
    private TextRowDataConverter converter;
    private final Set<String> columns = CollectionUtil.caseInsensitiveSet();
    private String blobEncoding;

    public RowDataSearcher(String string, ColumnComparator columnComparator, boolean bl) {
        if (columnComparator == null) {
            columnComparator = new ContainsComparator();
        }
        this.filterExpression = new ColumnExpression(columnComparator, string);
        this.filterExpression.setIgnoreCase(bl);
        this.converter = new TextRowDataConverter();
    }

    public void setBlobTextEncoding(String string) {
        this.blobEncoding = string;
    }

    public ColumnExpression getExpression() {
        ColumnExpression columnExpression = new ColumnExpression(this.filterExpression.getComparator(), this.filterExpression.getFilterValue());
        columnExpression.setIgnoreCase(this.filterExpression.isIgnoreCase());
        return columnExpression;
    }

    public boolean isSearchStringContained(RowData rowData, ResultInfo resultInfo, boolean bl) {
        for (int i = 0; i < rowData.getColumnCount(); ++i) {
            if (!this.searchColumn(resultInfo.getColumnName(i))) continue;
            boolean bl2 = SqlUtil.isBlobType(resultInfo.getColumnType(i));
            String string = null;
            if (this.blobEncoding != null && bl2) {
                Object object = rowData.getValue(i);
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    try {
                        string = new String(byArray, this.blobEncoding);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = null;
                    }
                }
            } else if (!bl2) {
                string = this.converter.getValueAsFormattedString(rowData, i);
            }
            if (this.filterExpression.evaluate(string)) {
                return true;
            }
            if (!bl) continue;
            rowData.setValue(i, null);
        }
        return false;
    }

    public void setColumnsToSearch(Collection<String> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            this.columns.clear();
        } else {
            this.columns.addAll(collection);
        }
    }

    private boolean searchColumn(String string) {
        if (this.columns.isEmpty()) {
            return true;
        }
        return this.columns.contains(string);
    }
}

