/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.sqltemplates;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.TableIdentifier;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class ConstraintNameTester {
    private Pattern sysNamePattern;

    public ConstraintNameTester(String string) {
        String string2 = Settings.getInstance().getProperty("workbench.db." + string + ".constraints.systemname", null);
        if (StringUtil.isNonEmpty(string2)) {
            try {
                this.sysNamePattern = Pattern.compile(string2);
            }
            catch (Exception exception) {
                this.sysNamePattern = null;
                LogMgr.logError(new CallerInfo(){}, "Error in regex", exception);
            }
        }
    }

    public String generatePKName(TableIdentifier tableIdentifier, int n) {
        if (tableIdentifier == null) {
            return null;
        }
        String string = "pk_" + SqlUtil.cleanupIdentifier(tableIdentifier.getTableName().toLowerCase());
        if (n > 0 && string.length() > n) {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    public boolean isSystemConstraintName(String string) {
        if (string == null) {
            return false;
        }
        if (this.sysNamePattern == null) {
            return false;
        }
        Matcher matcher = this.sysNamePattern.matcher(string);
        return matcher.matches();
    }
}

