/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.vertica;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;

public class VerticaProjectionReader {
    private WbConnection dbConnection;

    public void setConnection(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataStore getProjectionList(TableIdentifier tableIdentifier) throws SQLException {
        DataStore dataStore;
        if ("VIEW".equals(tableIdentifier.getType())) {
            return null;
        }
        String string = "SELECT projection_basename as basename, \n       decode(is_super_projection,true,'super') as is_super, \n       decode(is_segmented,true,'segmented',false,'replicated') as is_segmented, \n       decode(is_prejoin,true,'prejoin') as is_prejoin, \n       decode(is_up_to_date,true,'up to date',false,'stale') as is_up_to_date, \n       decode(has_statistics,true,'has stats',false,'no stats') as has_statistics, \n       verified_fault_tolerance, \n       count(*) \nFROM projections \nWHERE anchor_table_name = ? \n  AND projection_schema = ? \ngroup by 1,2,3,4,5,6,7 \nORDER BY 2, projection_basename";
        LogMgr.logMetadataSql(new CallerInfo(){}, "projections", string, new Object[0]);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            DataStore dataStore2;
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getTableName());
            preparedStatement.setString(2, tableIdentifier.getSchema());
            resultSet = preparedStatement.executeQuery();
            dataStore = dataStore2 = new DataStore(resultSet, true);
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "projections", string, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return null;
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataStore getProjectionCopies(String string, String string2) throws SQLException {
        DataStore dataStore;
        String string3 = "SELECT p.projection_name as name, \n       decode(p.node_name,null,ps.node_name,'',ps.node_name,p.node_name) as node, \n       p.created_epoch, \n       ps.projection_column_count as columns, \n       ps.ros_count as ROSes, \n       ps.wos_row_count as wos_rows, \n       ps.ros_row_count as ros_rows, \n       round(ps.wos_used_bytes/1024/1024,2) as wos_mb, \n       round(ps.ros_used_bytes/1024/1024,2) as ros_mb \nFROM projections p \n  left outer join projection_storage ps using (projection_id) \nWHERE decode(p.node_name,null,ps.node_name,'',ps.node_name,p.node_name) = ps.node_name \n  and p.projection_basename = ? \n  and p.projection_schema = ? \nORDER BY p.projection_name, node ";
        LogMgr.logMetadataSql(new CallerInfo(){}, "projection copies", string3, new Object[0]);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            DataStore dataStore2;
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            dataStore = dataStore2 = new DataStore(resultSet, true);
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "projection copies", string3, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return null;
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataStore getProjectionColumns(String string, String string2) throws SQLException {
        DataStore dataStore;
        String string3 = "SELECT pc.column_position, \n       pc.projection_column_name, \n       decode(pc.projection_column_name,pc.table_column_name,'',pc.table_column_name) as table_column_name, \n       pc.sort_position, \n       pc.data_type, \n       pc.encoding_type, \n       pc.access_rank, \n       pc.group_id, \n       round(sum(used_bytes)/1024/1024,2) as mb_total, \n       sum(ros_count) as ros_total, \n       round(avg(used_bytes)/1024/1024,2) as mb_per_node, \n       avg(ros_count) as ros_per_node, \n       pc.statistics_type, \n       pc.statistics_updated_timestamp \nFROM projection_columns pc \n left outer join column_storage ps using (projection_id,column_id) \nWHERE pc.projection_id = (select projection_id FROM projections \n                          WHERE projection_basename = ? \n                            and projection_schema = ? \n                            limit 1) \nGROUP BY 1,2,3,4,5,6,7,8,13,14 \nORDER BY pc.column_position ";
        LogMgr.logMetadataSql(new CallerInfo(){}, "projection columns", string3, new Object[0]);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            DataStore dataStore2;
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            dataStore = dataStore2 = new DataStore(resultSet, true);
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "projection columns", string3, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return null;
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return dataStore;
    }
}

