/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.vertica;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DataTypeResolver;
import workbench.db.JdbcTableDefinitionReader;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class VerticaTableDefinitionReader
extends JdbcTableDefinitionReader {
    private String retrieveTableColumns = "SELECT attname as name, \n       atttypid as typeid, \n       typname as type, \n       attnotnull as notnullable, \n       atthasdef as hasdefault, \n       attisidentity as isidentity, \n       attnum as position \nFROM v_internal.vs_columns \nWHERE relname = ? and nspname = ? \nORDER BY attnum";
    private String retrieveViewColumns = "SELECT column_name as name, \n       data_type_id as typeid, \n       data_type as type, \n       null as notnullable, \n       null as isidentity, \n       ordinal_position as position \nFROM v_internal.vs_view_columns \nWHERE table_name = ? and table_schema = ? \nORDER BY ordinal_position";

    public VerticaTableDefinitionReader(WbConnection wbConnection) {
        super(wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ColumnIdentifier> getTableColumns(TableIdentifier tableIdentifier, DataTypeResolver dataTypeResolver) throws SQLException {
        if (!tableIdentifier.getSchema().equals("v_internal")) {
            return super.getTableColumns(tableIdentifier, dataTypeResolver);
        }
        String string = StringUtil.trimQuotes(tableIdentifier.getSchema());
        String string2 = StringUtil.trimQuotes(tableIdentifier.getTableName());
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        String string3 = tableIdentifier.getObjectType().equals("SYSTEM TABLE") ? this.retrieveTableColumns : this.retrieveViewColumns;
        try {
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string3);
            LogMgr.logMetadataSql(new CallerInfo(){}, "columns", string3, string2, string);
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet != null && resultSet.next()) {
                ColumnIdentifier columnIdentifier = new ColumnIdentifier(resultSet.getString("name"));
                columnIdentifier.setDbmsType(resultSet.getString("type"));
                columnIdentifier.setIsNullable(!resultSet.getBoolean("notnullable"));
                columnIdentifier.setIsAutoincrement(resultSet.getBoolean("isidentity"));
                columnIdentifier.setPosition(resultSet.getInt("position"));
                arrayList.add(columnIdentifier);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "columns", string3, string2, string);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }
}

