/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import workbench.WbManager;
import workbench.db.WbConnection;
import workbench.gui.MainWindow;
import workbench.gui.components.PlainEditor;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbOptionPane;
import workbench.interfaces.SimplePropertyEditor;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.NumberStringCache;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class WbSwingUtilities {
    public static final String PROP_ERROR_MSG_WRAP = "workbench.sql.error.wordwrap";
    public static final LineBorder FOCUSED_CELL_BORDER = new LineBorder(Color.YELLOW);
    public static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder();
    public static final Border FLAT_BUTTON_BORDER = new CompoundBorder(BorderFactory.createEtchedBorder(), new EmptyBorder(1, 6, 1, 6));
    public static final KeyStroke CTRL_TAB = KeyStroke.getKeyStroke("control TAB");
    public static final KeyStroke TAB = KeyStroke.getKeyStroke("TAB");
    public static final KeyStroke SHIFT_TAB = KeyStroke.getKeyStroke("shift TAB");
    public static final KeyStroke ENTER = KeyStroke.getKeyStroke("ENTER");
    public static final KeyStroke CTRL_ENTER = KeyStroke.getKeyStroke("control ENTER");
    public static final KeyStroke ALT_ENTER = KeyStroke.getKeyStroke("alt ENTER");
    public static final int CONTINUE_OPTION = 1042;
    public static final int IGNORE_ALL = 2042;
    public static final int IGNORE_ONE = 3042;
    public static final int EXECUTE_ALL = 4042;

    public static Insets getEmptyInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public static Border getBevelBorder() {
        return WbSwingUtilities.createBevelBorder(1);
    }

    private static Border createBevelBorder(int n) {
        BevelBorder bevelBorder = new BevelBorder(n);
        return new BevelBorder(n, bevelBorder.getHighlightOuterColor(), Color.LIGHT_GRAY, bevelBorder.getHighlightInnerColor(), bevelBorder.getShadowInnerColor());
    }

    public static boolean containsComponent(JComponent jComponent, JComponent jComponent2) {
        Component[] componentArray = jComponent.getComponents();
        if (componentArray == null || componentArray.length == 0) {
            return false;
        }
        for (Component component : componentArray) {
            if (component != jComponent2) continue;
            return true;
        }
        return false;
    }

    public static boolean isNearlyBlack(Color color) {
        if (color == null) {
            return false;
        }
        return color.getRed() <= 100 && color.getBlue() <= 100 && color.getGreen() <= 100;
    }

    public static Color getContrastColor(Color color) {
        if (color == null) {
            return Color.BLACK;
        }
        double d = 0.5;
        switch (GuiSettings.getConstrastColorFormula()) {
            case 1: {
                d = (0.2126 * (double)color.getRed() + 0.7152 * (double)color.getGreen() + 0.0722 * (double)color.getBlue()) / 255.0;
                break;
            }
            case 2: {
                d = Math.sqrt(Math.pow(0.299 * (double)color.getRed(), 2.0) + Math.pow(0.587 * (double)color.getGreen(), 2.0) + Math.pow(0.114 * (double)color.getBlue(), 2.0));
                break;
            }
            case 3: {
                d = (0.299 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue()) / 255.0;
            }
        }
        return d >= 0.5 ? Color.BLACK : Color.WHITE;
    }

    public static void waitForEmptyQueue() {
        if (EventQueue.isDispatchThread()) {
            return;
        }
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        int n = 0;
        while (eventQueue.peekEvent() != null) {
            WbThread.sleepSilently(25L);
            if (++n <= 20) continue;
            LogMgr.logDebug(new CallerInfo(){}, "Queue still not empty after 20 tries!");
            break;
        }
    }

    public static void setLabel(JLabel jLabel, String string, String string2) {
        WbSwingUtilities.invoke(() -> {
            jLabel.setText(string);
            jLabel.setToolTipText(string2);
            WbSwingUtilities.callRepaint(jLabel);
        });
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public static void invoke(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error executing on EventQueue", exception);
            }
        }
    }

    public static String displayString(Dimension dimension) {
        if (dimension == null) {
            return "";
        }
        return "[w:" + (int)dimension.getWidth() + ",h:" + (int)dimension.getHeight() + "]";
    }

    public static String displayString(Rectangle rectangle) {
        if (rectangle == null) {
            return "";
        }
        return "[x: " + rectangle.x + ", y: " + rectangle.y + ", w:" + (int)rectangle.getWidth() + ",h:" + (int)rectangle.getHeight() + "]";
    }

    public static String displayString(int n, int n2) {
        return "[x:" + n + ",y:" + n2 + "]";
    }

    public static boolean isOutsideOfScreen(Rectangle rectangle) {
        return !WbSwingUtilities.isFullyVisible(rectangle);
    }

    public static Rectangle getVirtualBounds() {
        Rectangle rectangle = null;
        if (Settings.getInstance().getBoolProperty("workbench.gui.screensize.check.monitors", true)) {
            GraphicsDevice[] graphicsDeviceArray;
            Rectangle rectangle2 = new Rectangle();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
                GraphicsConfiguration[] graphicsConfigurationArray;
                for (GraphicsConfiguration graphicsConfiguration : graphicsConfigurationArray = graphicsDevice.getConfigurations()) {
                    rectangle2 = rectangle2.union(graphicsConfiguration.getBounds());
                }
            }
            rectangle = rectangle2;
        } else {
            Dimension dimension = WbSwingUtilities.getScreenSize();
            rectangle = new Rectangle(dimension);
        }
        return rectangle;
    }

    public static boolean isFullyVisible(int n, int n2, Dimension dimension) {
        return WbSwingUtilities.isFullyVisible(new Rectangle(n, n2, dimension.width, dimension.height));
    }

    public static boolean isFullyVisible(Point point, Dimension dimension) {
        return WbSwingUtilities.isFullyVisible(new Rectangle(point, dimension));
    }

    public static boolean isFullyVisible(Rectangle rectangle) {
        Rectangle rectangle2 = WbSwingUtilities.getVirtualBounds();
        return rectangle2.intersects(rectangle);
    }

    public static void center(Window window, Component component) {
        Point point = WbSwingUtilities.getLocationToCenter(window, component);
        if (!WbSwingUtilities.isFullyVisible(point, window.getSize())) {
            point = WbSwingUtilities.getLocationToCenter(window, null);
        }
        window.setLocation(point);
    }

    public static MainWindow getMainWindow(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window instanceof MainWindow) {
            return (MainWindow)window;
        }
        return null;
    }

    public static Window getWindowAncestor(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return SwingUtilities.getWindowAncestor(component);
    }

    public static Insets getScreenOffset() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        return insets;
    }

    public static Dimension getScreenSize() {
        return WbSwingUtilities.getScreenSize(WbSwingUtilities.getScreenOffset());
    }

    public static Dimension getScreenSize(Insets insets) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.bottom + insets.top;
        return dimension;
    }

    public static Point getLocationToCenter(Window window, Component component) {
        int n;
        int n2;
        int n3;
        int n4;
        Insets insets = WbSwingUtilities.getScreenOffset();
        Dimension dimension = WbSwingUtilities.getScreenSize(insets);
        boolean bl = false;
        if (component == null) {
            n4 = (int)dimension.getWidth();
            n3 = (int)dimension.getHeight();
            bl = true;
        } else {
            n4 = component.getWidth();
            n3 = component.getHeight();
        }
        if (window == null) {
            n2 = 0;
            n = 0;
        } else {
            n2 = window.getWidth();
            n = window.getHeight();
            if (n2 > n4 || n > n3) {
                n4 = (int)dimension.getWidth();
                n3 = (int)dimension.getHeight();
                bl = true;
            }
        }
        int n5 = 1;
        int n6 = 1;
        if (n4 > n2) {
            n5 = n4 / 2 - n2 / 2;
        }
        if (n3 > n) {
            n6 = n3 / 2 - n / 2;
        }
        if (bl && insets != null) {
            n5 += insets.left;
            n5 += insets.top;
        }
        if (component != null && component.isVisible() && !bl) {
            try {
                Point point = component.getLocationOnScreen();
                n5 = (int)((double)n5 + point.getX());
                n6 = (int)((double)n6 + point.getY());
            }
            catch (Exception exception) {
                LogMgr.logWarning(new CallerInfo(){}, "Error getting parent location!", exception);
            }
        }
        return new Point(n5, n6);
    }

    public static void showWaitCursorOnWindow(Component component) {
        WbSwingUtilities.showCursor(Cursor.getPredefinedCursor(3), component, true, false);
    }

    public static void showDefaultCursorOnWindow(Component component) {
        WbSwingUtilities.showDefaultCursor(component, true);
    }

    public static void showWaitCursor(Component component) {
        WbSwingUtilities.showCursor(Cursor.getPredefinedCursor(3), component, false, true);
    }

    public static void showDefaultCursor(Component component) {
        WbSwingUtilities.showDefaultCursor(component, false);
    }

    public static void showDefaultCursor(Component component, boolean bl) {
        WbSwingUtilities.showCursor(null, component, bl, true);
    }

    private static void showCursor(Cursor cursor, Component component, boolean bl, boolean bl2) {
        if (component == null) {
            return;
        }
        Runnable runnable = () -> {
            Window window;
            component.setCursor(cursor);
            if (bl && (window = WbSwingUtilities.getWindowAncestor(component)) != null) {
                window.setCursor(cursor);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else if (bl2) {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Throwable throwable) {}
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    public static void showErrorMessageKey(Component component, String string) {
        WbSwingUtilities.showErrorMessage(component, "SQL Workbench/J", ResourceMgr.getString(string));
    }

    public static void showErrorMessage(String string) {
        WbSwingUtilities.showErrorMessage(null, "SQL Workbench/J", string);
    }

    public static void showErrorMessage(Component component, String string) {
        WbSwingUtilities.showErrorMessage(component, "SQL Workbench/J", string);
    }

    public static void showFriendlyErrorMessage(Component component, String string) {
        WbSwingUtilities.showFriendlyErrorMessage(component, "SQL Workbench/J", string);
    }

    public static void showFriendlyErrorMessage(Component component, String string, String string2) {
        int n = Settings.getInstance().getIntProperty("workbench.gui.message.maxlength", 100);
        if (string2.length() > n || string2.indexOf(10) > 0 || string2.indexOf(13) > 0) {
            WbSwingUtilities.showMultiLineError(component, string, string2);
        } else {
            WbSwingUtilities.showErrorMessage(component, string, string2);
        }
    }

    public static void showErrorMessage(Component component, String string, String string2) {
        if (WbManager.getInstance().isBatchMode()) {
            LogMgr.logError(new CallerInfo(){}, string + " - " + string2, null);
            return;
        }
        Window window = component == null ? WbManager.getInstance().getCurrentWindow() : WbSwingUtilities.getWindowAncestor(component);
        WbSwingUtilities.invoke(() -> JOptionPane.showMessageDialog(window, string2, string, 0));
    }

    public static void showMultiLineError(Component component, String string, String string2) {
        if (WbManager.getInstance().isBatchMode()) {
            LogMgr.logError(new CallerInfo(){}, string2, null);
            return;
        }
        Window window = component == null ? WbManager.getInstance().getCurrentWindow() : WbSwingUtilities.getWindowAncestor(component);
        WbSwingUtilities.invoke(() -> {
            PlainEditor plainEditor = WbSwingUtilities.createErrorMessagePanel(string2, "workbench.editor.plain.wordwrap", true);
            WbOptionPane wbOptionPane = new WbOptionPane(plainEditor, 0, -1);
            JDialog jDialog = wbOptionPane.createDialog(WbSwingUtilities.getWindowAncestor(window), string);
            jDialog.setDefaultCloseOperation(2);
            jDialog.setResizable(true);
            jDialog.pack();
            jDialog.setVisible(true);
        });
    }

    public static PlainEditor createErrorMessagePanel(String string, String string2, boolean bl) {
        final String string3 = StringUtil.getMaxSubstring(StringUtil.getLongestLine(string, 15), 80);
        PlainEditor plainEditor = new PlainEditor(string2, false, bl){
            private final int minLineCount = 6;
            private final int maxVisibleLines = 15;
            {
                super(string, bl, bl2);
                this.minLineCount = 6;
                this.maxVisibleLines = 15;
            }

            private int getCharWidth(FontMetrics fontMetrics) {
                int n = fontMetrics.getMaxAdvance();
                if (n <= 0) {
                    n = fontMetrics.stringWidth("M");
                }
                return n;
            }

            @Override
            public Dimension getPreferredSize() {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int n = fontMetrics.stringWidth(string3);
                int n2 = n + this.getCharWidth(fontMetrics) * 4 + this.getScrollbarWidth();
                int n3 = fontMetrics.getHeight();
                int n4 = n3 * 6 + this.getScrollbarHeight();
                int n5 = this.getLineCount();
                if (n5 >= 6) {
                    n4 = n3 * Math.min(n5, 15);
                }
                Dimension dimension = new Dimension(n2, (int)((double)n4 * 1.2));
                return dimension;
            }

            @Override
            public Dimension getMinimumSize() {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int n = this.getCharWidth(fontMetrics) * 25;
                int n2 = fontMetrics.getHeight();
                int n3 = n2 * 6 + this.getScrollbarHeight();
                return new Dimension(n, (int)((double)n3 * 1.2));
            }

            @Override
            public Dimension getMaximumSize() {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int n = this.getCharWidth(fontMetrics) * 80;
                int n2 = fontMetrics.getHeight();
                int n3 = n2 * 25;
                return new Dimension(n, n3);
            }
        };
        plainEditor.removeBorders();
        plainEditor.setText(string);
        plainEditor.setCaretPosition(0);
        plainEditor.setBorder(new EtchedBorder(1));
        plainEditor.restoreSettings();
        plainEditor.setFocusable(false);
        return plainEditor;
    }

    public static void showMessage(Component component, Object object) {
        WbSwingUtilities.showMessage(component, object, 1);
    }

    public static void showMessage(Component component, Object object, int n) {
        WbSwingUtilities.invoke(() -> JOptionPane.showMessageDialog(component, object, "SQL Workbench/J", n));
    }

    public static void showMessage(Component component, String string, Object object) {
        WbSwingUtilities.invoke(() -> JOptionPane.showMessageDialog(component, object, string, -1));
    }

    public static void showMessageKey(Component component, String string) {
        WbSwingUtilities.invoke(() -> JOptionPane.showMessageDialog(component, ResourceMgr.getString(string), "SQL Workbench/J", 1));
    }

    public static boolean getYesNo(Component component, String string) {
        return WbSwingUtilities.getYesNo(null, component, string);
    }

    public static boolean getYesNo(String string, Component component, String string2) {
        int n = JOptionPane.showConfirmDialog(WbSwingUtilities.getWindowAncestor(component), string2, string == null ? "SQL Workbench/J" : string, 0, 3);
        return n == 0;
    }

    public static int getYesNoCancel(Component component, String string) {
        int n = JOptionPane.showConfirmDialog(WbSwingUtilities.getWindowAncestor(component), string, "SQL Workbench/J", 1, 3);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getProceedCancel(Component component, String string, Object ... objectArray) {
        Object[] objectArray2 = new String[]{ResourceMgr.getPlainString("LblProceed"), ResourceMgr.getPlainString("LblCancel")};
        String string2 = ResourceMgr.getFormattedString(string, objectArray);
        WbOptionPane wbOptionPane = new WbOptionPane(string2, 3, 1, null, objectArray2);
        JDialog jDialog = wbOptionPane.createDialog(WbSwingUtilities.getWindowAncestor(component), "SQL Workbench/J");
        jDialog.setDefaultCloseOperation(2);
        try {
            WbSwingUtilities.invoke(() -> {
                jDialog.setResizable(false);
                jDialog.pack();
                jDialog.setVisible(true);
            });
        }
        finally {
            jDialog.dispose();
        }
        Object object = wbOptionPane.getValue();
        if (object == null) {
            return false;
        }
        return object.equals(objectArray2[0]);
    }

    private static JLabel createMessageLabel(String string) {
        Color color = UIManager.getColor("OptionPane.messageForeground");
        Font font = UIManager.getFont("OptionPane.messageFont");
        JLabel jLabel = new JLabel(string, 10);
        if (color != null) {
            jLabel.setForeground(color);
        }
        if (font != null) {
            jLabel.setFont(font);
        }
        return new JLabel(string, 2);
    }

    public static JPanel getMultilineLabel(String string) {
        List<String> list = StringUtil.getLines(string);
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
        for (String string2 : list) {
            jPanel.add(WbSwingUtilities.createMessageLabel(string2));
        }
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getYesNoIgnoreAll(Component component, Object object) {
        Object[] objectArray = new String[]{ResourceMgr.getString("LblYes"), ResourceMgr.getString("LblNo"), ResourceMgr.getString("LblIgnoreAll")};
        WbOptionPane wbOptionPane = new WbOptionPane(object, 3, 1, null, objectArray);
        JDialog jDialog = wbOptionPane.createDialog(WbSwingUtilities.getWindowAncestor(component), "SQL Workbench/J");
        jDialog.setDefaultCloseOperation(2);
        int n = -1;
        try {
            jDialog.setResizable(true);
            jDialog.pack();
            jDialog.setVisible(true);
            Object object2 = wbOptionPane.getValue();
            n = object2 == null ? 0 : (object2.equals(objectArray[0]) ? 0 : (object2.equals(objectArray[1]) ? 1 : (object2.equals(objectArray[2]) ? 2042 : 1)));
        }
        finally {
            jDialog.dispose();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getYesNoExecuteAll(Component component, String string) {
        Object[] objectArray = new String[]{ResourceMgr.getPlainString("LblYes"), ResourceMgr.getPlainString("LblExecuteAll"), ResourceMgr.getPlainString("LblNo"), ResourceMgr.getPlainString("LblCancel")};
        Object object = string;
        if (string.startsWith("<html>")) {
            object = new JLabel(string);
        }
        WbOptionPane wbOptionPane = new WbOptionPane(object, 3, 1, null, objectArray);
        JDialog jDialog = wbOptionPane.createDialog(component, "SQL Workbench/J");
        try {
            jDialog.setResizable(true);
            jDialog.pack();
            jDialog.setVisible(true);
            Object object2 = wbOptionPane.getValue();
            if (object2 == null) {
                int n = 0;
                return n;
            }
            if (object2.equals(objectArray[0])) {
                int n = 0;
                return n;
            }
            if (object2.equals(objectArray[1])) {
                int n = 4042;
                return n;
            }
            if (object2.equals(objectArray[2])) {
                int n = 1;
                return n;
            }
            if (object2.equals(objectArray[3])) {
                int n = 2;
                return n;
            }
            int n = 1;
            return n;
        }
        finally {
            jDialog.dispose();
        }
    }

    public static int getYesNo(Component component, String string, String string2, String string3, String string4) {
        if (StringUtil.isEmptyString(string3)) {
            string3 = ResourceMgr.getString("MsgConfirmYes");
        }
        if (StringUtil.isEmptyString(string4)) {
            string4 = ResourceMgr.getString("MsgConfirmNo");
        }
        return WbSwingUtilities.getYesNo(component, string, string2, new String[]{string3, string4}, -1);
    }

    public static int getYesNo(Component component, String string, String[] stringArray) {
        return WbSwingUtilities.getYesNo(component, "SQL Workbench/J", string, stringArray, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getYesNo(Component component, String string, String string2, String[] stringArray, int n) {
        WbOptionPane wbOptionPane = new WbOptionPane(string2, 3, 0, null, stringArray, stringArray[1]);
        wbOptionPane.setMessageType(n);
        JDialog jDialog = wbOptionPane.createDialog(component, string);
        try {
            jDialog.setResizable(true);
            jDialog.pack();
            jDialog.setVisible(true);
            Object object = wbOptionPane.getValue();
            if (object == null) {
                int n2 = 0;
                return n2;
            }
            if (object.equals(stringArray[0])) {
                int n3 = 0;
                return n3;
            }
            if (object.equals(stringArray[1])) {
                int n4 = 1;
                return n4;
            }
            int n5 = -1;
            return n5;
        }
        finally {
            jDialog.dispose();
        }
    }

    public static boolean getOKCancel(String string, Component component, Component component2) {
        return WbSwingUtilities.getOKCancel(string, component, component2, null);
    }

    public static boolean getOKCancel(String string, Component component, Component component2, final Runnable runnable) {
        Object object;
        WbOptionPane wbOptionPane = new WbOptionPane(component2, -1, 2);
        JDialog jDialog = wbOptionPane.createDialog(component, string);
        jDialog.setDefaultCloseOperation(2);
        if (runnable != null) {
            object = new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    WbSwingUtilities.invoke(runnable);
                }
            };
            jDialog.addWindowListener((WindowListener)object);
        }
        jDialog.setResizable(true);
        jDialog.pack();
        jDialog.setVisible(true);
        jDialog.dispose();
        object = wbOptionPane.getValue();
        if (object == null) {
            return false;
        }
        if (object instanceof Number) {
            int n = ((Number)object).intValue();
            return n == 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransactionEnd getCommitRollbackQuestion(Component component, String string) {
        Object object;
        Serializable serializable;
        Object[] objectArray = new String[]{ResourceMgr.getString("LblCommit"), ResourceMgr.getString("LblRollback")};
        WbOptionPane wbOptionPane = new WbOptionPane(string, 3, 0, null, objectArray);
        int n = 0;
        try {
            serializable = wbOptionPane.getFont();
            object = wbOptionPane.getFontMetrics((Font)serializable);
            n = ((FontMetrics)object).stringWidth(string);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not detect string width", throwable);
            n = 300;
        }
        serializable = wbOptionPane.createDialog(component, "SQL Workbench/J");
        try {
            ((JDialog)serializable).setDefaultCloseOperation(2);
            ((Window)serializable).setSize(n + 130, ((Component)serializable).getHeight());
            ((Dialog)serializable).setResizable(true);
            ((Dialog)serializable).setVisible(true);
            object = wbOptionPane.getValue();
            if (object != null && object.equals(objectArray[0])) {
                TransactionEnd transactionEnd = TransactionEnd.Commit;
                return transactionEnd;
            }
            TransactionEnd transactionEnd = TransactionEnd.Rollback;
            return transactionEnd;
        }
        finally {
            ((Window)serializable).dispose();
        }
    }

    public static String passwordPrompt(Component component, String string, String string2) {
        final JPasswordField jPasswordField = new JPasswordField();
        JPanel jPanel = new JPanel(new BorderLayout(0, 5));
        jPanel.setBorder(new EmptyBorder(0, 0, 16, 0));
        jPanel.add((Component)new JLabel(string2), "First");
        jPanel.add((Component)jPasswordField, "Center");
        WbThread wbThread = new WbThread("GetFocus"){

            @Override
            public void run() {
                jPasswordField.requestFocus();
            }
        };
        boolean bl = WbSwingUtilities.getOKCancel(string, component == null ? WbManager.getInstance().getCurrentWindow() : component, jPanel, wbThread);
        if (!bl) {
            return null;
        }
        return ((JTextComponent)jPasswordField).getText();
    }

    public static String getUserInput(Component component, String string, String string2) {
        return WbSwingUtilities.getUserInput(component, string, string2, UserInputType.TEXT, 40);
    }

    public static String getUserInputHidden(Component component, String string, String string2) {
        return WbSwingUtilities.getUserInput(component, string, string2, UserInputType.HIDDEN, 40);
    }

    public static String getUserInputNumber(Component component, String string, String string2) {
        return WbSwingUtilities.getUserInput(component, string, string2, UserInputType.NUMBER, 40);
    }

    private static String getUserInput(Component component, String string, String string2, UserInputType userInputType, int n) {
        Object object;
        JTextField jTextField;
        Window window = WbSwingUtilities.getWindowAncestor(component);
        switch (userInputType) {
            case NUMBER: {
                jTextField = new JTextField();
                Document document = jTextField.getDocument();
                if (!(document instanceof AbstractDocument)) break;
                object = (AbstractDocument)document;
                ((AbstractDocument)object).setDocumentFilter(new DocumentFilter(){

                    @Override
                    public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                        int n2 = string.length();
                        if (Character.isDigit(string.charAt(n2 - 1))) {
                            super.insertString(filterBypass, n, string, attributeSet);
                        }
                    }

                    @Override
                    public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                        int n3 = string.length();
                        if (Character.isDigit(string.charAt(n3 - 1))) {
                            super.replace(filterBypass, n, n2, string, attributeSet);
                        }
                    }
                });
                break;
            }
            case HIDDEN: {
                jTextField = new JPasswordField();
                break;
            }
            default: {
                jTextField = new JTextField();
            }
        }
        jTextField.setColumns(n);
        jTextField.setText(string2);
        if (string2 != null) {
            jTextField.selectAll();
        }
        jTextField.addMouseListener(new TextComponentMouseListener());
        boolean bl = ValidatingDialog.showConfirmDialog(window, jTextField, string);
        if (!bl) {
            return null;
        }
        object = jTextField.getText();
        return object;
    }

    public static String getKeyName(int n) {
        if (n >= 48 && n <= 57 || n >= 65 && n <= 90) {
            return String.valueOf((char)n);
        }
        int n2 = ",./;=[\\]".indexOf(n);
        if (n2 >= 0) {
            return String.valueOf((char)n);
        }
        switch (n) {
            case 10: {
                return "VK_ENTER";
            }
            case 8: {
                return "VK_BACK_SPACE";
            }
            case 9: {
                return "VK_TAB";
            }
            case 3: {
                return "VK_CANCEL";
            }
            case 12: {
                return "VK_CLEAR";
            }
            case 16: {
                return "VK_SHIFT";
            }
            case 17: {
                return "VK_CONTROL";
            }
            case 18: {
                return "VK_ALT";
            }
            case 19: {
                return "VK_PAUSE";
            }
            case 20: {
                return "VK_CAPS_LOCK";
            }
            case 27: {
                return "VK_ESCAPE";
            }
            case 32: {
                return "VK_SPACE";
            }
            case 33: {
                return "VK_PAGE_UP";
            }
            case 34: {
                return "VK_PAGE_DOWN";
            }
            case 35: {
                return "VK_END";
            }
            case 36: {
                return "VK_HOME";
            }
            case 37: 
            case 226: {
                return "VK_LEFT";
            }
            case 38: 
            case 224: {
                return "VK_UP";
            }
            case 39: 
            case 227: {
                return "VK_RIGHT";
            }
            case 40: 
            case 225: {
                return "VK_DOWN";
            }
            case 112: {
                return "F1";
            }
            case 113: {
                return "F2";
            }
            case 114: {
                return "F3";
            }
            case 115: {
                return "F4";
            }
            case 116: {
                return "F5";
            }
            case 117: {
                return "F6";
            }
            case 118: {
                return "F7";
            }
            case 119: {
                return "F8";
            }
            case 120: {
                return "F9";
            }
            case 121: {
                return "F10";
            }
            case 122: {
                return "F11";
            }
            case 123: {
                return "F12";
            }
            case 61440: {
                return "F13";
            }
            case 61441: {
                return "F14";
            }
            case 61442: {
                return "F15";
            }
            case 61443: {
                return "F16";
            }
            case 61444: {
                return "F17";
            }
            case 61445: {
                return "F18";
            }
            case 61446: {
                return "F19";
            }
            case 61447: {
                return "F20";
            }
            case 61448: {
                return "F21";
            }
            case 61449: {
                return "F22";
            }
            case 61450: {
                return "F23";
            }
            case 61451: {
                return "F24";
            }
        }
        if (n >= 96 && n <= 105) {
            char c = (char)(n - 96 + 48);
            return "NumPad-" + c;
        }
        return "KeyCode: 0x" + Integer.toString(n, 16);
    }

    public static void callRepaint(Component component) {
        if (component == null) {
            return;
        }
        component.invalidate();
        component.repaint();
    }

    public static void repaintNow(Component component) {
        if (component == null) {
            return;
        }
        WbSwingUtilities.invoke(() -> WbSwingUtilities.callRepaint(component));
    }

    public static void repaintLater(Component component) {
        if (component == null) {
            return;
        }
        EventQueue.invokeLater(() -> WbSwingUtilities.callRepaint(component));
    }

    public static void requestComponentFocus(final Window window, final JComponent jComponent) {
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                EventQueue.invokeLater(jComponent::requestFocus);
                window.removeWindowListener(this);
            }
        });
    }

    public static void requestFocus(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        EventQueue.invokeLater(jComponent::requestFocus);
    }

    public static void initPropertyEditors(Object object, JComponent jComponent) {
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            if (component instanceof SimplePropertyEditor) {
                SimplePropertyEditor simplePropertyEditor = (SimplePropertyEditor)((Object)component);
                String string = component.getName();
                if (StringUtil.isEmptyString(string)) continue;
                simplePropertyEditor.setSourceObject(object, string);
                simplePropertyEditor.setImmediateUpdate(true);
                continue;
            }
            if (!(component instanceof JComponent)) continue;
            WbSwingUtilities.initPropertyEditors(object, (JComponent)component);
        }
    }

    public static boolean isConnectionIdle(Component component, WbConnection wbConnection) {
        if (wbConnection.isBusy()) {
            WbSwingUtilities.showMessageKey(SwingUtilities.getWindowAncestor(component), "ErrConnectionBusy");
            return false;
        }
        return true;
    }

    public static void dumpActionMap(JComponent jComponent) {
        System.out.println("InputMap for WHEN_ANCESTOR_OF_FOCUSED_COMPONENT");
        System.out.println("-----------------------------------------------");
        WbSwingUtilities.dumpInputMap(jComponent.getInputMap(1));
        System.out.println("\nInputMap for WHEN_FOCUSED");
        System.out.println("-------------------------");
        WbSwingUtilities.dumpInputMap(jComponent.getInputMap(0));
        System.out.println("\nInputMap for WHEN_IN_FOCUSED_WINDOW");
        System.out.println("-----------------------------------");
        WbSwingUtilities.dumpInputMap(jComponent.getInputMap(2));
    }

    private static void dumpInputMap(InputMap inputMap) {
        if (inputMap != null && inputMap.allKeys() != null) {
            for (KeyStroke keyStroke : inputMap.allKeys()) {
                if (keyStroke == null) continue;
                Object object = inputMap.get(keyStroke);
                System.out.println("key: " + keyStroke + " mapped to " + object.toString());
            }
        } else {
            System.out.println("Nothing mapped");
        }
    }

    public static void setMinimumSize(JComponent jComponent, int n, int n2) {
        Font font = jComponent.getFont();
        if (font != null) {
            FontMetrics fontMetrics = jComponent.getFontMetrics(font);
            int n3 = fontMetrics.stringWidth("M");
            int n4 = fontMetrics.getHeight();
            Dimension dimension = new Dimension(n3 * n2, n4 * n);
            jComponent.setPreferredSize(dimension);
        }
    }

    public static void setMinimumSizeFromCols(JTextField jTextField) {
        int n = jTextField.getColumns();
        jTextField.setColumns(0);
        WbSwingUtilities.setMinimumSize(jTextField, n);
    }

    public static void setMinimumSize(JComponent jComponent, int n) {
        int n2 = WbSwingUtilities.calculateCharWidth(jComponent, n);
        if (n2 > 0) {
            Dimension dimension = jComponent.getPreferredSize();
            Dimension dimension2 = new Dimension(n2, dimension.height);
            jComponent.setPreferredSize(dimension2);
        }
    }

    public static int calculateCharWidth(JComponent jComponent, int n) {
        if (n < 0) {
            return -1;
        }
        if (jComponent == null) {
            return -1;
        }
        int n2 = -1;
        Font font = jComponent.getFont();
        if (font != null) {
            FontMetrics fontMetrics = jComponent.getFontMetrics(font);
            int n3 = fontMetrics.stringWidth("M");
            n2 = n3 * n;
        }
        return n2;
    }

    public static String choiceToString(int n) {
        switch (n) {
            case 0: {
                return "OK_OPTION";
            }
            case 2: {
                return "CANCEL_OPTION";
            }
            case 1: {
                return "NO_OPTION";
            }
            case -1: {
                return "CLOSED_OPTION";
            }
        }
        return NumberStringCache.getNumberString(n);
    }

    public static void showToolTip(JComponent jComponent, String string) {
        if (jComponent == null) {
            return;
        }
        if (!jComponent.isShowing()) {
            return;
        }
        Point point = null;
        try {
            point = jComponent.getLocationOnScreen();
        }
        catch (Exception exception) {
            point = null;
        }
        if (point == null) {
            return;
        }
        JToolTip jToolTip = jComponent.createToolTip();
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        jToolTip.setTipText(string);
        final Popup popup = popupFactory.getPopup(jComponent, jToolTip, (int)point.getX(), (int)point.getY() - (int)jToolTip.getPreferredSize().getHeight());
        final int n = ToolTipManager.sharedInstance().getDismissDelay();
        WbThread wbThread = new WbThread("Tooltip Hider"){

            @Override
            public void run() {
                WbThread.sleepSilently(n);
                popup.hide();
            }
        };
        wbThread.start();
        popup.show();
        jToolTip.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                popup.hide();
            }
        });
    }

    public static int calculateMaxMenuItems(JFrame jFrame) {
        FontMetrics fontMetrics;
        FontMetrics fontMetrics2;
        UIDefaults uIDefaults = UIManager.getDefaults();
        Font font = uIDefaults.getFont("MenuItem.font");
        Font font2 = uIDefaults.getFont("MenuBar.font");
        int n = 16;
        int n2 = 24;
        FontMetrics fontMetrics3 = fontMetrics2 = font == null ? null : jFrame.getFontMetrics(font);
        if (fontMetrics2 != null) {
            n = fontMetrics2.getHeight();
        } else if (font != null) {
            n = WbSwingUtilities.convertPointSizeToPixel(font.getSize());
        }
        FontMetrics fontMetrics4 = fontMetrics = font2 == null ? null : jFrame.getFontMetrics(font2);
        if (fontMetrics != null) {
            n2 = fontMetrics.getHeight();
        } else if (font2 != null) {
            n2 = WbSwingUtilities.convertPointSizeToPixel(font2.getSize());
        }
        Insets insets = uIDefaults.getInsets("MenuItem.margin");
        if (insets != null) {
            n += insets.top + insets.bottom;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = (int)dimension.getHeight();
        int n4 = n3 - n2 * 3;
        int n5 = n4 / n;
        return n5;
    }

    public static int convertPointSizeToPixel(int n) {
        int n2 = Toolkit.getDefaultToolkit().getScreenResolution();
        int n3 = n * n2 / 72;
        return n3;
    }

    public static void adjustButtonWidth(JButton jButton, int n, int n2) {
        FontMetrics fontMetrics;
        Font font = jButton.getFont();
        if (font != null && (fontMetrics = jButton.getFontMetrics(font)) != null && StringUtil.isNonEmpty(jButton.getText())) {
            Rectangle2D rectangle2D = font.getStringBounds(jButton.getText(), fontMetrics.getFontRenderContext());
            int n3 = (int)rectangle2D.getWidth() + 2;
            int n4 = Math.max((int)rectangle2D.getHeight(), n2);
            Dimension dimension = new Dimension(Math.max(n3, n), Math.max(n4, n2));
            jButton.setPreferredSize(dimension);
            jButton.setMinimumSize(dimension);
            jButton.setMaximumSize(dimension);
        }
    }

    public static void makeEqualHeight(JComponent jComponent, JComponent ... jComponentArray) {
        if (jComponent == null) {
            return;
        }
        if (jComponentArray == null) {
            return;
        }
        int n = jComponent.getPreferredSize().height;
        for (JComponent jComponent2 : jComponentArray) {
            Dimension dimension = jComponent2.getPreferredSize();
            dimension.height = n;
            jComponent2.setPreferredSize(dimension);
        }
    }

    public static void makeEqualSize(JComponent jComponent, JComponent ... jComponentArray) {
        if (jComponent == null) {
            return;
        }
        if (jComponentArray == null) {
            return;
        }
        Dimension dimension = jComponent.getPreferredSize();
        for (JComponent jComponent2 : jComponentArray) {
            jComponent2.setPreferredSize(dimension);
        }
    }

    public static void makeEqualWidth(JComponent ... jComponentArray) {
        int n = 0;
        for (JComponent jComponent : jComponentArray) {
            Dimension dimension = jComponent.getPreferredSize();
            if (dimension.width <= n) continue;
            n = dimension.width;
        }
        for (JComponent jComponent : jComponentArray) {
            WbSwingUtilities.setPreferredWidth(jComponent, n);
        }
    }

    public static void setPreferredWidth(JComponent jComponent, int n) {
        Dimension dimension = jComponent.getPreferredSize();
        if (dimension.width < n) {
            dimension.width = n;
            jComponent.setPreferredSize(dimension);
        }
    }

    public static void removeAllListeners(JComponent jComponent) {
        MouseListener[] mouseListenerArray;
        if (jComponent == null) {
            return;
        }
        PropertyChangeListener[] propertyChangeListenerArray = jComponent.getPropertyChangeListeners();
        for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray) {
            jComponent.removePropertyChangeListener(propertyChangeListener);
        }
        EventListener[] eventListenerArray = jComponent.getFocusListeners();
        if (eventListenerArray != null) {
            for (EventListener eventListener : eventListenerArray) {
                jComponent.removeFocusListener((FocusListener)eventListener);
            }
        }
        if ((mouseListenerArray = jComponent.getMouseListeners()) != null) {
            for (MouseListener mouseListener : mouseListenerArray) {
                jComponent.removeMouseListener(mouseListener);
            }
        }
    }

    public static int getFontHeight(JComponent jComponent) {
        if (jComponent == null) {
            return 0;
        }
        Font font = jComponent.getFont();
        if (font == null) {
            return 0;
        }
        FontMetrics fontMetrics = jComponent.getFontMetrics(font);
        if (fontMetrics == null) {
            return 16;
        }
        return fontMetrics.getHeight();
    }

    public static void scale(Window window, double d, double d2) {
        Dimension dimension = window.getSize();
        dimension.width = (int)((double)dimension.width * d);
        dimension.height = (int)((double)dimension.height * d2);
        window.setSize(dimension);
    }

    public static String getFlavors(Transferable transferable) {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        String string = "";
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + dataFlavorArray[i].getHumanPresentableName();
        }
        return string;
    }

    public static JComponent findComponentByName(Class clazz, String string, Window window) {
        Container container = null;
        if (window instanceof RootPaneContainer) {
            container = ((RootPaneContainer)((Object)window)).getContentPane();
        }
        if (container == null) {
            return null;
        }
        return WbSwingUtilities.findComponent(clazz, string, container);
    }

    private static JComponent findComponent(Class clazz, String string, Container container) {
        Component[] componentArray;
        if (container == null) {
            return null;
        }
        for (Component component : componentArray = container.getComponents()) {
            JComponent jComponent;
            if (StringUtil.equalString(string, component.getName()) && component.getClass().equals(clazz)) {
                return (JComponent)component;
            }
            if (!(component instanceof Container) || (jComponent = WbSwingUtilities.findComponent(clazz, string, (Container)component)) == null) continue;
            return jComponent;
        }
        return null;
    }

    private static enum UserInputType {
        TEXT,
        NUMBER,
        HIDDEN;

    }

    public static enum TransactionEnd {
        Commit,
        Rollback;

    }
}

