/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.sql.AutomaticRefreshMgr;
import workbench.gui.sql.DwPanel;
import workbench.gui.sql.SqlPanel;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;

public class AutomaticReloadAction
extends WbAction {
    private SqlPanel client;

    public AutomaticReloadAction(SqlPanel sqlPanel) {
        this.initMenuDefinition("MnuTxtReloadAutomatic");
        this.setClient(sqlPanel);
    }

    public final void setClient(SqlPanel sqlPanel) {
        this.client = sqlPanel;
        this.checkEnabled();
    }

    public void checkEnabled() {
        boolean bl = false;
        DwPanel dwPanel = this.client.getCurrentResult();
        if (dwPanel != null) {
            DataStore dataStore = dwPanel.getDataStore();
            bl = dataStore != null ? dataStore.getOriginalConnection() != null : false;
        }
        this.setEnabled(bl);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        DwPanel dwPanel = this.client.getCurrentResult();
        String string = Settings.getInstance().getProperty("workbench.gui.result.refresh.last_interval", null);
        String string2 = WbSwingUtilities.getUserInput(this.client, ResourceMgr.getString("LblRefreshIntv"), string);
        if (string2 == null) {
            return;
        }
        Settings.getInstance().setProperty("workbench.gui.result.refresh.last_interval", string2);
        int n = AutomaticRefreshMgr.parseInterval(string2);
        if (dwPanel != null) {
            this.client.getRefreshMgr().addRefresh(this.client, dwPanel, n);
            this.client.checkAutoRefreshIndicator(dwPanel);
        }
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

